/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.simpletb;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.IGlossaryReader;
import net.sf.okapi.lib.terminology.LangEntry;
import net.sf.okapi.lib.terminology.TermEntry;
import net.sf.okapi.lib.terminology.TermHit;
import net.sf.okapi.lib.terminology.csv.CSVReader;
import net.sf.okapi.lib.terminology.simpletb.Entry;
import net.sf.okapi.lib.terminology.tbx.TBXReader;
import net.sf.okapi.lib.terminology.tsv.TSVReader;

public class SimpleTB {
    private static final String SIGNATURE = "SimpleTB-v1";
    LocaleId srcLoc;
    LocaleId trgLoc;
    private List<Entry> entries;
    private boolean betweenCodes;

    public SimpleTB(LocaleId srcLoc, LocaleId trgLoc) {
        this.srcLoc = srcLoc;
        this.trgLoc = trgLoc;
        this.reset();
    }

    private void reset() {
        this.entries = new ArrayList<Entry>();
    }

    public void initialize(boolean stringSearch, boolean betweenCodes) {
        this.betweenCodes = betweenCodes;
        if (stringSearch) {
            Collections.sort(this.entries);
        }
    }

    public void guessAndImport(File file) {
        String ext = Util.getExtension(file.getPath());
        if (ext.equalsIgnoreCase(".tbx")) {
            this.importTBX(file);
        }
        if (ext.equalsIgnoreCase(".csv")) {
            this.importCSV(file);
        } else {
            this.importTSV(file);
        }
    }

    public void importTBX(File file) {
        this.importGlossary(new TBXReader(), file);
    }

    public void importCSV(File file) {
        this.importGlossary(new CSVReader(this.srcLoc, this.trgLoc), file);
    }

    public void importTSV(File file) {
        this.importGlossary(new TSVReader(this.srcLoc, this.trgLoc), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importGlossary(IGlossaryReader reader, File file) {
        try {
            reader.open(file);
            while (reader.hasNext()) {
                ConceptEntry cent = reader.next();
                if (!cent.hasLocale(this.srcLoc) || !cent.hasLocale(this.trgLoc)) continue;
                LangEntry srcLent = cent.getEntries(this.srcLoc);
                LangEntry trgLent = cent.getEntries(this.trgLoc);
                if (!srcLent.hasTerm() || !trgLent.hasTerm()) continue;
                Entry ent = new Entry(srcLent.getTerm(0).getText());
                ent.setTargetTerm(trgLent.getTerm(0).getText());
                this.entries.add(ent);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void removeAll() {
        this.entries.clear();
    }

    public Entry addEntry(String srcTerm, String trgTerm) {
        Entry ent = new Entry(srcTerm);
        ent.setTargetTerm(trgTerm);
        this.entries.add(ent);
        return ent;
    }

    public List<TermHit> getExistingStrings(TextFragment frag, LocaleId fragmentLoc, LocaleId otherLoc) {
        ArrayList<TermHit> res = new ArrayList<TermHit>();
        boolean searchSource = fragmentLoc.equals(this.srcLoc);
        if (!searchSource && !fragmentLoc.equals(this.trgLoc)) {
            return res;
        }
        StringBuilder text = new StringBuilder(frag);
        Range location = new Range(0, 0);
        for (Entry ent : this.entries) {
            String otherString;
            String stringToMatch;
            if (searchSource) {
                stringToMatch = ent.getSourceTerm();
                otherString = ent.getTargetTerm();
            } else {
                stringToMatch = ent.getTargetTerm();
                otherString = ent.getSourceTerm();
            }
            if (stringToMatch == null || otherString == null) continue;
            while (SimpleTB.isValidMatch(text, stringToMatch, location, this.betweenCodes)) {
                TermHit th = new TermHit();
                th.sourceTerm = new TermEntry(stringToMatch);
                th.targetTerm = new TermEntry(otherString);
                th.range = new Range(location.start, location.end);
                res.add(th);
                for (int i = location.start; i < location.end; ++i) {
                    text.setCharAt(i, '`');
                }
            }
        }
        return res;
    }

    public static boolean isValidMatch(StringBuilder text, String stringToMatch, Range location, boolean betweenCodes) {
        int cp;
        int cp2;
        int n = text.indexOf(stringToMatch);
        if (n == -1) {
            return false;
        }
        if (n > 0 && (Character.getType(cp2 = text.codePointAt(n - 1)) == 2 || Character.getType(cp2) == 1 || Character.getType(cp2) == 3 || Character.getType(cp2) == 9)) {
            return false;
        }
        if (betweenCodes && (n <= 1 || !TextFragment.isMarker(text.charAt(n - 2)))) {
            return false;
        }
        int last = n + stringToMatch.length();
        if (last < text.length() && (Character.getType(cp = text.codePointAt(last)) == 2 || Character.getType(cp) == 1 || Character.getType(cp) == 3 || Character.getType(cp) == 9)) {
            return false;
        }
        if (betweenCodes && (last + 1 > text.length() || !TextFragment.isMarker(text.charAt(last)))) {
            return false;
        }
        location.start = n;
        location.end = last;
        return true;
    }

    public List<TermHit> getExistingTerms(TextFragment frag, LocaleId fragmentLoc, LocaleId otherLoc) {
        String text = TextUnitUtil.getText(frag).toLowerCase();
        List<String> parts = Arrays.asList(text.split("\\s"));
        ArrayList<TermHit> res = new ArrayList<TermHit>();
        boolean searchSource = fragmentLoc.equals(this.srcLoc);
        if (!searchSource && !fragmentLoc.equals(this.trgLoc)) {
            return res;
        }
        for (Entry ent : this.entries) {
            String otherTerm;
            String termToMatch;
            if (searchSource) {
                termToMatch = ent.getSourceTerm();
                otherTerm = ent.getTargetTerm();
            } else {
                termToMatch = ent.getTargetTerm();
                otherTerm = ent.getSourceTerm();
            }
            if (termToMatch == null || otherTerm == null || !parts.contains(termToMatch.toLowerCase())) continue;
            TermHit th = new TermHit();
            th.sourceTerm = new TermEntry(termToMatch);
            th.targetTerm = new TermEntry(otherTerm);
            res.add(th);
        }
        return res;
    }

    public void save(String path) {
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(path));
            ((DataOutputStream)dos).writeUTF(SIGNATURE);
            ((DataOutputStream)dos).writeUTF(this.srcLoc.toString());
            ((DataOutputStream)dos).writeUTF(this.trgLoc.toString());
            ((DataOutputStream)dos).writeInt(this.entries.size());
            for (Entry ent : this.entries) {
                ((DataOutputStream)dos).writeUTF(ent.srcTerm);
                ((DataOutputStream)dos).writeUTF(ent.trgTerm);
                ((DataOutputStream)dos).writeUTF(ent.definition);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error while saving.", e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing file.", e);
                }
            }
        }
    }

    public void load(String path) {
        this.reset();
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(path));
            String tmp = ((DataInputStream)dis).readUTF();
            if (!tmp.equals(SIGNATURE)) {
                throw new OkapiIOException("Invalid signature: This file is not a SimpleTB files, or is corrupted.");
            }
            tmp = ((DataInputStream)dis).readUTF();
            this.srcLoc = LocaleId.fromString(tmp);
            tmp = ((DataInputStream)dis).readUTF();
            this.trgLoc = LocaleId.fromString(tmp);
            int count = ((DataInputStream)dis).readInt();
            for (int i = 0; i < count; ++i) {
                Entry ent = new Entry(((DataInputStream)dis).readUTF());
                ent.setTargetTerm(((DataInputStream)dis).readUTF());
                ent.setdefinition(((DataInputStream)dis).readUTF());
                this.entries.add(ent);
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error reading.\n" + e.getMessage(), e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing file.", e);
                }
            }
        }
    }
}

