/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.xliff2.util.PropertiesMapper;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.metadata.IMetadataItem;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X2ToOkpConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LocaleId trgLoc;

    public X2ToOkpConverter(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public DocumentPart convert(MidFileData midFileData) {
        DocumentPart documentPart = new DocumentPart();
        if (midFileData.hasMetadata()) {
            GenericAnnotation contextGroup = this.metadataToContextGroup(midFileData.getMetadata());
            documentPart.setAnnotation(new GenericAnnotations(contextGroup));
        }
        return documentPart;
    }

    public StartGroup convert(StartGroupData sgd, String parentId) {
        StartGroup sg = new StartGroup(parentId, sgd.getId());
        sg.setId(sgd.getId());
        sg.setIsTranslatable(sgd.getTranslate());
        sg.setName(sgd.getName());
        sg.setType(sgd.getType());
        if (sgd.hasMetadata()) {
            GenericAnnotation contextGroup = this.metadataToContextGroup(sgd.getMetadata());
            sg.setAnnotation(new GenericAnnotations(contextGroup));
        }
        return sg;
    }

    private GenericAnnotation metadataToContextGroup(Metadata md) {
        GenericAnnotation contextGroup = new GenericAnnotation("misc-metadata");
        int i = 0;
        for (MetaGroup metaGroup : md) {
            this.addMeta(metaGroup, contextGroup, String.valueOf(i));
            ++i;
        }
        return contextGroup;
    }

    private void addMeta(IMetadataItem fromMetadata, GenericAnnotation toContextGroup, String sequenceId) {
        if (fromMetadata.isGroup()) {
            MetaGroup metaGroup = (MetaGroup)fromMetadata;
            Iterator metaIterator = metaGroup.iterator();
            int i = 0;
            while (metaIterator.hasNext()) {
                IMetadataItem next = (IMetadataItem)metaIterator.next();
                this.addMeta(next, toContextGroup, sequenceId + "." + i);
                ++i;
            }
        } else {
            Meta meta = (Meta)fromMetadata;
            if (toContextGroup.getString(meta.getType()) != null) {
                toContextGroup.setString(meta.getType() + "." + sequenceId, meta.getData());
            } else {
                toContextGroup.setString(meta.getType(), meta.getData());
            }
        }
    }

    public ITextUnit convert(Unit unit) {
        TextUnit tu = new TextUnit(unit.getId());
        tu.setName(unit.getName());
        tu.setType(unit.getType());
        tu.setPreserveWhitespaces(unit.getPreserveWS());
        tu.setIsTranslatable(unit.getTranslate());
        if (unit.hasMetadata()) {
            GenericAnnotation contextGroup = this.metadataToContextGroup(unit.getMetadata());
            tu.setAnnotation(new GenericAnnotations(contextGroup));
        }
        TextContainer src = tu.getSource();
        TextContainer trg = null;
        boolean hasTarget = false;
        for (Part part : unit) {
            if (!part.hasTarget()) continue;
            hasTarget = true;
            break;
        }
        if (hasTarget) {
            trg = tu.createTarget(this.trgLoc, false, 0);
        }
        this.convert(unit, src, trg);
        return tu;
    }

    private void convert(Unit unit, TextContainer src, TextContainer trg) {
        ArrayList<TextPart> srcTextParts = new ArrayList<TextPart>();
        ArrayList<TextPart> trgTextParts = new ArrayList<TextPart>();
        HashSet<String> partIds = new HashSet<String>();
        for (Part part : unit) {
            TextPart ttp;
            TextPart stp;
            String id = this.generateId(part, partIds);
            partIds.add(id);
            if (part.isSegment()) {
                stp = this.convertToSegment(part, id);
                ttp = this.convertToSegment(part, id);
            } else {
                stp = this.convertToTextPart(part, id);
                ttp = this.convertToTextPart(part, id);
            }
            stp.setPreserveWhitespaces(part.getPreserveWS());
            ttp.setPreserveWhitespaces(part.getPreserveWS());
            this.convert(part.getSource(), stp);
            this.convert(part.getTarget(), ttp);
            srcTextParts.add(stp);
            trgTextParts.add(ttp);
            PropertiesMapper.setPartProperties(part, stp);
            PropertiesMapper.setPartProperties(part, ttp);
        }
        src.setParts(srcTextParts.toArray(new TextPart[0]));
        if (trg != null) {
            trg.setParts(trgTextParts.toArray(new TextPart[0]));
        }
    }

    private String generateId(Part part, Set<String> partIds) {
        if (Util.isEmpty(part.getId())) {
            int hc = Math.abs(part.getSource().toString().hashCode());
            String id = String.valueOf(hc);
            while (partIds.contains(id)) {
                id = String.valueOf(++hc);
            }
            return id;
        }
        return part.getId();
    }

    private Segment convertToSegment(Part part, String id) {
        Segment s = new Segment(id);
        s.setOriginalId(part.getId());
        return s;
    }

    private TextPart convertToTextPart(Part part, String id) {
        TextPart tp = new TextPart(id, null);
        tp.setOriginalId(part.getId());
        return tp;
    }

    private void convert(Fragment frag, TextPart part) {
        if (frag == null) {
            return;
        }
        Stack<String> mrkStack = new Stack<String>();
        TextFragment tf = part.text;
        for (Object obj : frag) {
            if (obj instanceof String) {
                tf.append((String)obj);
                continue;
            }
            if (obj instanceof CTag) {
                CTag ctag = (CTag)obj;
                Code code = new Code(ctag.getType());
                String id = ctag.getId();
                int okapiId = Math.abs(id.hashCode());
                code.setId(okapiId);
                code.setDeleteable(ctag.getCanDelete());
                code.setCloneable(ctag.getCanCopy());
                code.setData(ctag.getData());
                code.setDisplayText(ctag.getDisp());
                code.setOriginalId(ctag.getId());
                code.setTagType(X2ToOkpConverter.convertTagType(ctag.getTagType()));
                if (ctag.getType() != null) {
                    code.setType(ctag.getType());
                }
                PropertiesMapper.setCodeProperties(ctag, code);
                tf.append(code);
                continue;
            }
            if (!(obj instanceof MTag)) continue;
            MTag mtag = (MTag)obj;
            Code c = new Code();
            c.setType(mtag.getType());
            if (mtag.getTagType() == TagType.OPENING) {
                c.setOriginalId(mtag.getId());
                c.setTagType(TextFragment.TagType.OPENING);
                mrkStack.push(mtag.getId());
            } else {
                c.setOriginalId((String)mrkStack.pop());
                c.setTagType(TextFragment.TagType.CLOSING);
            }
            PropertiesMapper.setCodeProperties(mtag, c);
            tf.append(c);
        }
    }

    private static TextFragment.TagType convertTagType(TagType tagType) {
        switch (tagType) {
            case CLOSING: {
                return TextFragment.TagType.CLOSING;
            }
            case OPENING: {
                return TextFragment.TagType.OPENING;
            }
            case STANDALONE: {
                return TextFragment.TagType.PLACEHOLDER;
            }
        }
        LoggerFactory.getLogger(PropertiesMapper.class).warn("TagType {} unrecognized. Treating it as {}.", (Object)tagType, (Object)TagType.STANDALONE);
        return TextFragment.TagType.PLACEHOLDER;
    }
}

