/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.SchemaDefinition;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEvents;

interface ParagraphBlockProperties
extends BlockProperties {
    public static final String PPR = "pPr";

    public boolean containsRunPropertyDeletedParagraphMark();

    public String paragraphStyle();

    public String highlightColor();

    public String textColor();

    public void refine(QName var1, String var2, List<Property> var3) throws XMLStreamException;

    public ParagraphBlockProperties withoutParagraphStyle();

    public boolean mergeableWith(ParagraphBlockProperties var1);

    public ParagraphBlockProperties mergedWith(ParagraphBlockProperties var1);

    public static final class Word
    implements ParagraphBlockProperties {
        private static final String PARAGRAPH_STYLE = "pStyle";
        private static final String VAL = "val";
        private final BlockProperties.Default defaultBlockProperties;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StrippableAttributes strippableAttributes;

        Word(BlockProperties.Default defaultBlockProperties, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StrippableAttributes strippableAttributes) {
            this.defaultBlockProperties = defaultBlockProperties;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.strippableAttributes = strippableAttributes;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultBlockProperties.getEvents();
        }

        @Override
        public QName getName() {
            return this.defaultBlockProperties.getName();
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.defaultBlockProperties.properties().forEach(p -> p.apply(fontMappings));
        }

        @Override
        public StartElement startElement() {
            return this.defaultBlockProperties.startElement();
        }

        @Override
        public List<Attribute> attributes() {
            return this.defaultBlockProperties.attributes();
        }

        @Override
        public List<Property> properties() {
            return this.defaultBlockProperties.properties();
        }

        @Override
        public EndElement endElement() {
            return this.defaultBlockProperties.endElement();
        }

        @Override
        public boolean isEmpty() {
            return this.defaultBlockProperties.isEmpty();
        }

        @Override
        public boolean containsRunPropertyDeletedParagraphMark() {
            return this.defaultBlockProperties.properties().stream().filter(bp -> "rPr".equals(bp.getName().getLocalPart())).map(rp -> rp.getEvents()).flatMap(events -> events.stream()).filter(e -> e.isStartElement()).map(e -> e.asStartElement().getName()).anyMatch(n -> SkippableElement.RevisionProperty.RUN_PROPERTY_DELETED_PARAGRAPH_MARK.toName().equals(n));
        }

        @Override
        public String paragraphStyle() {
            Property paragraphStyleProperty = this.paragraphStyleProperty();
            if (null != paragraphStyleProperty) {
                return XMLEventHelpers.getAttributeValue(paragraphStyleProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
            }
            return null;
        }

        private Property paragraphStyleProperty() {
            return this.blockProperty(PARAGRAPH_STYLE);
        }

        private Property blockProperty(String localPart) {
            QName name = new QName(this.defaultBlockProperties.getName().getNamespaceURI(), localPart);
            for (Property property : this.defaultBlockProperties.properties()) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
            return null;
        }

        @Override
        public String highlightColor() {
            Property highlightColorProperty = this.highlightColorProperty();
            if (null != highlightColorProperty) {
                return XMLEventHelpers.getAttributeValue(highlightColorProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
            }
            return null;
        }

        private Property highlightColorProperty() {
            return this.blockProperty("highlight");
        }

        @Override
        public String textColor() {
            Property colorProperty = this.textColorProperty();
            if (null != colorProperty) {
                return XMLEventHelpers.getAttributeValue(colorProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
            }
            return null;
        }

        private Property textColorProperty() {
            return this.blockProperty("color");
        }

        @Override
        public void refine(QName innerBlockPropertyName, String styleId, List<Property> commonRunProperties) throws XMLStreamException {
            ListIterator<Property> propertiesIterator = this.defaultBlockProperties.properties().listIterator();
            while (propertiesIterator.hasNext()) {
                Property blockProperty = propertiesIterator.next();
                if (!PARAGRAPH_STYLE.equals(blockProperty.getName().getLocalPart())) continue;
                this.updateProperty(propertiesIterator, innerBlockPropertyName, styleId);
                return;
            }
            this.addProperty(propertiesIterator, innerBlockPropertyName, styleId);
        }

        private void updateProperty(ListIterator<Property> propertiesIterator, QName innerBlockPropertyName, String styleId) {
            propertiesIterator.set(this.blockProperty(innerBlockPropertyName, styleId));
        }

        private void addProperty(ListIterator<Property> propertiesIterator, QName innerBlockPropertyName, String styleId) {
            propertiesIterator.add(this.blockProperty(innerBlockPropertyName, styleId));
        }

        private BlockProperty blockProperty(QName innerBlockPropertyName, String styleId) {
            return new BlockProperty(PARAGRAPH_STYLE, Collections.singletonMap(VAL, styleId), new CreationalParameters(this.eventFactory, innerBlockPropertyName.getPrefix(), innerBlockPropertyName.getNamespaceURI()), this.conditionalParameters, new StrippableAttributes.DrawingRunProperties(this.conditionalParameters, this.eventFactory));
        }

        @Override
        public ParagraphBlockProperties withoutParagraphStyle() {
            return new Word(new BlockProperties.Default(this.eventFactory, this.startElement(), this.endElement(), this.properties().stream().filter(p -> !PARAGRAPH_STYLE.equals(p.getName().getLocalPart())).collect(Collectors.toList())), this.conditionalParameters, this.eventFactory, this.strippableAttributes);
        }

        @Override
        public boolean mergeableWith(ParagraphBlockProperties other) {
            HashSet<Property> otherProperties = new HashSet<Property>(other.properties());
            otherProperties.removeAll(this.properties());
            return otherProperties.isEmpty();
        }

        @Override
        public ParagraphBlockProperties mergedWith(ParagraphBlockProperties other) {
            List<Property> mergedProperties = this.properties().stream().filter(p -> !other.properties().contains(p)).collect(Collectors.toList());
            mergedProperties.addAll(other.properties());
            return new Word(new BlockProperties.Default(this.eventFactory, this.startElement(), this.endElement(), mergedProperties), this.conditionalParameters, this.eventFactory, this.strippableAttributes);
        }
    }

    public static final class Drawing
    implements ParagraphBlockProperties {
        private static final String LOCAL_LEVEL = "lvl";
        private final BlockProperties.Default defaultBlockProperties;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StrippableAttributes strippableAttributes;
        private final SchemaDefinition.Component schemaDefinition;

        Drawing(BlockProperties.Default defaultBlockProperties, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StrippableAttributes strippableAttributes, SchemaDefinition.Component schemaDefinition) {
            this.defaultBlockProperties = defaultBlockProperties;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.strippableAttributes = strippableAttributes;
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultBlockProperties.getEvents();
        }

        @Override
        public QName getName() {
            return this.defaultBlockProperties.getName();
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.defaultBlockProperties.properties().forEach(p -> p.apply(fontMappings));
        }

        @Override
        public StartElement startElement() {
            return this.defaultBlockProperties.startElement();
        }

        @Override
        public List<Attribute> attributes() {
            return this.defaultBlockProperties.attributes();
        }

        @Override
        public List<Property> properties() {
            return this.defaultBlockProperties.properties();
        }

        @Override
        public EndElement endElement() {
            return this.defaultBlockProperties.endElement();
        }

        @Override
        public boolean isEmpty() {
            return this.defaultBlockProperties.isEmpty();
        }

        @Override
        public boolean containsRunPropertyDeletedParagraphMark() {
            return false;
        }

        @Override
        public String paragraphStyle() {
            Attribute paragraphLevelAttribute = this.paragraphLevelAttribute();
            if (null != paragraphLevelAttribute) {
                return paragraphLevelAttribute.getValue();
            }
            return null;
        }

        private Attribute paragraphLevelAttribute() {
            for (Attribute attribute : this.defaultBlockProperties.attributes()) {
                if (!LOCAL_LEVEL.equals(attribute.getName().getLocalPart())) continue;
                return attribute;
            }
            return null;
        }

        @Override
        public String highlightColor() {
            return null;
        }

        @Override
        public String textColor() {
            return null;
        }

        @Override
        public void refine(QName innerBlockPropertyName, String styleId, List<Property> commonRunProperties) throws XMLStreamException {
            ListIterator<Property> propertiesIterator = this.defaultBlockProperties.properties().listIterator();
            while (propertiesIterator.hasNext()) {
                Property blockProperty = propertiesIterator.next();
                if (!blockProperty.getName().equals(innerBlockPropertyName)) continue;
                this.updateProperty(propertiesIterator, blockProperty, commonRunProperties);
                return;
            }
            this.addProperty(propertiesIterator, innerBlockPropertyName, commonRunProperties);
        }

        private void updateProperty(ListIterator<Property> propertiesIterator, Property blockProperty, List<Property> commonRunProperties) throws XMLStreamException {
            RunProperties runProperties = blockProperty.asRunProperties();
            runProperties.refine(commonRunProperties);
            runProperties.alignWith(this.schemaDefinition);
            propertiesIterator.set(new BlockProperty(runProperties.getEvents(), this.conditionalParameters, this.eventFactory, this.strippableAttributes));
        }

        private void addProperty(ListIterator<Property> propertiesIterator, QName innerBlockPropertyName, List<Property> commonRunProperties) {
            List<Attribute> attributes = this.asAttributes(commonRunProperties);
            List<Property> properties = this.asProperties(commonRunProperties);
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.eventFactory.createStartElement(innerBlockPropertyName, attributes.iterator(), null));
            events.addAll(Drawing.asXMLEvents(properties));
            events.add(this.eventFactory.createEndElement(innerBlockPropertyName, null));
            this.rewindToSchemaDefinedPlace(propertiesIterator, innerBlockPropertyName).add(new BlockProperty(events, this.conditionalParameters, this.eventFactory, this.strippableAttributes));
        }

        private List<Attribute> asAttributes(List<Property> commonRunProperties) {
            return commonRunProperties.stream().filter(runProperty -> runProperty instanceof RunProperty.AttributeRunProperty).map(runProperty -> this.eventFactory.createAttribute(runProperty.getName(), runProperty.value())).collect(Collectors.toList());
        }

        private List<Property> asProperties(List<Property> commonRunProperties) {
            return commonRunProperties.stream().filter(runProperty -> !(runProperty instanceof RunProperty.AttributeRunProperty)).collect(Collectors.toList());
        }

        private static List<XMLEvent> asXMLEvents(List<Property> commonRunProperties) {
            return commonRunProperties.stream().map(XMLEvents::getEvents).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private ListIterator<Property> rewindToSchemaDefinedPlace(ListIterator<Property> propertiesIterator, QName innerBlockPropertyName) {
            if (!propertiesIterator.hasPrevious()) {
                return propertiesIterator;
            }
            ListIterator<SchemaDefinition.Component> iterator = this.schemaDefinition.listIteratorAfter(innerBlockPropertyName);
            if (!iterator.hasNext()) {
                return propertiesIterator;
            }
            while (iterator.hasNext()) {
                SchemaDefinition.Component component = (SchemaDefinition.Component)iterator.next();
                while (propertiesIterator.hasPrevious()) {
                    Property blockProperty = propertiesIterator.previous();
                    if (!blockProperty.getName().equals(component.name())) continue;
                    return propertiesIterator;
                }
                this.rewindToEndOfProperties(propertiesIterator);
            }
            return propertiesIterator;
        }

        private void rewindToEndOfProperties(ListIterator<Property> propertiesIterator) {
            while (propertiesIterator.hasNext()) {
                propertiesIterator.next();
            }
        }

        @Override
        public ParagraphBlockProperties withoutParagraphStyle() {
            return this;
        }

        @Override
        public boolean mergeableWith(ParagraphBlockProperties paragraphProperties) {
            HashSet<Property> otherProperties = new HashSet<Property>(paragraphProperties.properties());
            otherProperties.removeAll(this.properties());
            if (!otherProperties.isEmpty()) {
                return false;
            }
            HashSet<Attribute> otherAttributes = new HashSet<Attribute>(paragraphProperties.attributes());
            otherAttributes.removeAll(this.attributes());
            return otherAttributes.isEmpty();
        }

        @Override
        public ParagraphBlockProperties mergedWith(ParagraphBlockProperties paragraphProperties) {
            List<Property> mergedProperties = this.properties().stream().filter(p -> !paragraphProperties.properties().contains(p)).collect(Collectors.toList());
            mergedProperties.addAll(paragraphProperties.properties());
            List mergedAttributes = this.attributes().stream().filter(a -> !paragraphProperties.attributes().contains(a)).collect(Collectors.toList());
            mergedAttributes.addAll(paragraphProperties.attributes());
            return new Drawing(new BlockProperties.Default(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName(), mergedAttributes.iterator(), null), this.endElement(), mergedProperties), this.conditionalParameters, this.eventFactory, this.strippableAttributes, this.schemaDefinition);
        }
    }
}

