/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.openxml.AttributesClarification;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.ElementsClarification;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.RunProperties;

interface MarkupComponentClarification {
    public void performFor(MarkupComponent var1);

    public static final class Default
    implements MarkupComponentClarification {
        private final AttributesClarification attributesClarification;
        private final ElementsClarification elementsClarification;

        Default(AttributesClarification attributesClarification, ElementsClarification elementsClarification) {
            this.attributesClarification = attributesClarification;
            this.elementsClarification = elementsClarification;
        }

        @Override
        public void performFor(MarkupComponent markupComponent) {
            List<Attribute> attributes;
            if (markupComponent instanceof MarkupComponent.Start) {
                attributes = ((MarkupComponent.Start)markupComponent).getAttributes();
            } else if (markupComponent instanceof MarkupComponent.EmptyElement) {
                attributes = ((MarkupComponent.EmptyElement)markupComponent).getAttributes();
            } else if (markupComponent instanceof BlockProperties) {
                attributes = ((BlockProperties)markupComponent).attributes();
            } else if (markupComponent instanceof RunProperties) {
                attributes = Collections.emptyList();
            } else {
                throw new IllegalArgumentException("Unsupported markup component: ".concat(markupComponent.getClass().getSimpleName()));
            }
            this.attributesClarification.performFor(attributes);
            if (markupComponent instanceof BlockProperties) {
                this.elementsClarification.performFor(((BlockProperties)markupComponent).properties());
            }
            if (markupComponent instanceof RunProperties) {
                this.elementsClarification.performFor(((RunProperties)markupComponent).properties());
            }
        }
    }
}

