/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.okapi.filters.openxml.WorkbookFragments;
import net.sf.okapi.filters.openxml.WorksheetConfiguration;

@Deprecated
final class ExcelExcludedColumnWorksheetConfiguration
implements WorksheetConfiguration {
    private static final String DEFAULT_NAME_PATTERN = ".*";
    private final WorkbookFragments workbookFragments;
    private final String excludedColumnConfiguration;
    private WorksheetConfiguration worksheetConfiguration;
    private boolean read;

    ExcelExcludedColumnWorksheetConfiguration(WorkbookFragments workbookFragments, String excludedColumnConfiguration) {
        this.workbookFragments = workbookFragments;
        this.excludedColumnConfiguration = excludedColumnConfiguration;
    }

    @Override
    public boolean matches(String worksheetName) {
        if (!this.read) {
            this.fromExcludedColumn();
        }
        return this.worksheetConfiguration.matches(worksheetName);
    }

    @Override
    public Set<Integer> excludedRows() {
        if (!this.read) {
            this.fromExcludedColumn();
        }
        return this.worksheetConfiguration.excludedRows();
    }

    @Override
    public Set<String> excludedColumns() {
        if (!this.read) {
            this.fromExcludedColumn();
        }
        return this.worksheetConfiguration.excludedColumns();
    }

    @Override
    public Set<Integer> metadataRows() {
        if (!this.read) {
            this.fromExcludedColumn();
        }
        return this.worksheetConfiguration.metadataRows();
    }

    @Override
    public Set<String> metadataColumns() {
        if (!this.read) {
            this.fromExcludedColumn();
        }
        return this.worksheetConfiguration.metadataColumns();
    }

    @Override
    public <T> T writtenTo(WorksheetConfiguration.Output<T> output) {
        if (!this.read) {
            this.fromExcludedColumn();
        }
        return this.worksheetConfiguration.writtenTo(output);
    }

    private void fromExcludedColumn() {
        WorksheetNumberAndColumnName worksheetNumberAndColumnName = new WorksheetNumberAndColumnName(this.excludedColumnConfiguration);
        String worksheetName = worksheetNumberAndColumnName.worksheetNumber().isEmpty() ? DEFAULT_NAME_PATTERN : Pattern.quote(this.workbookFragments.localisedWorksheetNameFor(Integer.parseUnsignedInt(worksheetNumberAndColumnName.worksheetNumber())));
        this.worksheetConfiguration = new WorksheetConfiguration.Default(worksheetName, Collections.emptySet(), Collections.singleton(worksheetNumberAndColumnName.columnName()), Collections.emptySet(), Collections.emptySet());
        this.read = true;
    }

    static final class WorksheetNumberAndColumnName {
        private final String excludedColumnConfiguration;
        private String worksheetNumber;
        private String columnName;
        private boolean read;

        WorksheetNumberAndColumnName(String excludedColumnConfiguration) {
            this.excludedColumnConfiguration = excludedColumnConfiguration;
        }

        String worksheetNumber() {
            if (!this.read) {
                this.read();
            }
            return this.worksheetNumber;
        }

        String columnName() {
            if (!this.read) {
                this.read();
            }
            return this.columnName;
        }

        void read() {
            char[] chars;
            StringBuilder worksheetNumber = new StringBuilder();
            StringBuilder columnName = new StringBuilder();
            for (char ch : chars = this.excludedColumnConfiguration.trim().toCharArray()) {
                if (Character.isDigit(ch)) {
                    worksheetNumber.append(ch);
                    continue;
                }
                columnName.append(ch);
            }
            this.worksheetNumber = worksheetNumber.toString();
            this.columnName = columnName.toString();
            this.read = true;
        }
    }
}

