/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.ExcelCommentPart;
import net.sf.okapi.filters.openxml.ExcelExcludedColumnsWorksheetConfigurationsInput;
import net.sf.okapi.filters.openxml.ExcelFormulaPart;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.ModifiablePart;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.SharedStrings;
import net.sf.okapi.filters.openxml.SharedStringsPart;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.WorkbookFragments;
import net.sf.okapi.filters.openxml.Worksheet;
import net.sf.okapi.filters.openxml.WorksheetFragments;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class ExcelDocument
implements Document {
    private static final String EMPTY = "";
    private static final String STYLES = "/styles";
    private static final String TABLE = "/table";
    private static final String COMMENT = "/comments";
    private static final String DRAWING = "/drawing";
    private static final String CHART = "/chart";
    private static final String DIAGRAM_DATA = "/diagramData";
    private static final String SHARED_STRINGS = "/sharedStrings";
    private final Document.General generalDocument;
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final Map<String, String> translatables;
    private final LinkedHashMap<ZipEntry, String> postponedParts;
    private final SharedStrings sharedStrings;
    private Relationships workbookRels;
    private WorkbookFragments workbookFragments;
    private Enumeration<? extends ZipEntry> entries;
    private ExcelStyles styles;
    private Map<String, Set<String>> tablesByWorksheet;
    private Map<String, String> worksheetsByComment;
    private Map<String, String> worksheetsByDrawing;
    private Map<String, String> drawingsByChart;
    private Map<String, String> drawingsByDiagramData;

    ExcelDocument(Document.General generalDocument, EncoderManager encoderManager, IFilter subfilter) {
        this.generalDocument = generalDocument;
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.translatables = new HashMap<String, String>();
        this.postponedParts = new LinkedHashMap();
        this.sharedStrings = new SharedStrings();
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.workbookRels = this.generalDocument.relationshipsFor(this.generalDocument.mainPartName());
        this.workbookFragments = this.workbookFragments();
        this.loadLegacyConfigurations();
        this.entries = this.entries();
        this.styles = this.styles();
        this.tablesByWorksheet = this.tablesByWorksheet();
        this.worksheetsByComment = this.worksheetsBy(COMMENT);
        this.worksheetsByDrawing = this.worksheetsBy(DRAWING);
        this.drawingsByChart = this.drawingsBy(CHART);
        this.drawingsByDiagramData = this.drawingsBy(DIAGRAM_DATA);
        return this.generalDocument.startDocumentEvent();
    }

    private void loadLegacyConfigurations() {
        if (this.generalDocument.conditionalParameters().getTranslateExcelExcludeColumns()) {
            this.generalDocument.conditionalParameters().worksheetConfigurations().addFrom(new ExcelExcludedColumnsWorksheetConfigurationsInput(this.workbookFragments, this.generalDocument.conditionalParameters().tsExcelExcludedColumns));
        }
    }

    private WorkbookFragments workbookFragments() throws IOException, XMLStreamException {
        WorkbookFragments.Default wf = new WorkbookFragments.Default(this.generalDocument.conditionalParameters(), this.workbookRels);
        try (Reader reader = this.generalDocument.getPartReader(this.generalDocument.mainPartName());){
            wf.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
        }
        return wf;
    }

    private Enumeration<? extends ZipEntry> entries() throws IOException, XMLStreamException {
        ArrayList<? extends ZipEntry> entryList = Collections.list(this.generalDocument.entries());
        entryList.sort(new ZipEntryComparator(this.reorderedPartNames()));
        return Collections.enumeration(entryList);
    }

    private List<String> reorderedPartNames() throws IOException, XMLStreamException {
        ArrayList<String> names = new ArrayList<String>(this.workbookFragments.worksheetNames());
        String sharedStringsName = this.sharedStringsName();
        if (!EMPTY.equals(sharedStringsName)) {
            names.add(sharedStringsName);
        }
        return names;
    }

    private String sharedStringsName() throws IOException, XMLStreamException {
        String sharedStringsNamespaceUri;
        Relationships rels = this.generalDocument.relationshipsFor(this.generalDocument.mainPartName());
        List<Relationships.Rel> r = rels.getRelByType(sharedStringsNamespaceUri = this.generalDocument.documentRelationshipsNamespace().uri().concat(SHARED_STRINGS));
        if (r == null) {
            return EMPTY;
        }
        if (r.size() != 1) {
            throw new OkapiBadFilterInputException(String.format("%s: %s", "Unexpected number of relationships", sharedStringsNamespaceUri));
        }
        return r.get((int)0).target;
    }

    private ExcelStyles styles() throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        Relationships.Rel stylesRel = this.workbookRels.getRelByType(namespaceUri.concat(STYLES)).get(0);
        ExcelStyles styles = new ExcelStyles();
        styles.parse(this.generalDocument.inputFactory().createXMLEventReader(this.generalDocument.getPartReader(stylesRel.target)));
        return styles;
    }

    private Map<String, Set<String>> tablesByWorksheet() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.documentRelationshipsNamespace().uri().concat(TABLE);
        for (String name : this.workbookFragments.worksheetNames()) {
            map.put(name, this.relatedPartsFor(name, uri));
        }
        return map;
    }

    private Set<String> relatedPartsFor(String name, String uri) throws IOException, XMLStreamException {
        List<Relationships.Rel> rels = this.generalDocument.relationshipsFor(name).getRelByType(uri);
        Set<String> names = null == rels || rels.isEmpty() ? Collections.emptySet() : rels.stream().map(rel -> rel.target).collect(Collectors.toSet());
        return names;
    }

    private Map<String, String> worksheetsBy(String relatedPart) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.relsByEntry(this.workbookFragments.worksheetNames(), namespaceUri.concat(relatedPart));
    }

    private Map<String, String> drawingsBy(String relatedPart) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.documentRelationshipsNamespace().uri();
        return this.generalDocument.relsByEntry(new ArrayList<String>(this.worksheetsByDrawing.keySet()), namespaceUri.concat(relatedPart));
    }

    @Override
    public boolean hasPostponedTranslatables() {
        return true;
    }

    @Override
    public void updatePostponedTranslatables(String key, String value) {
        this.translatables.put(key, value);
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements() || !this.postponedParts.isEmpty();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        if (!this.entries.hasMoreElements()) {
            return this.nextPostponedPart();
        }
        ZipEntry entry = this.entries.nextElement();
        String contentType = this.generalDocument.contentTypeFor(entry);
        if (!this.isTranslatablePart(entry.getName(), contentType)) {
            if (this.isModifiablePart(contentType)) {
                if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml")) {
                    boolean hidden = this.workbookFragments.worksheetHiddenFor(entry.getName());
                    Worksheet.Default worksheet = new Worksheet.Default(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.sharedStrings, this.styles, this.workbookFragments.localisedWorksheetNameFor(entry.getName()), new WorksheetFragments.Default(this.generalDocument.conditionalParameters().getTranslateExcelHidden(), hidden));
                    try (Reader reader = this.generalDocument.getPartReader(entry.getName());){
                        worksheet.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
                    }
                    StringWriter stringWriter = new StringWriter();
                    worksheet.writeWith(this.generalDocument.outputFactory().createXMLEventWriter(stringWriter));
                    if (hidden) {
                        return new ModifiablePart(this.generalDocument, entry, new ByteArrayInputStream(stringWriter.toString().getBytes(OpenXMLFilter.ENCODING)));
                    }
                    this.postponedParts.put(entry, stringWriter.toString());
                    return this.nextPart();
                }
                if ("application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml".equals(contentType) && !this.isTableHidden(entry.getName())) {
                    return new ExcelFormulaPart(this.generalDocument, entry, this.translatables, this.generalDocument.inputStreamFor(entry));
                }
                return new ModifiablePart(this.generalDocument, entry, this.generalDocument.inputStreamFor(entry));
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        if (this.isStyledTextPart(entry)) {
            StyleDefinitions.Empty styleDefinitions = new StyleDefinitions.Empty();
            StyleOptimisation.Bypass styleOptimisation = new StyleOptimisation.Bypass();
            if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(contentType)) {
                return new SharedStringsPart(this.generalDocument, entry, styleDefinitions, styleOptimisation, this.encoderManager, this.subfilter, this.sharedStrings);
            }
            if ("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml".equals(contentType)) {
                return new ExcelCommentPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
            }
            return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
        }
        ParseType parseType = ParseType.MSEXCEL;
        if ("application/vnd.openxmlformats-package.core-properties+xml".equals(contentType)) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        }
        ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
        contentFilter.setUpConfig(parseType);
        return new DefaultPart(this.generalDocument, entry, contentFilter);
    }

    private Part nextPostponedPart() throws IOException, XMLStreamException {
        Iterator<Map.Entry<ZipEntry, String>> iterator = this.postponedParts.entrySet().iterator();
        Map.Entry<ZipEntry, String> mapEntry = iterator.next();
        iterator.remove();
        return new ModifiablePart(this.generalDocument, mapEntry.getKey(), new ByteArrayInputStream(new ExcelFormulaPart(this.generalDocument, mapEntry.getKey(), this.translatables, new ByteArrayInputStream(mapEntry.getValue().getBytes(OpenXMLFilter.ENCODING))).getModifiedContent().getBytes(OpenXMLFilter.ENCODING)));
    }

    private boolean isTranslatablePart(String entryName, String contentType) {
        if (!entryName.endsWith(".xml")) {
            return false;
        }
        if (this.isHidden(entryName, contentType)) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": 
            case "application/vnd.ms-excel.sheet.macroEnabled.main+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelSheetNames();
            }
            case "application/vnd.openxmlformats-package.core-properties+xml": {
                return this.generalDocument.conditionalParameters().getTranslateDocProperties();
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": {
                return true;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return this.generalDocument.conditionalParameters().getTranslateComments();
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelDrawings();
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return true;
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelDiagramData();
            }
        }
        return false;
    }

    private boolean isModifiablePart(String contentType) {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml".equals(contentType);
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(type) || "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml".equals(type) || "application/vnd.openxmlformats-officedocument.drawing+xml".equals(type) || "application/vnd.openxmlformats-officedocument.drawingml.chart+xml".equals(type) || "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml".equals(type);
    }

    private boolean isHidden(String entryName, String contentType) {
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml": {
                return this.isWorksheetHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml": {
                return this.isTableHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return this.isCommentHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": {
                return this.isDrawingHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.isChartHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.isDiagramDataHidden(entryName);
            }
        }
        return false;
    }

    private boolean isWorksheetHidden(String entryName) {
        return this.workbookFragments.worksheetHiddenFor(entryName);
    }

    private boolean isTableHidden(String entryName) {
        boolean hidden = false;
        for (String worksheetName : this.tablesByWorksheet.keySet()) {
            if (!this.tablesByWorksheet.get(worksheetName).contains(entryName)) continue;
            if (this.isWorksheetHidden(worksheetName)) {
                hidden = true;
                continue;
            }
            return false;
        }
        return hidden;
    }

    private boolean isCommentHidden(String entryName) {
        if (!this.worksheetsByComment.containsKey(entryName)) {
            return false;
        }
        return this.isWorksheetHidden(this.worksheetsByComment.get(entryName));
    }

    private boolean isDrawingHidden(String entryName) {
        if (!this.worksheetsByDrawing.containsKey(entryName)) {
            return false;
        }
        return this.isWorksheetHidden(this.worksheetsByDrawing.get(entryName));
    }

    private boolean isChartHidden(String entryName) {
        if (!this.drawingsByChart.containsKey(entryName)) {
            return false;
        }
        return this.isDrawingHidden(this.drawingsByChart.get(entryName));
    }

    private boolean isDiagramDataHidden(String entryName) {
        if (!this.drawingsByDiagramData.containsKey(entryName)) {
            return false;
        }
        return this.isDrawingHidden(this.drawingsByDiagramData.get(entryName));
    }

    @Override
    public void close() throws IOException {
    }
}

