/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StyleDefinitions;

class ClarificationContext {
    private final ConditionalParameters conditionalParameters;
    private final CreationalParameters creationalParameters;
    private final LocaleId sourceLocale;
    private final LocaleId targetLocale;
    private Boolean sourceRtl;
    private Boolean targetRtl;
    private Boolean targetHasCharactersAsNumeralSeparators;
    private StyleDefinitions styleDefinitions;
    private ParagraphBlockProperties combinedParagraphProperties;
    private String paragraphStyle;
    private RunProperties combinedRunProperties;

    ClarificationContext(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, LocaleId sourceLocale, LocaleId targetLocale) {
        this.conditionalParameters = conditionalParameters;
        this.creationalParameters = creationalParameters;
        this.sourceLocale = sourceLocale;
        this.targetLocale = targetLocale;
    }

    ConditionalParameters conditionalParameters() {
        return this.conditionalParameters;
    }

    CreationalParameters creationalParameters() {
        return this.creationalParameters;
    }

    boolean sourceLtr() {
        return !this.sourceRtl();
    }

    boolean sourceRtl() {
        if (null == this.sourceRtl) {
            this.sourceRtl = LocaleId.isBidirectional(this.sourceLocale);
        }
        return this.sourceRtl;
    }

    boolean targetLtr() {
        return !this.targetRtl();
    }

    boolean targetRtl() {
        if (null == this.targetRtl) {
            this.targetRtl = LocaleId.isBidirectional(this.targetLocale);
        }
        return this.targetRtl;
    }

    boolean targetHasCharactersAsNumeralSeparators() {
        if (null == this.targetHasCharactersAsNumeralSeparators) {
            this.targetHasCharactersAsNumeralSeparators = LocaleId.hasCharactersAsNumeralSeparators(this.targetLocale);
        }
        return this.targetHasCharactersAsNumeralSeparators;
    }

    String targetAsString() {
        return this.targetLocale.toString();
    }

    void adjust(StyleDefinitions styleDefinitions) {
        this.styleDefinitions = styleDefinitions;
    }

    private StyleDefinitions styleDefinitions() {
        if (null == this.styleDefinitions) {
            this.styleDefinitions = new StyleDefinitions.Empty();
        }
        return this.styleDefinitions;
    }

    void adjustCombinedParagraphPropertiesAndParagraphStyleFor(ParagraphBlockProperties paragraphProperties) {
        this.combinedParagraphProperties = this.styleDefinitions.combinedParagraphBlockProperties(paragraphProperties);
        this.paragraphStyle = paragraphProperties.paragraphStyle();
    }

    ParagraphBlockProperties combinedParagraphProperties() {
        return this.combinedParagraphProperties;
    }

    void adjustCombinedRunPropertiesFor(RunProperties runProperties) {
        RunProperty.StyleRunProperty runStyleProperty = runProperties.getRunStyleProperty();
        this.combinedRunProperties = this.styleDefinitions().combinedRunProperties(this.paragraphStyle, null == runStyleProperty ? null : runStyleProperty.value(), runProperties);
    }

    RunProperties combinedRunProperties() {
        return this.combinedRunProperties;
    }
}

