/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.openxml.ClarifiableAttribute;
import net.sf.okapi.filters.openxml.ClarificationContext;

interface AttributesClarification {
    public void performFor(List<Attribute> var1);

    public static final class AlignmentAndRtl
    implements AttributesClarification {
        private final ClarificationContext clarificationContext;
        private final String prefix;
        private final String alignmentName;
        private final String alignmentLeft;
        private final String alignmentRight;
        private final String rtlName;
        private final Set<String> falseValues;
        private final Set<String> trueValues;

        AlignmentAndRtl(ClarificationContext clarificationContext, String prefix, String alignmentName, String alignmentLeft, String alignmentRight, String rtlName, Set<String> falseValues, Set<String> trueValues) {
            this.clarificationContext = clarificationContext;
            this.prefix = prefix;
            this.alignmentName = alignmentName;
            this.alignmentLeft = alignmentLeft;
            this.alignmentRight = alignmentRight;
            this.rtlName = rtlName;
            this.falseValues = falseValues;
            this.trueValues = trueValues;
        }

        @Override
        public void performFor(List<Attribute> attributes) {
            if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetLtr() || this.clarificationContext.sourceRtl() && this.clarificationContext.targetRtl()) {
                return;
            }
            String combinedAlignment = this.clarificationContext.combinedParagraphProperties().attributes().stream().filter(a -> a.getName().getLocalPart().equals(this.alignmentName)).map(a -> a.getValue()).findFirst().orElse(this.alignmentLeft);
            String combinedRtl = this.clarificationContext.combinedParagraphProperties().attributes().stream().filter(a -> a.getName().getLocalPart().equals(this.rtlName)).map(a -> a.getValue()).findFirst().orElse((String)this.falseValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("False values are empty")));
            if (combinedAlignment.equals(this.alignmentLeft) && this.falseValues.contains(combinedRtl)) {
                if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetRtl()) {
                    new Straightforward(this.clarificationContext, Arrays.asList(new ClarifiableAttribute(this.prefix, this.alignmentName, Collections.singleton(this.alignmentRight)), new ClarifiableAttribute(this.prefix, this.rtlName, this.trueValues))).performFor(attributes);
                }
            } else if (combinedAlignment.equals(this.alignmentLeft) && this.trueValues.contains(combinedRtl)) {
                if (this.clarificationContext.sourceRtl() && this.clarificationContext.targetLtr()) {
                    new Straightforward(this.clarificationContext, Arrays.asList(new ClarifiableAttribute(this.prefix, this.alignmentName, Collections.singleton(this.alignmentRight)), new ClarifiableAttribute(this.prefix, this.rtlName, this.falseValues))).performFor(attributes);
                }
            } else if (combinedAlignment.equals(this.alignmentRight) && this.falseValues.contains(combinedRtl)) {
                if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetRtl()) {
                    new Straightforward(this.clarificationContext, Arrays.asList(new ClarifiableAttribute(this.prefix, this.alignmentName, Collections.singleton(this.alignmentLeft)), new ClarifiableAttribute(this.prefix, this.rtlName, this.trueValues))).performFor(attributes);
                }
            } else if (combinedAlignment.equals(this.alignmentRight) && this.trueValues.contains(combinedRtl)) {
                if (this.clarificationContext.sourceRtl() && this.clarificationContext.targetLtr()) {
                    new Straightforward(this.clarificationContext, Arrays.asList(new ClarifiableAttribute(this.prefix, this.alignmentName, Collections.singleton(this.alignmentLeft)), new ClarifiableAttribute(this.prefix, this.rtlName, this.falseValues))).performFor(attributes);
                }
            } else if (!combinedAlignment.equals(this.alignmentLeft) && !combinedAlignment.equals(this.alignmentRight) && this.falseValues.contains(combinedRtl)) {
                if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetRtl()) {
                    new Straightforward(this.clarificationContext, Collections.singletonList(new ClarifiableAttribute(this.prefix, this.rtlName, this.trueValues))).performFor(attributes);
                }
            } else if (!combinedAlignment.equals(this.alignmentLeft) && !combinedAlignment.equals(this.alignmentRight) && this.trueValues.contains(combinedRtl) && this.clarificationContext.sourceRtl() && this.clarificationContext.targetLtr()) {
                new Straightforward(this.clarificationContext, Collections.singletonList(new ClarifiableAttribute(this.prefix, this.rtlName, this.falseValues))).performFor(attributes);
            }
        }
    }

    public static final class Straightforward
    implements AttributesClarification {
        private final ClarificationContext clarificationContext;
        private final List<ClarifiableAttribute> clarifiableAttributes;

        Straightforward(ClarificationContext clarificationContext, List<ClarifiableAttribute> clarifiableAttributes) {
            this.clarificationContext = clarificationContext;
            this.clarifiableAttributes = clarifiableAttributes;
        }

        @Override
        public void performFor(List<Attribute> attributes) {
            LinkedList<ClarifiableAttribute> tempAttributes = new LinkedList<ClarifiableAttribute>(this.clarifiableAttributes);
            ListIterator<Attribute> attributesIterator = attributes.listIterator();
            while (attributesIterator.hasNext()) {
                Attribute attribute = attributesIterator.next();
                Iterator tempAttrsIterator = tempAttributes.iterator();
                while (tempAttrsIterator.hasNext()) {
                    ClarifiableAttribute clarifiableAttribute = (ClarifiableAttribute)tempAttrsIterator.next();
                    if (!attribute.getName().getLocalPart().equals(clarifiableAttribute.getName())) continue;
                    attributesIterator.set(this.attributeFrom(clarifiableAttribute));
                    tempAttrsIterator.remove();
                }
            }
            tempAttributes.forEach(ca -> attributes.add(this.attributeFrom((ClarifiableAttribute)ca)));
        }

        private Attribute attributeFrom(ClarifiableAttribute clarifiableAttribute) {
            return this.clarificationContext.creationalParameters().getEventFactory().createAttribute(clarifiableAttribute.getPrefix(), this.clarificationContext.creationalParameters().getNamespaceUri(), clarifiableAttribute.getName(), (String)clarifiableAttribute.getValues().stream().findFirst().orElseThrow(() -> new IllegalStateException("Clarifiable values are empty")));
        }
    }

    public static final class Default
    implements AttributesClarification {
        private final ClarificationContext clarificationContext;
        private final ClarifiableAttribute clarifiableAttribute;

        Default(ClarificationContext clarificationContext, ClarifiableAttribute clarifiableAttribute) {
            this.clarificationContext = clarificationContext;
            this.clarifiableAttribute = clarifiableAttribute;
        }

        @Override
        public void performFor(List<Attribute> attributes) {
            ListIterator<Attribute> iterator = attributes.listIterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (!this.clarifiableAttribute.getName().equals(attribute.getName().getLocalPart())) continue;
                if (!this.clarificationContext.targetRtl()) {
                    iterator.remove();
                    return;
                }
                if (this.clarifiableAttribute.getValues().contains(attribute.getValue())) {
                    return;
                }
                iterator.set(this.requiredAttribute());
                return;
            }
            if (this.clarificationContext.targetRtl()) {
                iterator.add(this.requiredAttribute());
            }
        }

        private Attribute requiredAttribute() {
            return this.clarificationContext.creationalParameters().getEventFactory().createAttribute(this.clarifiableAttribute.getPrefix(), this.clarificationContext.creationalParameters().getNamespaceUri(), this.clarifiableAttribute.getName(), (String)this.clarifiableAttribute.getValues().stream().findFirst().orElseThrow(() -> new IllegalStateException("Clarifiable values are empty")));
        }
    }

    public static final class Bypass
    implements AttributesClarification {
        @Override
        public void performFor(List<Attribute> attributes) {
        }
    }
}

