/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.Property;

interface Properties
extends Element {
    public static final QName NAME = new QName("Properties");

    public List<Property> properties();

    public static class Builder
    implements net.sf.okapi.filters.idml.Builder<Properties> {
        private StartElement startElement;
        private List<Property> properties = new ArrayList<Property>();
        private EndElement endElement;

        Builder setStartElement(StartElement startElement) {
            this.startElement = startElement;
            return this;
        }

        Builder addProperty(Property property) {
            this.properties.add(property);
            return this;
        }

        Builder addProperties(List<Property> properties) {
            this.properties.addAll(properties);
            return this;
        }

        Builder setEndElement(EndElement endElement) {
            this.endElement = endElement;
            return this;
        }

        @Override
        public Properties build() {
            return new Default(this.startElement, this.properties, this.endElement);
        }
    }

    public static class Empty
    implements Properties {
        private final XMLEventFactory eventFactory;
        private StartElement startElement;
        private EndElement endElement;

        Empty(XMLEventFactory eventFactory) {
            this.eventFactory = eventFactory;
        }

        @Override
        public StartElement startElement() {
            if (null == this.startElement) {
                this.startElement = this.eventFactory.createStartElement(NAME, null, null);
            }
            return this.startElement;
        }

        @Override
        public List<XMLEvent> innerEvents() {
            return Collections.emptyList();
        }

        @Override
        public void updateInnerEventsWith(List<XMLEvent> events) {
        }

        @Override
        public EndElement endElement() {
            if (null == this.endElement) {
                this.endElement = this.eventFactory.createEndElement(NAME, null);
            }
            return this.endElement;
        }

        @Override
        public List<Property> properties() {
            return Collections.emptyList();
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }

        @Override
        public QName getName() {
            return NAME;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties that = (Properties)o;
            return Objects.equals(this.properties(), that.properties());
        }

        public int hashCode() {
            return Objects.hash(this.properties());
        }
    }

    public static class Default
    implements Properties {
        private static final String APPLIED_FONT = "AppliedFont";
        private final StartElement startElement;
        private final List<Property> properties;
        private final EndElement endElement;

        Default(StartElement startElement, List<Property> properties, EndElement endElement) {
            this.startElement = startElement;
            this.properties = properties;
            this.endElement = endElement;
        }

        @Override
        public StartElement startElement() {
            return this.startElement;
        }

        @Override
        public List<XMLEvent> innerEvents() {
            return this.properties.stream().map(p -> p.getEvents()).flatMap(Collection::stream).collect(Collectors.toList());
        }

        @Override
        public void updateInnerEventsWith(List<XMLEvent> events) {
        }

        @Override
        public EndElement endElement() {
            return this.endElement;
        }

        @Override
        public List<Property> properties() {
            return this.properties;
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.properties.stream().filter(p -> p.getName().getLocalPart().equals(APPLIED_FONT)).forEach(p -> p.apply(fontMappings));
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.startElement);
            events.addAll(this.innerEvents());
            events.add(this.endElement);
            return events;
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties that = (Properties)o;
            return Objects.equals(this.properties(), that.properties());
        }

        public int hashCode() {
            return Objects.hash(this.properties());
        }
    }
}

