/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.DesignMap;
import net.sf.okapi.filters.idml.DesignMapParser;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupModifiableSubDocument;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.MimeType;
import net.sf.okapi.filters.idml.NonModifiableSubDocument;
import net.sf.okapi.filters.idml.OrderingIdioms;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.PasteboardItem;
import net.sf.okapi.filters.idml.Preferences;
import net.sf.okapi.filters.idml.PreferencesParser;
import net.sf.okapi.filters.idml.Spread;
import net.sf.okapi.filters.idml.SpreadParser;
import net.sf.okapi.filters.idml.StorySubDocument;
import net.sf.okapi.filters.idml.StyleDefinitions;
import net.sf.okapi.filters.idml.SubDocument;
import net.sf.okapi.filters.idml.ZipInput;

interface Document {
    public Event open() throws XMLStreamException, IOException;

    public boolean hasNextSubDocument();

    public SubDocument nextSubDocument();

    public void close() throws IOException;

    public static class Default
    implements Document {
        private final Parameters parameters;
        private final XMLInputFactory inputFactory;
        private final XMLOutputFactory outputFactory;
        private final XMLEventFactory eventFactory;
        private final String startDocumentId;
        private final URI uri;
        private final LocaleId sourceLocale;
        private final String encoding;
        private final String lineBreak;
        private final IFilterWriter filterWriter;
        private ZipFile zipFile;
        private ZipInput<XMLEventReader> zipInputReader;
        private DesignMap designMap;
        private StyleDefinitions styleDefinitions;
        private List<String> nonTranslatableSubDocuments;
        private Enumeration<? extends ZipEntry> zipFileEntries;
        private int currentSubDocumentId;

        Default(Parameters parameters, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String startDocumentId, URI uri, LocaleId sourceLocale, String encoding, String lineBreak, IFilterWriter filterWriter) {
            this.parameters = parameters;
            this.inputFactory = inputFactory;
            this.outputFactory = outputFactory;
            this.eventFactory = eventFactory;
            this.startDocumentId = startDocumentId;
            this.uri = uri;
            this.sourceLocale = sourceLocale;
            this.encoding = encoding;
            this.lineBreak = lineBreak;
            this.filterWriter = filterWriter;
        }

        @Override
        public Event open() throws XMLStreamException, IOException {
            this.zipFile = new ZipFile(new File(this.uri.getPath()), 1);
            ZipInput.Stream zipInputStream = new ZipInput.Stream(this.zipFile);
            MimeType mimeType = new MimeType(zipInputStream);
            mimeType.from(this.zipFile.getEntry("mimetype"));
            if (!"application/vnd.adobe.indesign-idml-package".equals(mimeType.toString(this.encoding))) {
                throw new OkapiBadFilterInputException("IDML filter tried to initialise a file that is not supported.");
            }
            this.zipInputReader = new ZipInput.Reader(zipInputStream, this.encoding, this.inputFactory);
            this.designMap = new DesignMapParser(this.zipInputReader).parse(this.zipFile.getEntry("designmap.xml"));
            Preferences preferences = new PreferencesParser(this.zipInputReader).parse(this.zipFile.getEntry(this.designMap.getPreferencesPartName()));
            this.styleDefinitions = new StyleDefinitions.Default(new Markup.Default(new LinkedList<MarkupRange>()), this.zipInputReader, this.eventFactory);
            this.styleDefinitions.from(this.zipFile.getEntry(this.designMap.getStylesPartName()));
            ArrayList<PasteboardItem> pasteboardItems = new ArrayList<PasteboardItem>();
            ArrayList<PasteboardItem> invisiblePasteboardItems = new ArrayList<PasteboardItem>();
            List<Spread> masterSpreads = this.getSpreads(this.designMap.getMasterSpreadPartNames(), this.designMap.getActiveLayerId(), ParsingIdioms.MASTER_SPREAD);
            List<PasteboardItem> masterSpreadPasteboardItems = OrderingIdioms.getOrderedPasteboardItems(masterSpreads, preferences.getStoryPreference().getStoryDirection(), this.eventFactory);
            if (this.parameters.getExtractMasterSpreads()) {
                pasteboardItems.addAll(masterSpreadPasteboardItems);
            } else {
                invisiblePasteboardItems.addAll(masterSpreadPasteboardItems);
            }
            List<Spread> spreads = this.getSpreads(this.designMap.getSpreadPartNames(), this.designMap.getActiveLayerId(), ParsingIdioms.SPREAD);
            pasteboardItems.addAll(OrderingIdioms.getOrderedPasteboardItems(spreads, preferences.getStoryPreference().getStoryDirection(), this.eventFactory));
            List<PasteboardItem> visiblePasteboardItems = this.getVisiblePasteboardItems(this.designMap, pasteboardItems);
            invisiblePasteboardItems.addAll(this.getInvisiblePasteboardItems(pasteboardItems, visiblePasteboardItems));
            List<String> storyIds = OrderingIdioms.getOrderedStoryIds(visiblePasteboardItems);
            List<String> storyPartNames = OrderingIdioms.getOrderedStoryPartNames(this.designMap.getStoryPartNames(), storyIds);
            List<String> invisibleStoryIds = OrderingIdioms.getOrderedStoryIds(invisiblePasteboardItems);
            List<String> invisibleStoryPartNames = OrderingIdioms.getOrderedStoryPartNames(this.designMap.getStoryPartNames(), invisibleStoryIds);
            this.nonTranslatableSubDocuments = PartNames.getPartNames(this.designMap, invisibleStoryPartNames);
            this.zipFileEntries = this.getZipFileEntries(this.designMap, storyPartNames);
            this.currentSubDocumentId = 0;
            return this.getStartDocumentEvent(this.uri, this.sourceLocale, this.filterWriter);
        }

        private List<Spread> getSpreads(List<String> spreadPartNames, String activeLayerId, QName spreadName) throws IOException, XMLStreamException {
            ArrayList<Spread> spreads = new ArrayList<Spread>();
            SpreadParser sp = new SpreadParser(this.zipInputReader, spreadName, this.eventFactory, activeLayerId);
            for (String spreadPartName : spreadPartNames) {
                Spread spread = sp.parse(this.zipFile.getEntry(spreadPartName));
                spreads.add(spread);
            }
            return spreads;
        }

        private List<PasteboardItem> getVisiblePasteboardItems(DesignMap designMap, List<PasteboardItem> pasteboardItems) {
            return new PasteboardItem.VisibilityFilter(designMap.getLayers(), this.parameters.getExtractHiddenLayers(), this.parameters.getExtractHiddenPasteboardItems()).filterVisible(pasteboardItems);
        }

        private List<PasteboardItem> getInvisiblePasteboardItems(List<PasteboardItem> pasteboardItems, List<PasteboardItem> visiblePasteboardItems) {
            ArrayList<PasteboardItem> invisiblePasteboardItems = new ArrayList<PasteboardItem>(pasteboardItems);
            invisiblePasteboardItems.removeAll(visiblePasteboardItems);
            return invisiblePasteboardItems;
        }

        private Enumeration<? extends ZipEntry> getZipFileEntries(DesignMap designMap, List<String> storyPartNames) throws IOException, XMLStreamException {
            ArrayList<? extends ZipEntry> entryList = Collections.list(this.zipFile.entries());
            entryList.sort(new ZipEntryComparator(PartNames.getPartNames(designMap, storyPartNames)));
            return Collections.enumeration(entryList);
        }

        private Event getStartDocumentEvent(URI uri, LocaleId sourceLocale, IFilterWriter filterWriter) {
            StartDocument startDoc = new StartDocument(this.startDocumentId);
            startDoc.setName(uri.getPath());
            startDoc.setLocale(sourceLocale);
            startDoc.setMimeType("application/vnd.adobe.indesign-idml-package");
            startDoc.setFilterWriter(filterWriter);
            startDoc.setFilterId("okf_idml");
            startDoc.setFilterParameters(this.parameters);
            startDoc.setLineBreak(this.lineBreak);
            startDoc.setEncoding(this.encoding, false);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, null);
            return new Event(EventType.START_DOCUMENT, startDoc, skel);
        }

        @Override
        public boolean hasNextSubDocument() {
            return this.zipFileEntries.hasMoreElements();
        }

        @Override
        public SubDocument nextSubDocument() {
            ZipEntry zipEntry = this.zipFileEntries.nextElement();
            if (!this.isTranslatableSubDocument(zipEntry.getName())) {
                if (this.isStylesSubDocument(zipEntry.getName())) {
                    return new MarkupModifiableSubDocument(this.zipFile, zipEntry, this.outputFactory, this.encoding, this.styleDefinitions);
                }
                return new NonModifiableSubDocument(this.zipFile, zipEntry);
            }
            return new StorySubDocument(this.parameters, this.zipInputReader, this.eventFactory, this.zipFile, zipEntry, this.startDocumentId, String.valueOf(++this.currentSubDocumentId));
        }

        private boolean isTranslatableSubDocument(String partName) {
            return !this.nonTranslatableSubDocuments.contains(partName);
        }

        private boolean isStylesSubDocument(String entryName) {
            return this.designMap.getStylesPartName().equals(entryName);
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }

        private static class ZipEntryComparator
        implements Comparator<ZipEntry> {
            private List<String> partNames;

            ZipEntryComparator(List<String> partNames) {
                this.partNames = partNames;
            }

            @Override
            public int compare(ZipEntry o1, ZipEntry o2) {
                int index1 = this.partNames.indexOf(o1.getName());
                int index2 = this.partNames.indexOf(o2.getName());
                if (index1 == -1) {
                    index1 = Integer.MAX_VALUE;
                }
                if (index2 == -1) {
                    index2 = Integer.MAX_VALUE;
                }
                return Integer.compare(index1, index2);
            }
        }

        private static class PartNames {
            private static final String MIME_TYPE = "mimetype";
            private static final String DESIGN_MAP = "designmap.xml";
            private static final String CONTAINER = "META-INF/container.xml";
            private static final String METADATA = "META-INF/metadata.xml";

            private PartNames() {
            }

            static List<String> getPartNames(DesignMap designMap, List<String> storyPartNames) {
                ArrayList<String> partNames = new ArrayList<String>(Arrays.asList(MIME_TYPE, DESIGN_MAP, CONTAINER, METADATA));
                partNames.add(designMap.getGraphicPartName());
                partNames.add(designMap.getFontsPartName());
                partNames.add(designMap.getStylesPartName());
                partNames.add(designMap.getPreferencesPartName());
                partNames.add(designMap.getTagsPartName());
                partNames.add(designMap.getMappingPartName());
                partNames.addAll(designMap.getMasterSpreadPartNames());
                partNames.addAll(designMap.getSpreadPartNames());
                partNames.add(designMap.getBackingStoryPartName());
                partNames.addAll(storyPartNames);
                return partNames;
            }
        }
    }
}

