/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextPart;

public final class AlignedPair {
    private final List<TextPart> sourceParts;
    private final List<TextPart> targetParts;
    private final LocaleId localeId;

    public AlignedPair(List<TextPart> sourceParts, List<TextPart> targetParts, LocaleId localeId) {
        this.sourceParts = sourceParts;
        this.targetParts = targetParts;
        this.localeId = localeId;
    }

    public AlignedPair(Segment sourceSegment, Segment targetSegment, LocaleId localeId) {
        LinkedList<TextPart> sourceParts = new LinkedList<TextPart>();
        if (sourceSegment != null) {
            sourceParts.add(sourceSegment);
        }
        LinkedList<TextPart> targetParts = new LinkedList<TextPart>();
        if (targetSegment != null) {
            targetParts.add(targetSegment);
        }
        this.sourceParts = sourceParts;
        this.targetParts = targetParts;
        this.localeId = localeId;
    }

    public List<TextPart> getSourceParts() {
        return this.sourceParts;
    }

    public List<TextPart> getTargetParts() {
        return this.targetParts;
    }

    public LocaleId getLocaleId() {
        return this.localeId;
    }
}

