/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters.fontmappings;

import net.sf.okapi.common.LocalePair;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.filters.fontmappings.DefaultFontMapping;
import net.sf.okapi.common.filters.fontmappings.FontMapping;

public final class ParametersStringFontMapping
implements FontMapping {
    static final String SOURCE_LOCALE_PATTERN = "sourceLocalePattern";
    static final String TARGET_LOCALE_PATTERN = "targetLocalePattern";
    static final String SOURCE_FONT_PATTERN = "sourceFontPattern";
    static final String TARGET_FONT = "targetFont";
    private static final String ANY_STRING_EXPRESSION = ".*";
    private static final String DEFAULT_SOURCE_LOCALE_PATTERN = ".*";
    private static final String DEFAULT_TARGET_LOCALE_PATTERN = ".*";
    private static final String DEFAULT_SOURCE_FONT_PATTERN = ".*";
    static final String DEFAULT_TARGET_FONT = "";
    private final ParametersString parametersString;
    private FontMapping defaultFontMapping;
    private boolean read;

    public ParametersStringFontMapping(ParametersString parametersString) {
        this.parametersString = parametersString;
    }

    @Override
    public boolean applicableTo(LocalePair pair) {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.defaultFontMapping.applicableTo(pair);
    }

    @Override
    public boolean applicableTo(String sourceFont) {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.defaultFontMapping.applicableTo(sourceFont);
    }

    @Override
    public String targetFont() {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.defaultFontMapping.targetFont();
    }

    private void fromParametersString() {
        this.defaultFontMapping = new DefaultFontMapping(this.parametersString.getString(SOURCE_LOCALE_PATTERN, ".*"), this.parametersString.getString(TARGET_LOCALE_PATTERN, ".*"), this.parametersString.getString(SOURCE_FONT_PATTERN, ".*"), this.parametersString.getString(TARGET_FONT, DEFAULT_TARGET_FONT));
        this.read = true;
    }

    @Override
    public <T> T writtenTo(FontMapping.Output<T> output) {
        if (!this.read) {
            this.fromParametersString();
        }
        return this.defaultFontMapping.writtenTo(output);
    }
}

