/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class SubFilterEventConverter {
    private IdGenerator idGenerator;
    private SubFilter subFilter;
    private IEncoder parentEncoder;
    private Map<String, IResource> referents;

    public SubFilterEventConverter(SubFilter subFilter, IEncoder parentEncoder) {
        this.subFilter = subFilter;
        this.parentEncoder = parentEncoder;
        this.idGenerator = new IdGenerator(null);
        this.referents = new HashMap<String, IResource>();
    }

    public void reset() {
        this.idGenerator.reset(null);
        this.referents.clear();
    }

    public String convertRefIds(String str) {
        Object[] marker;
        StringBuilder in = new StringBuilder(str);
        StringBuilder out = new StringBuilder();
        while ((marker = TextFragment.getRefMarker(in)) != null) {
            String id = (String)marker[0];
            int start = (Integer)marker[1];
            int end = (Integer)marker[2];
            out.append(in.substring(0, start));
            IResource res = this.referents.get(id);
            if (res == null) {
                out.append(in.substring(start, end));
            } else {
                out.append(TextFragment.makeRefMarker(this.subFilter.buildResourceId(id, res.getClass())));
            }
            in.delete(0, end);
        }
        out.append((CharSequence)in);
        return out.toString();
    }

    private void convertTextContainer(TextContainer tc) {
        for (TextPart textPart : tc) {
            TextFragment tf = textPart.getContent();
            for (Code code : tf.getCodes()) {
                if (!code.hasReference()) continue;
                String data = code.getOuterData();
                String newData = this.convertRefIds(data);
                if (code.hasOuterData()) {
                    code.setOuterData(newData);
                    continue;
                }
                code.setData(newData);
            }
        }
    }

    private void convertRefs(Event event) {
        if (event.isMultiEvent()) {
            MultiEvent me = event.getMultiEvent();
            for (Event e : me) {
                this.convertRefs(e);
            }
        } else {
            if (event.isTextUnit()) {
                ITextUnit tu = event.getTextUnit();
                this.convertTextContainer(tu.getSource());
                for (LocaleId locId : tu.getTargetLocales()) {
                    this.convertTextContainer(tu.getTarget(locId));
                }
            }
            ISkeleton skel = event.getResource().getSkeleton();
            this.subFilter.convertRefsInSkeleton(skel);
        }
    }

    public Event convertEvent(Event event) {
        IReferenceable r;
        IResource res = event.getResource();
        if (res instanceof IReferenceable && (r = (IReferenceable)((Object)res)).isReferent()) {
            this.referents.put(res.getId(), res);
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                StartSubfilter startSubfilter;
                EncoderManager em;
                StartDocument sd = event.getStartDocument();
                IFilterWriter filterWriter = sd.getFilterWriter();
                if (filterWriter != null && (em = filterWriter.getEncoderManager()) != null) {
                    em.setDefaultOptions(sd.getFilterParameters(), sd.getEncoding(), sd.getLineBreak());
                    em.updateEncoder(sd.getMimeType());
                }
                this.subFilter.startSubfilter = startSubfilter = new StartSubfilter(this.subFilter.buildResourceId(null, StartSubfilter.class), sd, this.parentEncoder);
                startSubfilter.setName(this.subFilter.buildResourceName(null, false, StartSubfilter.class));
                event = new Event(EventType.START_SUBFILTER, startSubfilter);
                break;
            }
            case END_DOCUMENT: {
                EndSubfilter endSubfilter;
                this.subFilter.endSubfilter = endSubfilter = new EndSubfilter(this.subFilter.buildResourceId(null, EndSubfilter.class));
                endSubfilter.setSkeleton(event.getEnding().getSkeleton());
                event = new Event(EventType.END_SUBFILTER, endSubfilter);
                break;
            }
            default: {
                res.setId(this.subFilter.buildResourceId(res.getId(), res.getClass()));
                if (event.getResource() instanceof INameable) {
                    INameable nres = (INameable)event.getResource();
                    String name = nres.getName();
                    boolean isEmpty = Util.isEmpty(name);
                    if (isEmpty) {
                        name = this.idGenerator.createId();
                    }
                    nres.setName(this.subFilter.buildResourceName(name, isEmpty, nres.getClass()));
                }
                this.convertRefs(event);
            }
        }
        return event;
    }
}

