/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.ttxsplitter;

import java.net.URI;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.steps.ttxsplitter.TTXJoiner;
import net.sf.okapi.steps.ttxsplitter.TTXJoinerParameters;

@UsingParameters(value=TTXJoinerParameters.class)
public class TTXJoinerStep
extends BasePipelineStep {
    private TTXJoinerParameters params = new TTXJoinerParameters();
    private ArrayList<URI> inputList;

    @Override
    public String getDescription() {
        return "Rebuilds previously split TTX documents into their original documents. Expects: raw document. Sends back: raw document.";
    }

    @Override
    public String getName() {
        return "TTX Joiner";
    }

    @Override
    public TTXJoinerParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (TTXJoinerParameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.inputList = new ArrayList();
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        URI uri = event.getRawDocument().getInputURI();
        if (uri == null) {
            throw new OkapiBadStepInputException("TTX Joiner expects URI inputs.");
        }
        this.inputList.add(uri);
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        TTXJoiner joiner = new TTXJoiner(this.params);
        joiner.process(this.inputList);
        return event;
    }
}

