/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.terminologyleveraging;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=TerminologyParameters.class)
public class TerminologyParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String LEVERAGE = "leverage";
    private static final String ANNOTATE_SOURCE = "annotateSource";
    private static final String ANNOTATE_TARGET = "annotateTarget";
    private static final String CONNECTOR_CLASSNAME = "connectorClassName";
    private static final String CONNECTOR_PARAMETERS = "connectorParameters";

    public boolean getLeverage() {
        return this.getBoolean(LEVERAGE);
    }

    public void setLeverage(boolean leverage) {
        this.setBoolean(LEVERAGE, leverage);
    }

    public boolean getAnnotateSource() {
        return this.getBoolean(ANNOTATE_SOURCE);
    }

    public void setAnnotateSource(boolean annotateSource) {
        this.setBoolean(ANNOTATE_SOURCE, annotateSource);
    }

    public boolean getAnnotateTarget() {
        return this.getBoolean(ANNOTATE_TARGET);
    }

    public void setAnnotateTarget(boolean annotateTarget) {
        this.setBoolean(ANNOTATE_TARGET, annotateTarget);
    }

    public String getConnectorClassName() {
        return this.getString(CONNECTOR_CLASSNAME);
    }

    public void setConnectorClassName(String connectorClassName) {
        this.setString(CONNECTOR_CLASSNAME, connectorClassName);
    }

    public String getConnectorParameters() {
        return this.getGroup(CONNECTOR_PARAMETERS);
    }

    public void setConnectorParameters(String connectorParameters) {
        this.setGroup(CONNECTOR_PARAMETERS, connectorParameters);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(LEVERAGE, "Leverage status:", "Indication that leveraging should be done");
        desc.add(ANNOTATE_SOURCE, "Annotate source:", "Indication that source segment annotation should be done");
        desc.add(ANNOTATE_TARGET, "Annotate target", "Indication that target segment annotation should be done");
        desc.add(CONNECTOR_CLASSNAME, "Connector class", "Full class name of the terminology connector");
        desc.add(CONNECTOR_PARAMETERS, "Connector parameters", "String representation of parameters specific to terminology connector");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("Terminology Leveraging", true, false);
        desc.addCheckboxPart(parametersDescription.get(LEVERAGE));
        desc.addCheckboxPart(parametersDescription.get(ANNOTATE_SOURCE));
        desc.addCheckboxPart(parametersDescription.get(ANNOTATE_TARGET));
        desc.addTextInputPart(parametersDescription.get(CONNECTOR_CLASSNAME));
        desc.addTextInputPart(parametersDescription.get(CONNECTOR_PARAMETERS));
        return desc;
    }
}

