/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.searchandreplace;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.searchandreplace.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class SearchAndReplaceStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private Matcher matcher;
    private Pattern[] patterns;
    private URI outputURI;
    private LocaleId targetLocale;
    private String[] search;
    private String[] replace;
    private int[] sourceCounts;
    private int[] targetCounts;
    List<String[]> replacementWords;
    private int[] sourceReplacementCounts;
    private int[] targetReplacementCounts;
    private ProcType procType;
    private String rootDir;
    private String inputRootDir;
    private boolean firstEventDone = false;

    @Override
    public void destroy() {
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public String getDescription() {
        return "Performs search and replace on the entire file or the text units. Expects raw document or filter events. Sends back: raw document or filter events.";
    }

    @Override
    public String getName() {
        return "Search and Replace";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        int i;
        if (this.params.getRegEx()) {
            int flags = 0;
            this.patterns = new Pattern[this.params.rules.size()];
            if (this.params.getDotAll()) {
                flags |= 0x20;
            }
            if (this.params.getIgnoreCase()) {
                flags |= 2;
            }
            if (this.params.getMultiLine()) {
                flags |= 8;
            }
            for (int i2 = 0; i2 < this.params.rules.size(); ++i2) {
                String[] s = this.params.rules.get(i2);
                if (!this.params.getRegEx()) continue;
                this.patterns[i2] = Pattern.compile(s[1], flags);
            }
        } else {
            this.search = new String[this.params.rules.size()];
            for (i = 0; i < this.params.rules.size(); ++i) {
                this.search[i] = this.unescape(this.params.rules.get(i)[1], false);
            }
        }
        this.replace = new String[this.params.rules.size()];
        this.sourceCounts = new int[this.params.rules.size()];
        this.targetCounts = new int[this.params.rules.size()];
        for (i = 0; i < this.params.rules.size(); ++i) {
            this.replace[i] = this.unescape(this.params.rules.get(i)[2], this.params.getRegEx());
        }
        if (!SearchAndReplaceStep.isEmpty(this.params.getReplacementsPath())) {
            String finalPath = Util.fillRootDirectoryVariable(this.params.getReplacementsPath(), this.rootDir);
            finalPath = Util.fillInputRootDirectoryVariable(finalPath, this.inputRootDir);
            this.replacementWords = this.loadList(finalPath);
        } else {
            this.replacementWords = Collections.emptyList();
        }
        this.sourceReplacementCounts = new int[this.replacementWords.size()];
        this.targetReplacementCounts = new int[this.replacementWords.size()];
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        StringBuffer sb = new StringBuffer();
        if (this.procType == ProcType.FILTER) {
            sb.append("Search and Replace in text units:\r\n");
        } else {
            sb.append("Search and Replace in file:\r\n");
        }
        if (this.procType == ProcType.FILTER) {
            if (this.params.getSource()) {
                sb.append("\r\nSource Results:\r\n");
                sb.append(this.sourceResults());
            }
            if (this.params.getTarget()) {
                sb.append("\r\nTarget Results:\r\n");
                sb.append(this.targetResults());
            }
        } else {
            sb.append("\r\nResults:\r\n");
            sb.append(this.targetResults());
        }
        this.logger.info(sb.toString());
        if (this.params.getSaveLog()) {
            this.generateReport(sb.toString());
        }
        return event;
    }

    private String sourceResults() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.params.getRegEx()) {
            sb.append("\r\nRegEx:\r\n");
            for (i = 0; i < this.patterns.length; ++i) {
                sb.append(String.format("# of replacements for '%s': %s\r\n", this.patterns[i], this.sourceCounts[i]));
            }
        } else {
            sb.append("\r\nNon-RegEx:\r\n");
            for (i = 0; i < this.search.length; ++i) {
                sb.append(String.format("# of replacements for '%s': %s\r\n", this.search[i], this.sourceCounts[i]));
            }
        }
        int replacementIndex = 0;
        sb.append("\r\nNon-RegEx from file:\r\n");
        for (String[] values : this.replacementWords) {
            sb.append(String.format("# of replacements for '%s': %s\r\n", values[0], this.sourceReplacementCounts[replacementIndex]));
            ++replacementIndex;
        }
        return sb.toString();
    }

    private String targetResults() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.params.getRegEx()) {
            sb.append("\r\nRegEx:\r\n");
            for (i = 0; i < this.patterns.length; ++i) {
                sb.append(String.format("# of replacements for '%s': %s\r\n", this.patterns[i], this.targetCounts[i]));
            }
        } else {
            sb.append("\r\nNon-RegEx:\r\n");
            for (i = 0; i < this.search.length; ++i) {
                sb.append(String.format("# of replacements for '%s': %s\r\n", this.search[i], this.targetCounts[i]));
            }
        }
        int replacementIndex = 0;
        sb.append("\r\nNon-RegEx from file:\r\n");
        for (String[] values : this.replacementWords) {
            sb.append(String.format("# of replacements for '%s': %s\r\n", values[0], this.targetReplacementCounts[replacementIndex]));
            ++replacementIndex;
        }
        return sb.toString();
    }

    private void generateReport(String text) {
        PrintWriter writer = null;
        try {
            String finalPath = Util.fillRootDirectoryVariable(this.params.getLogPath(), this.rootDir);
            finalPath = Util.fillInputRootDirectoryVariable(finalPath, this.inputRootDir);
            Util.createDirectories(finalPath);
            writer = new PrintWriter(finalPath, "UTF-8");
            writer.println(text);
        }
        catch (IOException e) {
            throw new OkapiException("Error when writing output file.", e);
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    @Override
    protected Event handleRawDocument(Event event) {
        if (!this.firstEventDone) {
            this.firstEventDone = true;
        }
        this.procType = ProcType.PLAINTEXT;
        String encoding = null;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        String result = null;
        StringBuilder assembled = new StringBuilder();
        try {
            File outFile;
            RawDocument rawDoc = event.getRawDocument();
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(rawDoc.getStream(), rawDoc.getEncoding());
            detector.detectAndRemoveBom();
            encoding = detector.getEncoding();
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), encoding));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                assembled.append(buf, 0, numRead);
            }
            reader.close();
            reader = null;
            result = assembled.toString();
            assembled = null;
            if (this.isLastOutputStep()) {
                outFile = new File(this.outputURI);
                Util.createDirectories(outFile.getAbsolutePath());
            } else {
                try {
                    outFile = File.createTempFile("~okapi-50_okp-snr_", ".tmp");
                }
                catch (Throwable e) {
                    throw new OkapiIOException("Cannot create temporary output.", e);
                }
            }
            result = this.searchAndReplace(result, TargetType.ALL);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), encoding));
            Util.writeBOMIfNeeded(writer, detector.hasUtf8Bom(), encoding);
            writer.write(result);
            writer.close();
            writer = null;
            event.setResource(new RawDocument(outFile.toURI(), encoding, rawDoc.getSourceLocale(), rawDoc.getTargetLocale()));
        }
        catch (IOException e) {
            throw new OkapiException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                    writer = null;
                }
                if (reader != null) {
                    reader.close();
                    reader = null;
                }
            }
            catch (IOException e) {
                throw new OkapiException(e);
            }
        }
        return event;
    }

    private String unescape(String s, boolean isRegex) {
        int i = 0;
        int len = s.length();
        StringBuffer sb = new StringBuffer(len);
        block7: while (i < len) {
            char c;
            if ((c = s.charAt(i++)) == '\\' && i < len) {
                c = s.charAt(i++);
                switch (c) {
                    case 'u': {
                        c = (char)Integer.parseInt(s.substring(i, i + 4), 16);
                        sb.append(c);
                        i += 4;
                        continue block7;
                    }
                    case 'N': {
                        sb.append(System.getProperty("line.separator"));
                        continue block7;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block7;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block7;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    default: {
                        if (!isRegex) break;
                        sb.append('\\');
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    protected Event handleTextUnit(Event event) {
        if (!this.firstEventDone) {
            this.firstEventDone = true;
        }
        this.procType = ProcType.FILTER;
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        String tmp = null;
        try {
            TextContainer tc;
            if (this.params.getSource()) {
                tc = tu.getSource();
                for (Segment seg : tc.getSegments()) {
                    tmp = this.searchAndReplace(seg.text.toString(), TargetType.SOURCE);
                    seg.text.setCodedText(tmp);
                }
            }
            if (this.params.getTarget() && (tc = tu.getTarget(this.targetLocale)) != null) {
                for (Segment seg : tc.getSegments()) {
                    tmp = this.searchAndReplace(seg.text.toString(), TargetType.TARGET);
                    seg.text.setCodedText(tmp);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Error when updating content: '{}'.\n{}", new Object[]{tmp, e.getMessage(), e});
        }
        return event;
    }

    private String searchAndReplace(String result, TargetType targetType) {
        int i;
        if (this.params.getRegEx()) {
            for (i = 0; i < this.params.rules.size(); ++i) {
                String[] s = this.params.rules.get(i);
                if (!s[0].equals("true")) continue;
                int matches = SearchAndReplaceStep.countRegExMatches(result, this.patterns[i]);
                this.matcher = this.patterns[i].matcher(result);
                if (this.params.getReplaceAll()) {
                    result = this.matcher.replaceAll(this.replace[i]);
                } else if (matches > 0) {
                    matches = 1;
                    result = this.matcher.replaceFirst(this.replace[i]);
                }
                if (targetType == TargetType.SOURCE) {
                    int n = i;
                    this.sourceCounts[n] = this.sourceCounts[n] + matches;
                    continue;
                }
                int n = i;
                this.targetCounts[n] = this.targetCounts[n] + matches;
            }
        } else {
            for (i = 0; i < this.params.rules.size(); ++i) {
                if (!this.params.rules.get(i)[0].equals("true")) continue;
                int matches = SearchAndReplaceStep.countMatches(result, this.search[i]);
                if (targetType == TargetType.SOURCE) {
                    int n = i;
                    this.sourceCounts[n] = this.sourceCounts[n] + matches;
                } else {
                    int n = i;
                    this.targetCounts[n] = this.targetCounts[n] + matches;
                }
                result = result.replace(this.search[i], this.replace[i]);
            }
        }
        if (this.replacementWords != null) {
            int replacementIndex = 0;
            for (String[] values : this.replacementWords) {
                int matches = SearchAndReplaceStep.countMatches(result, values[0]);
                if (targetType == TargetType.SOURCE) {
                    int n = replacementIndex;
                    this.sourceReplacementCounts[n] = this.sourceReplacementCounts[n] + matches;
                } else {
                    int n = replacementIndex;
                    this.targetReplacementCounts[n] = this.targetReplacementCounts[n] + matches;
                }
                ++replacementIndex;
                result = result.replaceAll(values[0], values[1]);
            }
        }
        return result;
    }

    List<String[]> loadList(String path) {
        ArrayList<String[]> map = new ArrayList<String[]>();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream is = new FileInputStream(path);
            reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                String[] values;
                String test = line.trim();
                if (test.length() == 0 || test.charAt(0) == '#' || (values = line.split("\\t", -1)) == null || values.length < 2) continue;
                map.add(values);
            }
        }
        catch (IOException e) {
            throw new OkapiException("Error reading replacements list.", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new OkapiException("Error reading replacements list.", e);
                }
            }
        }
        return map;
    }

    public static int countRegExMatches(String str, Pattern p) {
        if (SearchAndReplaceStep.isEmpty(str)) {
            return 0;
        }
        Matcher matcher = p.matcher(str);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static int countMatches(String str, String sub) {
        if (SearchAndReplaceStep.isEmpty(str) || SearchAndReplaceStep.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static enum TargetType {
        SOURCE,
        TARGET,
        ALL;

    }

    public static enum ProcType {
        UNSPECIFIED,
        PLAINTEXT,
        FILTER;

    }
}

