/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.simplifier.ResourceSimplifier;
import net.sf.okapi.steps.gcaligner.AlignmentScorer;
import net.sf.okapi.steps.gcaligner.GaleAndChurch;
import net.sf.okapi.steps.paraaligner.AlignedParagraphs;
import net.sf.okapi.steps.paraaligner.EventComparator;
import net.sf.okapi.steps.paraaligner.ParagraphAligner;
import net.sf.okapi.steps.paraaligner.Parameters;
import org.incava.diff.LCS;

@UsingParameters(value=Parameters.class)
public class ParagraphAlignerStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private IFilter filter = null;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;
    private LocaleId sourceLocale;
    private List<Event> srcEvents;
    private List<Event> trgEvents;
    private List<Event> textUnitEvents;
    private RawDocument targetInput = null;
    private EventComparator comparator;
    private ParagraphAligner paragraphAligner;
    ResourceSimplifier sourceSimplifier;

    public ParagraphAlignerStep() {
        LinkedList<AlignmentScorer<ITextUnit>> scorerList = new LinkedList<AlignmentScorer<ITextUnit>>();
        scorerList.add(new GaleAndChurch());
        this.paragraphAligner = new ParagraphAligner(scorerList);
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.targetInput = secondInput;
    }

    @Override
    public String getName() {
        return "Paragraph Alignment";
    }

    @Override
    public String getDescription() {
        return "Align paragraphs (text units) between a source and a target document. Only TextUnit events are passed along - all other events are lost";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (this.targetInput != null) {
            this.trgEvents = new ArrayList<Event>();
            this.initializeFilter();
        }
        this.srcEvents = new ArrayList<Event>();
        this.textUnitEvents = new ArrayList<Event>();
        this.comparator = new EventComparator();
        this.sourceSimplifier = new ResourceSimplifier(this.sourceLocale);
        return this.eventIndicatingTargetWasConsumed(event);
    }

    @Override
    protected Event handleEndDocument(Event event) {
        this.srcEvents.addAll(this.sourceSimplifier.convertToList(event));
        LCS<Event> skeletonAlignments = this.skeletonAlign();
        this.paragraphAlign(skeletonAlignments);
        this.textUnitEvents.add(event);
        Event multiEvent = new Event(EventType.MULTI_EVENT, new MultiEvent(this.textUnitEvents));
        if (this.filter != null) {
            this.filter.close();
        }
        this.srcEvents.clear();
        this.srcEvents = null;
        this.trgEvents.clear();
        this.trgEvents = null;
        return multiEvent;
    }

    @Override
    protected Event handleDocumentPart(Event event) {
        this.srcEvents.addAll(this.sourceSimplifier.convertToList(event));
        return Event.createNoopEvent();
    }

    @Override
    protected Event handleStartSubDocument(Event event) {
        this.srcEvents.addAll(this.sourceSimplifier.convertToList(event));
        return Event.createNoopEvent();
    }

    @Override
    protected Event handleEndSubDocument(Event event) {
        this.srcEvents.addAll(this.sourceSimplifier.convertToList(event));
        return Event.createNoopEvent();
    }

    @Override
    protected Event handleStartGroup(Event event) {
        this.srcEvents.addAll(this.sourceSimplifier.convertToList(event));
        return Event.createNoopEvent();
    }

    @Override
    protected Event handleEndGroup(Event event) {
        this.srcEvents.addAll(this.sourceSimplifier.convertToList(event));
        return Event.createNoopEvent();
    }

    @Override
    protected Event handleTextUnit(Event sourceEvent) {
        this.srcEvents.addAll(this.sourceSimplifier.convertToList(sourceEvent));
        return Event.createNoopEvent();
    }

    private void initializeFilter() {
        if (this.targetInput == null) {
            throw new OkapiBadStepInputException("No target document found.");
        }
        this.filter = this.fcMapper.createFilter(this.targetInput.getFilterConfigId(), null);
        this.filter.open(this.targetInput);
        this.filterTarget();
    }

    private void filterTarget() {
        Event event = null;
        ResourceSimplifier simplifier = new ResourceSimplifier(this.targetLocale);
        while (this.filter.hasNext()) {
            event = this.filter.next();
            this.trgEvents.addAll(simplifier.convertToList(event));
        }
    }

    private LCS<Event> skeletonAlign() {
        LCS diffEvents = null;
        if (!this.params.isUseSkeletonAlignment()) {
            return diffEvents;
        }
        diffEvents = new LCS(this.srcEvents, this.trgEvents, (Comparator)this.comparator);
        return diffEvents;
    }

    private void paragraphAlign(LCS<Event> skeletonAlignments) {
        int srcStartMatchIndex = 0;
        int trgStartMatchIndex = 0;
        int srcEndMatchIndex = this.srcEvents.size();
        int trgEndMatchIndex = this.trgEvents.size();
        if (skeletonAlignments != null) {
            int n = -1;
            for (Integer m : skeletonAlignments.getMatches()) {
                ++n;
                if (m == null) continue;
                srcEndMatchIndex = n;
                trgEndMatchIndex = m;
                this.addAlignedTextUnits(this.srcEvents.subList(srcStartMatchIndex, srcEndMatchIndex), this.trgEvents.subList(trgStartMatchIndex, trgEndMatchIndex));
                srcStartMatchIndex = srcEndMatchIndex;
                trgStartMatchIndex = trgEndMatchIndex;
            }
        }
        srcEndMatchIndex = this.srcEvents.size();
        trgEndMatchIndex = this.trgEvents.size();
        this.addAlignedTextUnits(this.srcEvents.subList(srcStartMatchIndex, srcEndMatchIndex), this.trgEvents.subList(trgStartMatchIndex, trgEndMatchIndex));
    }

    private void addAlignedTextUnits(List<Event> ses, List<Event> tes) {
        List<ITextUnit> stus = this.filterOutNonTextUnit(ses);
        List<ITextUnit> ttus = this.filterOutNonTextUnit(tes);
        if (!stus.isEmpty() && !ttus.isEmpty()) {
            this.textUnitEvents.addAll(this.textUnitsToEvents(this.alignTus(stus, ttus)));
        }
    }

    private List<ITextUnit> filterOutNonTextUnit(List<Event> events) {
        LinkedList<ITextUnit> tus = new LinkedList<ITextUnit>();
        for (Event e : events) {
            if (!e.isTextUnit()) continue;
            tus.add(e.getTextUnit());
        }
        return tus;
    }

    private List<ITextUnit> alignTus(List<ITextUnit> stus, List<ITextUnit> ttus) {
        AlignedParagraphs preAlignedTus = this.paragraphAligner.align(stus, ttus, this.sourceLocale, this.targetLocale, this.params.isOutputOneToOneMatchesOnly());
        List<ITextUnit> alignedTus = preAlignedTus.align();
        return alignedTus;
    }

    private Event eventIndicatingTargetWasConsumed(Event startDocEvent) {
        ArrayList<Event> list = new ArrayList<Event>();
        PipelineParameters pp = new PipelineParameters();
        pp.setSecondInputRawDocument(null);
        list.add(new Event(EventType.PIPELINE_PARAMETERS, pp));
        list.add(startDocEvent);
        this.srcEvents.addAll(this.sourceSimplifier.convertToList(startDocEvent));
        return new Event(EventType.MULTI_EVENT, new MultiEvent(list));
    }

    private List<Event> textUnitsToEvents(List<ITextUnit> tus) {
        ArrayList<Event> events = new ArrayList<Event>();
        Iterator<ITextUnit> it = tus.iterator();
        while (it.hasNext()) {
            Event event = new Event(EventType.TEXT_UNIT, it.next());
            events.add(event);
        }
        return events;
    }
}

