/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.codesimplifier;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.MimeTypeMapper;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.annotation.SimplifierRulesAnnotaton;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.Custom;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.common.codesimplifier.Parameters;
import net.sf.okapi.steps.common.codesimplifier.PostSegmentationParameters;

@UsingParameters(value=PostSegmentationParameters.class)
public class PostSegmentationCodeSimplifierStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private SimplifierRulesAnnotaton rules;

    @Override
    public String getDescription() {
        return "Merges adjacent inline codes in the source and target part of a text unit. Also where possible, moves leading and trailing codes of the source to inter-segment TextParts. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Post-segmentation Inline Codes Simplifier";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        boolean segmentation;
        ITextUnit tu = event.getTextUnit();
        String r = null;
        if (this.rules != null) {
            r = this.rules.getRules();
        }
        if (!(segmentation = MimeTypeMapper.isSegmentationSupported(tu.getMimeType()))) {
            TextUnitUtil.simplifyCodesPostSegmentation(tu, r, this.params.getRemoveLeadingTrailingCodes(), this.params.getMergeCodes());
        }
        return super.handleTextUnit(event);
    }

    @Override
    protected Event handleCustom(Event event) {
        Custom c = (Custom)event.getResource();
        this.rules = c.getAnnotation(SimplifierRulesAnnotaton.class);
        return super.handleCustom(event);
    }
}

