/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.Objects;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.its.ITSItems;
import net.sf.okapi.lib.xliff2.its.IWithITSAttributes;

public class MTagCommon
implements IWithITSAttributes {
    private String id;
    private String type;
    private String value;
    private String ref;
    private Boolean translate;
    private ITSItems itsItems;

    public MTagCommon(String id, String type) {
        this.setId(id);
        this.setType(type);
    }

    public MTagCommon(MTagCommon original) {
        this.id = original.id;
        this.type = original.type;
        this.value = original.value;
        this.ref = original.ref;
        this.translate = original.translate;
        if (original.hasITSItem()) {
            this.setITSItems(new ITSItems(original.itsItems));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id == null) {
            throw new InvalidParameterException("ID cannot be null.");
        }
        this.id = id;
    }

    public void setType(String type) {
        int n;
        if (type == null) {
            type = "generic";
        } else if (!(";generic;comment;term;".contains(";" + type + ";") || (n = type.indexOf(58)) != -1 && n != 0 && n != type.length() - 1)) {
            throw new InvalidParameterException(String.format("Invalid value '%s' for an annotation type.", type));
        }
        this.type = type;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getTranslate() {
        return this.translate;
    }

    public void setTranslate(Boolean translate) {
        this.translate = translate;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof MTagCommon)) {
            return false;
        }
        MTagCommon that = (MTagCommon)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value) && Objects.equals(this.ref, that.ref) && Objects.equals(this.translate, that.translate) && Objects.equals(this.itsItems, that.itsItems);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.value, this.ref, this.translate, this.itsItems);
    }

    @Override
    public boolean hasITSItem() {
        if (this.itsItems == null) {
            return false;
        }
        return !this.itsItems.isEmpty();
    }

    @Override
    public ITSItems getITSItems() {
        if (this.itsItems == null) {
            this.itsItems = new ITSItems();
        }
        return this.itsItems;
    }

    @Override
    public void setITSItems(ITSItems itsItems) {
        this.itsItems = itsItems;
    }

    public String getType() {
        return this.type;
    }
}

