/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2.util;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.TargetState;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.slf4j.LoggerFactory;

public class PropertiesMapper {
    private static final Pattern EXTENDED_ATTRIBUTE_KEY_PATTERN = Pattern.compile("^" + Pattern.quote("extendedAttribute.") + "(.*)" + Pattern.quote("==") + "\\{(.*?)\\}(.*)$");

    public static void setStartXliffProperties(StartXliffData xliffStartXliff, StartDocument okapiStartDocument) {
        PropertiesMapper.setProperty("srcLang", xliffStartXliff.getSourceLanguage(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setProperty("trgLang", xliffStartXliff.getTargetLanguage(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setProperty("version", xliffStartXliff.getVersion(), (IWithProperties)okapiStartDocument);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartXliff, okapiStartDocument);
    }

    public static void setStartXliffProperties(StartDocument okapiStartDocument, StartXliffData xliffStartXliff) {
        xliffStartXliff.setSourceLanguage(okapiStartDocument.getLocale().toString());
        PropertiesMapper.setExtendedAttributes(okapiStartDocument, (IWithExtAttributes)xliffStartXliff);
    }

    public static void setStartFileProperties(StartFileData xliffStartFileData, StartSubDocument okapiStartSubDoc) {
        okapiStartSubDoc.setId(xliffStartFileData.getId());
        okapiStartSubDoc.setIsTranslatable(xliffStartFileData.getTranslate());
        PropertiesMapper.setProperty("srcDir", xliffStartFileData.getSourceDir(), (IWithProperties)okapiStartSubDoc);
        PropertiesMapper.setProperty("trgDir", xliffStartFileData.getTargetDir(), (IWithProperties)okapiStartSubDoc);
        PropertiesMapper.setProperty("canResegment", xliffStartFileData.getCanResegment(), (IWithProperties)okapiStartSubDoc);
        okapiStartSubDoc.setName(xliffStartFileData.getOriginal());
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartFileData, okapiStartSubDoc);
    }

    public static void setStartFileProperties(StartSubDocument okapiStartSubDoc, StartFileData xliffStartFileData) {
        xliffStartFileData.setId(okapiStartSubDoc.getId());
        xliffStartFileData.setTranslate(okapiStartSubDoc.isTranslatable());
        xliffStartFileData.setOriginal(okapiStartSubDoc.getName());
        xliffStartFileData.setSourceDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("srcDir", okapiStartSubDoc)));
        xliffStartFileData.setTargetDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("trgDir", okapiStartSubDoc)));
        xliffStartFileData.setCanResegment(PropertiesMapper.stringToBoolean(PropertiesMapper.getProperty("canResegment", okapiStartSubDoc)));
        PropertiesMapper.setExtendedAttributes(okapiStartSubDoc, (IWithExtAttributes)xliffStartFileData);
    }

    public static void setGroupProperties(StartGroupData xliffStartGroupData, StartGroup okapiStartGroup) {
        okapiStartGroup.setId(xliffStartGroupData.getId());
        okapiStartGroup.setIsTranslatable(xliffStartGroupData.getTranslate());
        okapiStartGroup.setName(xliffStartGroupData.getName());
        okapiStartGroup.setType(xliffStartGroupData.getType());
        PropertiesMapper.setProperty("canResegment", xliffStartGroupData.getCanResegment(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setProperty("srcDir", xliffStartGroupData.getSourceDir(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setProperty("trgDir", xliffStartGroupData.getTargetDir(), (IWithProperties)okapiStartGroup);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliffStartGroupData, okapiStartGroup);
    }

    public static void setGroupProperties(StartGroup okapiStartGroup, StartGroupData xliffStartGroupData) {
        xliffStartGroupData.setId(okapiStartGroup.getId());
        xliffStartGroupData.setTranslate(okapiStartGroup.isTranslatable());
        String canResegment = PropertiesMapper.getProperty("canResegment", okapiStartGroup);
        if (canResegment != null) {
            xliffStartGroupData.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
        }
        xliffStartGroupData.setSourceDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("srcDir", okapiStartGroup)));
        xliffStartGroupData.setTargetDir(PropertiesMapper.stringToDirection(PropertiesMapper.getProperty("trgDir", okapiStartGroup)));
        xliffStartGroupData.setType(okapiStartGroup.getType());
        PropertiesMapper.setExtendedAttributes(okapiStartGroup, (IWithExtAttributes)xliffStartGroupData);
        xliffStartGroupData.setName(okapiStartGroup.getName());
    }

    public static void setTextUnitProperties(Unit unit, ITextUnit tu) {
        tu.setId(unit.getId());
        tu.setIsTranslatable(unit.getTranslate());
        PropertiesMapper.setProperty("name", unit.getName(), (IWithProperties)tu);
        PropertiesMapper.setProperty("canResegment", unit.getCanResegment(), (IWithProperties)tu);
        PropertiesMapper.setProperty("type", unit.getType(), (IWithProperties)tu);
        PropertiesMapper.setProperty("srcDir", unit.getSourceDir(), (IWithProperties)tu);
        PropertiesMapper.setProperty("trgDir", unit.getTargetDir(), (IWithProperties)tu);
        boolean preserveWhitespace = false;
        for (Segment segment : unit.getSegments()) {
            if (!segment.getPreserveWS()) continue;
            preserveWhitespace = true;
        }
        tu.setPreserveWhitespaces(preserveWhitespace);
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)unit, tu);
    }

    public static void setTextUnitProperties(ITextUnit okapiTextUnit, Unit xliffTextUnit) {
        String targetDirection;
        String sourceDirection;
        xliffTextUnit.setId(okapiTextUnit.getId());
        xliffTextUnit.setName(okapiTextUnit.getName());
        xliffTextUnit.setType(okapiTextUnit.getType());
        xliffTextUnit.setTranslate(okapiTextUnit.isTranslatable());
        String canResegment = PropertiesMapper.getProperty("canResegment", okapiTextUnit);
        if (canResegment != null) {
            xliffTextUnit.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
        }
        if ((sourceDirection = PropertiesMapper.getProperty("srcDir", okapiTextUnit)) != null) {
            xliffTextUnit.setTargetDir(PropertiesMapper.stringToDirection(sourceDirection));
        }
        if ((targetDirection = PropertiesMapper.getProperty("trgDir", okapiTextUnit)) != null) {
            xliffTextUnit.setSourceDir(PropertiesMapper.stringToDirection(targetDirection));
        }
        PropertiesMapper.setExtendedAttributes(okapiTextUnit, (IWithExtAttributes)xliffTextUnit);
    }

    public static void setPartProperties(Part xliffPart, TextPart okapiPart) {
        okapiPart.originalId = xliffPart.getId();
        PropertiesMapper.setProperty("xmlPreserveWS", xliffPart.getPreserveWS(), (IWithProperties)okapiPart);
        if (xliffPart.isSegment()) {
            Segment xliffSegment = (Segment)xliffPart;
            PropertiesMapper.setProperty("canResegment", xliffSegment.getCanResegment(), (IWithProperties)okapiPart);
            PropertiesMapper.setProperty("state", xliffSegment.getState(), (IWithProperties)okapiPart);
            PropertiesMapper.setProperty("subState", xliffSegment.getSubState(), (IWithProperties)okapiPart);
        }
    }

    public static void setPartProperties(TextPart okapiSourcePart, Part xliffPart, ITextUnit okapiTextUnit) {
        String xmlPreserveWhitespace = PropertiesMapper.getProperty("xmlPreserveWS", okapiSourcePart);
        xliffPart.setPreserveWS(xmlPreserveWhitespace != null && PropertiesMapper.stringToBoolean(xmlPreserveWhitespace) || xmlPreserveWhitespace == null && okapiTextUnit.preserveWhitespaces());
        xliffPart.setId(okapiSourcePart.originalId);
        if (xliffPart.isSegment()) {
            String substate;
            String state;
            Segment xliffSegment = (Segment)xliffPart;
            net.sf.okapi.common.resource.Segment okapiSegment = (net.sf.okapi.common.resource.Segment)okapiSourcePart;
            String canResegment = PropertiesMapper.getProperty("canResegment", okapiSegment);
            if (canResegment != null) {
                xliffSegment.setCanResegment(PropertiesMapper.stringToBoolean(canResegment));
            }
            if ((state = PropertiesMapper.getProperty("state", okapiSegment)) != null) {
                xliffSegment.setState(PropertiesMapper.stringToTargetState(state));
            }
            if ((substate = PropertiesMapper.getProperty("subState", okapiSegment)) != null) {
                xliffSegment.setSubState(substate);
            }
        }
    }

    public static void setCodeProperties(Code okapiCode, CTag xliff2Ctag) {
        xliff2Ctag.setCanCopy(okapiCode.isCloneable());
        xliff2Ctag.setCanDelete(okapiCode.isDeleteable());
        xliff2Ctag.setData(okapiCode.getData());
        xliff2Ctag.setDisp(okapiCode.getDisplayText());
        if (okapiCode.getType() != null && !okapiCode.getType().equals("null")) {
            try {
                xliff2Ctag.setType(okapiCode.getType());
            }
            catch (InvalidParameterException e) {
                LoggerFactory.getLogger(PropertiesMapper.class).debug("Could net set CTag type of {}: {}", (Object)xliff2Ctag, (Object)e.getMessage());
            }
        }
        if (okapiCode.hasAnnotation("canCopy")) {
            xliff2Ctag.setCanCopy(PropertiesMapper.stringToBoolean(okapiCode.getAnnotation("canCopy").getData()));
        }
        if (okapiCode.hasAnnotation("canDelete")) {
            xliff2Ctag.setCanDelete(PropertiesMapper.stringToBoolean(okapiCode.getAnnotation("canDelete").getData()));
        }
        if (okapiCode.hasAnnotation("canReorder")) {
            xliff2Ctag.setCanReorder(CanReorder.valueOf(okapiCode.getAnnotation("canReorder").getData().toUpperCase()));
        }
        if (okapiCode.hasAnnotation("canOverlap")) {
            xliff2Ctag.setCanOverlap(PropertiesMapper.stringToBoolean(okapiCode.getAnnotation("canOverlap").getData()));
        }
        if (okapiCode.hasAnnotation("subFlows")) {
            xliff2Ctag.setSubFlows(okapiCode.getAnnotation("subFlows").getData());
        }
        if (okapiCode.hasAnnotation("subType")) {
            xliff2Ctag.setSubType(okapiCode.getAnnotation("subType").getData());
        }
        if (okapiCode.hasAnnotation("disp")) {
            xliff2Ctag.setDisp(okapiCode.getAnnotation("disp").getData());
        }
        if (okapiCode.hasAnnotation("dir")) {
            xliff2Ctag.setDir(PropertiesMapper.stringToDirection(okapiCode.getAnnotation("dir").getData()));
        }
        if (okapiCode.hasAnnotation("dataDir")) {
            xliff2Ctag.setDataDir(PropertiesMapper.stringToDirection(okapiCode.getAnnotation("dataDir").getData()));
        }
        if (okapiCode.hasAnnotation("dataRef")) {
            xliff2Ctag.setDataRef(okapiCode.getAnnotation("dataRef").getData());
        }
        if (okapiCode.hasAnnotation("equiv")) {
            xliff2Ctag.setEquiv(okapiCode.getAnnotation("equiv").getData());
        }
        PropertiesMapper.setExtendedAttributes(okapiCode, (IWithExtAttributes)xliff2Ctag);
    }

    public static void setCodeProperties(CTag xliff2Ctag, Code okapiCode) {
        String id = xliff2Ctag.getId();
        int okapiId = id.hashCode();
        okapiCode.setId(okapiId);
        okapiCode.setDeleteable(xliff2Ctag.getCanDelete());
        okapiCode.setCloneable(xliff2Ctag.getCanCopy());
        okapiCode.setData(xliff2Ctag.getData());
        okapiCode.setDisplayText(xliff2Ctag.getDisp());
        okapiCode.setOriginalId(xliff2Ctag.getId());
        okapiCode.setTagType(PropertiesMapper.convertTagType(xliff2Ctag.getTagType()));
        if (xliff2Ctag.getType() != null) {
            okapiCode.setType(xliff2Ctag.getType());
        }
        okapiCode.setAnnotation("canDelete", new InlineAnnotation(PropertiesMapper.booleanToString(xliff2Ctag.getCanDelete())));
        okapiCode.setAnnotation("canCopy", new InlineAnnotation(PropertiesMapper.booleanToString(xliff2Ctag.getCanCopy())));
        okapiCode.setAnnotation("canOverlap", new InlineAnnotation(PropertiesMapper.booleanToString(xliff2Ctag.getCanOverlap())));
        if (xliff2Ctag.getCanReorder() != null) {
            okapiCode.setAnnotation("canReorder", new InlineAnnotation(xliff2Ctag.getCanReorder().toString()));
        }
        if (xliff2Ctag.getSubType() != null) {
            okapiCode.setAnnotation("subType", new InlineAnnotation(xliff2Ctag.getSubType()));
        }
        if (xliff2Ctag.getSubFlows() != null) {
            okapiCode.setAnnotation("subFlows", new InlineAnnotation(xliff2Ctag.getSubFlows()));
        }
        if (xliff2Ctag.getDisp() != null) {
            okapiCode.setAnnotation("disp", new InlineAnnotation(xliff2Ctag.getDisp()));
        }
        if (xliff2Ctag.getDir() != null) {
            okapiCode.setAnnotation("dir", new InlineAnnotation(PropertiesMapper.directionToString(xliff2Ctag.getDir())));
        }
        if (xliff2Ctag.getDataDir() != null) {
            okapiCode.setAnnotation("dataDir", new InlineAnnotation(PropertiesMapper.directionToString(xliff2Ctag.getDataDir())));
        }
        if (xliff2Ctag.getDataRef() != null) {
            okapiCode.setAnnotation("dataRef", new InlineAnnotation(xliff2Ctag.getDataRef()));
        }
        if (xliff2Ctag.getEquiv() != null) {
            okapiCode.setAnnotation("equiv", new InlineAnnotation(xliff2Ctag.getEquiv()));
        }
        PropertiesMapper.setExtendedAttributes((IWithExtAttributes)xliff2Ctag, okapiCode);
    }

    private static void setExtendedAttributes(IWithExtAttributes xliffElement, Code code) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        Set<String> namespaces = extAttributes.getNamespaces();
        namespaces.forEach(namespaceURI -> {
            String propertyName = "extendedNamespace." + namespaceURI;
            String value = extAttributes.getNamespacePrefix((String)namespaceURI);
            code.setAnnotation(propertyName, new InlineAnnotation(value));
        });
        extAttributes.forEach(extAttribute -> {
            String propertyName = "extendedAttribute." + extAttribute.getPrefix() + "==" + extAttribute.getQName();
            String value = extAttribute.getValue();
            code.setAnnotation(propertyName, new InlineAnnotation(value));
        });
    }

    private static void setExtendedAttributes(Code code, IWithExtAttributes xliffElement) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        code.getAnnotationsTypes().stream().filter(p -> p.startsWith("extendedNamespace.")).forEach(annotationName -> {
            String namespaceURI = annotationName.replace("extendedNamespace.", "");
            String prefix = code.getAnnotation((String)annotationName).getData();
            extAttributes.setNamespace(prefix, namespaceURI);
        });
        code.getAnnotationsTypes().stream().filter(p -> p.startsWith("extendedAttribute.")).forEach(annotationName -> {
            Matcher matcher = EXTENDED_ATTRIBUTE_KEY_PATTERN.matcher((CharSequence)annotationName);
            boolean found = matcher.find();
            if (found) {
                String namespaceURI = matcher.group(2);
                String localeName = matcher.group(3);
                String value = code.getAnnotation((String)annotationName).getData();
                extAttributes.setAttribute(namespaceURI, localeName, value);
            } else {
                LoggerFactory.getLogger(PropertiesMapper.class).warn("Could not find extended attribute information from {}", annotationName);
            }
        });
    }

    private static void setExtendedAttributes(IWithExtAttributes xliffElement, IWithProperties okapiProperties) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        Set<String> namespaces = extAttributes.getNamespaces();
        namespaces.forEach(namespaceURI -> {
            String propertyName = "extendedNamespace." + namespaceURI;
            String value = extAttributes.getNamespacePrefix((String)namespaceURI);
            PropertiesMapper.setProperty(propertyName, value, okapiProperties);
        });
        extAttributes.forEach(extAttribute -> {
            String propertyName = "extendedAttribute." + extAttribute.getPrefix() + "==" + extAttribute.getQName();
            String value = extAttribute.getValue();
            PropertiesMapper.setProperty(propertyName, value, okapiProperties);
        });
    }

    private static void setExtendedAttributes(IWithProperties okapiProperties, IWithExtAttributes xliffElement) {
        ExtAttributes extAttributes = xliffElement.getExtAttributes();
        okapiProperties.getPropertyNames().stream().filter(p -> p.startsWith("extendedNamespace.")).forEach(propertyName -> {
            String namespaceURI = propertyName.replace("extendedNamespace.", "");
            String prefix = PropertiesMapper.getProperty(propertyName, okapiProperties);
            extAttributes.setNamespace(prefix, namespaceURI);
        });
        okapiProperties.getPropertyNames().stream().filter(p -> p.startsWith("extendedAttribute.")).forEach(propertyName -> {
            Matcher matcher = EXTENDED_ATTRIBUTE_KEY_PATTERN.matcher((CharSequence)propertyName);
            boolean found = matcher.find();
            if (found) {
                String namespaceURI = matcher.group(2);
                String localeName = matcher.group(3);
                String value = PropertiesMapper.getProperty(propertyName, okapiProperties);
                extAttributes.setAttribute(namespaceURI, localeName, value);
            } else {
                LoggerFactory.getLogger(PropertiesMapper.class).warn("Could not find extended attribute information from {}", propertyName);
            }
        });
    }

    private static String getProperty(String key, IWithProperties eventWithProperties) {
        Property property = eventWithProperties.getProperty(key);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    private static void setProperty(String key, String value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, value, true));
    }

    private static void setProperty(String key, boolean value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.booleanToString(value), true));
    }

    private static void setProperty(String key, Directionality value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.directionToString(value), true));
    }

    private static void setProperty(String key, TargetState value, IWithProperties eventWithProperties) {
        eventWithProperties.setProperty(new Property(key, PropertiesMapper.targetStateToString(value), true));
    }

    private static boolean stringToBoolean(String value) {
        return "yes".equals(value);
    }

    private static String booleanToString(boolean value) {
        return value ? "yes" : "no";
    }

    private static Directionality stringToDirection(String value) {
        if (value == null) {
            return Directionality.AUTO;
        }
        if ("NOT ALLOWED".equals(value)) {
            return Directionality.INHERITED;
        }
        return Directionality.valueOf(value.toUpperCase());
    }

    private static String directionToString(Directionality value) {
        return value.toString();
    }

    private static TargetState stringToTargetState(String value) {
        return TargetState.valueOf(value.toUpperCase());
    }

    private static String targetStateToString(TargetState value) {
        return value.toString();
    }

    private static TextFragment.TagType convertTagType(TagType tagType) {
        switch (tagType) {
            case CLOSING: {
                return TextFragment.TagType.CLOSING;
            }
            case OPENING: {
                return TextFragment.TagType.OPENING;
            }
            case STANDALONE: {
                return TextFragment.TagType.PLACEHOLDER;
            }
        }
        LoggerFactory.getLogger(PropertiesMapper.class).warn("TagType {} unrecognized. Treating it as {}.", (Object)tagType, (Object)TagType.STANDALONE);
        return TextFragment.TagType.PLACEHOLDER;
    }
}

