/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.xliff2.MetadataSkeleton;
import net.sf.okapi.filters.xliff2.XLIFF2FilterWriter;
import net.sf.okapi.filters.xliff2.Xliff2Skeleton;
import net.sf.okapi.filters.xliff2.util.NotesMapper;
import net.sf.okapi.filters.xliff2.util.PropertiesMapper;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkpToX2Converter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    PropertiesMapper propertiesMapper = new PropertiesMapper();
    private static final Map<TextFragment.TagType, TagType> codeTagTypeMap = new HashMap<TextFragment.TagType, TagType>();
    private static final String ID = "id";

    public List<Event> handleEvent(net.sf.okapi.common.Event okapiEvent, XLIFF2FilterWriter xliff2FilterWriter) {
        EventType eventType = okapiEvent.getEventType();
        switch (eventType) {
            case START_DOCUMENT: {
                return this.startDocument(okapiEvent.getStartDocument(), xliff2FilterWriter);
            }
            case END_DOCUMENT: {
                return this.endDocument(okapiEvent.getEnding());
            }
            case START_SUBDOCUMENT: {
                return this.startSubDocument(okapiEvent.getStartSubDocument());
            }
            case END_SUBDOCUMENT: {
                return this.endSubDocument();
            }
            case START_GROUP: {
                return this.startGroup(okapiEvent.getStartGroup());
            }
            case END_GROUP: {
                return this.endGroup(okapiEvent.getEndGroup());
            }
            case TEXT_UNIT: {
                return this.textUnit(okapiEvent.getTextUnit(), xliff2FilterWriter.getTargetLocale());
            }
            case DOCUMENT_PART: {
                return this.documentPart(okapiEvent.getDocumentPart());
            }
            case CUSTOM: {
                return Collections.emptyList();
            }
        }
        throw new OkapiException("Event " + (Object)((Object)okapiEvent.getEventType()) + " is not implemented in XLIFF 2.0 Filter Writer");
    }

    private List<Event> documentPart(DocumentPart documentPart) {
        if (documentPart.getSkeleton() != null) {
            if (documentPart.getSkeleton() instanceof MetadataSkeleton) {
                MidFileData xliffMidFileData = new MidFileData();
                xliffMidFileData.setMetadata(((MetadataSkeleton)documentPart.getSkeleton()).getMetaData());
                Event event = new Event(net.sf.okapi.lib.xliff2.reader.EventType.MID_FILE, null, xliffMidFileData);
                NotesMapper.setNotes((IWithAnnotations)documentPart, xliffMidFileData);
                return Collections.singletonList(event);
            }
            if (documentPart.getSkeleton() instanceof Xliff2Skeleton) {
                Event event = new Event(net.sf.okapi.lib.xliff2.reader.EventType.SKELETON, null, ((Xliff2Skeleton)documentPart.getSkeleton()).getXliff2Skeleton());
                return Collections.singletonList(event);
            }
        }
        MidFileData xliffMidFileData = new MidFileData();
        Event event = new Event(net.sf.okapi.lib.xliff2.reader.EventType.MID_FILE, null, xliffMidFileData);
        NotesMapper.setNotes((IWithAnnotations)documentPart, xliffMidFileData);
        return Collections.singletonList(event);
    }

    private List<Event> textUnit(ITextUnit okapiTextUnit, LocaleId targetLocale) {
        TextContainer okapiTargets;
        HashSet<String> sourceCodeIds = new HashSet<String>();
        HashSet<String> targetCodeIds = new HashSet<String>();
        Unit xliffTextUnit = new Unit(okapiTextUnit.getId());
        Event event = new Event(net.sf.okapi.lib.xliff2.reader.EventType.TEXT_UNIT, null, xliffTextUnit);
        Set<LocaleId> availableTargetLocales = okapiTextUnit.getTargetLocales();
        if (okapiTextUnit.getSkeleton() != null) {
            xliffTextUnit.setMetadata(((MetadataSkeleton)okapiTextUnit.getSkeleton()).getMetaData());
        }
        PropertiesMapper.setTextUnitProperties(okapiTextUnit, xliffTextUnit);
        NotesMapper.setNotes((IWithAnnotations)okapiTextUnit, xliffTextUnit);
        TextContainer okapiSources = okapiTextUnit.getSource();
        if (targetLocale != null && availableTargetLocales.contains(targetLocale)) {
            okapiTargets = okapiTextUnit.getTarget(targetLocale);
            if (okapiTargets.count() != 0 && okapiSources.count() != okapiTargets.count()) {
                this.logger.warn("Target count doesn't match source count. It's very likely there will be some misalignment.");
            }
        } else {
            okapiTargets = null;
        }
        for (int partIndex = 0; partIndex < okapiSources.count(); ++partIndex) {
            Part xliffPart;
            TextPart okapiSourcePart = okapiSources.get(partIndex);
            if (okapiSourcePart.isSegment()) {
                xliffPart = xliffTextUnit.appendSegment();
                if (xliffPart.getSource() == null) {
                    xliffPart.setSource("");
                }
            } else {
                xliffPart = xliffTextUnit.appendIgnorable();
            }
            xliffPart.setId(okapiSourcePart.originalId);
            this.copyOver(okapiSourcePart.getContent(), xliffPart.getSource(), sourceCodeIds);
            TextPart okapiTargetPart = null;
            if (okapiTargets != null && partIndex < okapiTargets.count() && (okapiTargetPart = okapiTargets.get(partIndex)) != null) {
                Part xliffTargetPart = xliffTextUnit.getPart(partIndex);
                if (xliffTargetPart.getTarget() == null) {
                    xliffTargetPart.setTarget("");
                }
                xliffPart.setId(okapiTargetPart.originalId);
                this.copyOver(okapiTargetPart.getContent(), xliffTargetPart.getTarget(), targetCodeIds);
            }
            PropertiesMapper.setPartProperties(okapiSourcePart, xliffPart, okapiTextUnit);
        }
        return Collections.singletonList(event);
    }

    private List<Event> endGroup(Ending endGroup) {
        Event event = new Event(net.sf.okapi.lib.xliff2.reader.EventType.END_GROUP, null);
        return Collections.singletonList(event);
    }

    private List<Event> startGroup(StartGroup startGroup) {
        Property propertyId = startGroup.getProperty(ID);
        String propertyIdString = propertyId == null ? null : propertyId.getValue();
        StartGroupData startGroupData = new StartGroupData(propertyIdString);
        Event event = new Event(net.sf.okapi.lib.xliff2.reader.EventType.START_GROUP, null, startGroupData);
        if (startGroup.getSkeleton() != null) {
            startGroupData.setMetadata(((MetadataSkeleton)startGroup.getSkeleton()).getMetaData());
        }
        PropertiesMapper.setGroupProperties(startGroup, startGroupData);
        NotesMapper.setNotes((IWithAnnotations)startGroup, startGroupData);
        return Collections.singletonList(event);
    }

    private List<Event> startDocument(StartDocument okapiEvent, XLIFF2FilterWriter xliff2FilterWriter) {
        Event startDocumentEvent = new Event(net.sf.okapi.lib.xliff2.reader.EventType.START_DOCUMENT, null);
        LocaleId locale = okapiEvent.getLocale();
        Property xliffVersionProperty = okapiEvent.getProperty("version");
        String xliffVersion = xliffVersionProperty != null ? xliffVersionProperty.getValue() : "2.0";
        StartXliffData startXliffData = new StartXliffData(xliffVersion);
        Event startXliffEvent = new Event(net.sf.okapi.lib.xliff2.reader.EventType.START_XLIFF, null, startXliffData);
        xliff2FilterWriter.initializeWriter(locale);
        PropertiesMapper.setStartXliffProperties(okapiEvent, startXliffData);
        return Arrays.asList(startDocumentEvent, startXliffEvent);
    }

    private List<Event> endDocument(Ending okapiEvent) {
        Event endXliffEvent = new Event(net.sf.okapi.lib.xliff2.reader.EventType.END_XLIFF, null);
        Event endDocumentEvent = new Event(net.sf.okapi.lib.xliff2.reader.EventType.END_DOCUMENT, null);
        return Arrays.asList(endXliffEvent, endDocumentEvent);
    }

    private List<Event> startSubDocument(StartSubDocument okapiEvent) {
        ArrayList<Event> events = new ArrayList<Event>();
        StartFileData startFileData = new StartFileData(okapiEvent.getId());
        startFileData.setOriginal(okapiEvent.getName());
        PropertiesMapper.setStartFileProperties(okapiEvent, startFileData);
        NotesMapper.setNotes((IWithAnnotations)okapiEvent, startFileData);
        Event startFileEvent = new Event(net.sf.okapi.lib.xliff2.reader.EventType.START_FILE, null, startFileData);
        events.add(startFileEvent);
        return events;
    }

    private List<Event> endSubDocument() {
        Event event = new Event(net.sf.okapi.lib.xliff2.reader.EventType.END_FILE, null);
        return Collections.singletonList(event);
    }

    private void copyOver(TextFragment source, Fragment out, Set<String> existingCodeIds) {
        String codedText = source.getCodedText();
        int nextCodeIndex = -1;
        int nextCodePosition = -1;
        if (source.hasCode()) {
            nextCodeIndex = 0;
            nextCodePosition = source.getCodePosition(nextCodeIndex);
        }
        for (int i = 0; i < codedText.length(); ++i) {
            char c = codedText.charAt(i);
            if (nextCodePosition == i) {
                char codePosition = codedText.charAt(i + 1);
                Code okapiCode = source.getCode(codePosition);
                TagType tagType = codeTagTypeMap.get((Object)okapiCode.getTagType());
                String id = okapiCode.getOriginalId();
                if (id == null) {
                    id = String.valueOf(okapiCode.getId());
                    this.logger.warn("Code id was null in segment: {}. Using Okapi code internal id instead: {}", (Object)source, (Object)id);
                }
                CTag xliff2Ctag = new CTag(tagType, id, okapiCode.getData());
                if (tagType.equals((Object)TagType.CLOSING) || tagType.equals((Object)TagType.STANDALONE)) {
                    if (existingCodeIds.contains(id)) {
                        throw new OkapiMergeException("Tried writing placeholder to XLIFF 2 with the same ID as another placeholder in the same text unit. Previous ID: " + okapiCode.getId() + " | XLIFF 2 ID: " + id + " | Placeholder: " + okapiCode);
                    }
                    existingCodeIds.add(id);
                }
                PropertiesMapper.setCodeProperties(okapiCode, xliff2Ctag);
                out.append(xliff2Ctag);
                nextCodePosition = source.getCodePosition(++nextCodeIndex);
                ++i;
                continue;
            }
            out.append(c);
        }
    }

    static {
        codeTagTypeMap.put(TextFragment.TagType.OPENING, TagType.OPENING);
        codeTagTypeMap.put(TextFragment.TagType.CLOSING, TagType.CLOSING);
        codeTagTypeMap.put(TextFragment.TagType.PLACEHOLDER, TagType.STANDALONE);
    }
}

