/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Nameable;

final class TableMarkup
implements Markup {
    private final Markup markup;

    TableMarkup(Markup markup) {
        this.markup = markup;
    }

    @Override
    public void addComponent(MarkupComponent component) {
        this.markup.addComponent(component);
    }

    @Override
    public void addComponents(List<MarkupComponent> components) {
        this.markup.addComponents(components);
    }

    @Override
    public void addMarkup(Markup markup) {
        this.markup.addMarkup(markup);
    }

    @Override
    public List<MarkupComponent> components() {
        return this.markup.components();
    }

    @Override
    public Nameable nameableComponent() {
        return this.markup.nameableComponent();
    }

    @Override
    public void apply(FontMappings fontMappings) {
        this.markup.apply(fontMappings);
    }

    @Override
    public List<XMLEvent> getEvents() {
        return this.markup.getEvents();
    }

    boolean empty() {
        return this.markup.components().isEmpty();
    }

    Iterator<MarkupComponent> componentsIteratorAtLastWith(String name) {
        if (this.empty()) {
            throw new UnsupportedOperationException("The table markup components are empty");
        }
        ListIterator<MarkupComponent> iterator = this.markup.components().listIterator(this.markup.components().size() - 1);
        while (iterator.hasPrevious()) {
            MarkupComponent mc = iterator.previous();
            if (!(mc instanceof Nameable) || !((Nameable)((Object)mc)).getName().getLocalPart().equals(name)) continue;
            return iterator;
        }
        throw new IllegalArgumentException(String.format("The requested table markup component with '%s' name could not be found", name));
    }

    void removeComponents() {
        this.markup.components().clear();
    }

    void removeComponentsFromLastWith(String name) {
        if (this.empty()) {
            return;
        }
        this.removeComponentsWith(this.componentsIteratorAtLastWith(name));
    }

    void removeComponentsWith(Iterator<MarkupComponent> iterator) {
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    boolean lastComponentGeneral() {
        if (this.empty()) {
            return false;
        }
        return this.markup.components().get(this.markup.components().size() - 1) instanceof MarkupComponent.General;
    }

    void addToLastComponent(XMLEvent event) {
        this.markup.components().get(this.markup.components().size() - 1).getEvents().add(event);
    }
}

