/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.layerprovider.ILayerProvider;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.EndSubfilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockPropertiesClarifier;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.BlockTextUnitWriter;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ClarificationParameters;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupClarifier;
import net.sf.okapi.filters.openxml.MarkupComponentClarifier;
import net.sf.okapi.filters.openxml.MarkupSkeleton;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.RunPropertiesClarifier;
import net.sf.okapi.filters.openxml.StylesClarifier;
import net.sf.okapi.filters.openxml.TextUnitProperties;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class StyledTextSkeletonWriter
implements ISkeletonWriter {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String EMPTY_STRING = "";
    private final String partName;
    private LocaleId targetLocale;
    private final ConditionalParameters cparams;
    private final XMLEventFactory eventFactory;
    private final FontMappings applicableFontMappings;
    private final GenericSkeletonWriter genericSkeletonWriter;
    private IdGenerator nestedBlockIds = new IdGenerator(null);
    private Map<String, String> processedReferents = new HashMap<String, String>();
    private Deque<Referring> referrings = new ArrayDeque<Referring>();

    StyledTextSkeletonWriter(String partName, LocaleId targetLocale, ConditionalParameters cparams, XMLEventFactory eventFactory, FontMappings applicableFontMappings, GenericSkeletonWriter genericSkeletonWriter) {
        this.partName = partName;
        this.targetLocale = targetLocale;
        this.cparams = cparams;
        this.eventFactory = eventFactory;
        this.applicableFontMappings = applicableFontMappings;
        this.genericSkeletonWriter = genericSkeletonWriter;
    }

    @Override
    public void close() {
    }

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, ILayerProvider layer, EncoderManager encoderManager, StartDocument resource) {
        this.targetLocale = outputLocale;
        this.genericSkeletonWriter.setOutputLoc(outputLocale);
        return XML_HEADER;
    }

    @Override
    public String processEndDocument(Ending resource) {
        return EMPTY_STRING;
    }

    @Override
    public String processStartSubDocument(StartSubDocument resource) {
        return XML_HEADER;
    }

    @Override
    public String processEndSubDocument(Ending resource) {
        return EMPTY_STRING;
    }

    @Override
    public String processStartGroup(StartGroup resource) {
        return EMPTY_STRING;
    }

    @Override
    public String processEndGroup(Ending resource) {
        return EMPTY_STRING;
    }

    @Override
    public String processTextUnit(ITextUnit tu) {
        String serialized;
        if (!EMPTY_STRING.equals(this.cparams.getSubfilter()) && null == tu.getSkeleton() || tu.getSkeleton() instanceof GenericSkeleton) {
            return this.genericSkeletonWriter.processTextUnit(tu);
        }
        TextContainer target = this.getTargetForOutput(tu);
        List<Chunk> chunks = null;
        XMLEventSerializer xmlWriter = new XMLEventSerializer();
        if (tu.getSkeleton() != null) {
            if (!(tu.getSkeleton() instanceof BlockSkeleton)) {
                throw new IllegalArgumentException("TextUnit " + tu.getId() + " has no associated block content");
            }
            BlockSkeleton skel = (BlockSkeleton)tu.getSkeleton();
            Block block = skel.block();
            chunks = block.getChunks();
            ((Markup)((Object)chunks.get(0))).apply(this.applicableFontMappings);
            ((Markup)((Object)chunks.get(chunks.size() - 1))).apply(this.applicableFontMappings);
            Nameable nameableMarkupComponent = ((Markup)((Object)chunks.get(0))).nameableComponent();
            CreationalParameters creationalParameters = new CreationalParameters(this.eventFactory, nameableMarkupComponent.getName().getPrefix(), nameableMarkupComponent.getName().getNamespaceURI());
            ClarificationParameters clarificationParameters = new ClarificationParameters(LocaleId.isBidirectional(this.targetLocale), LocaleId.hasCharactersAsNumeralSeparators(this.targetLocale), this.targetLocale.toString());
            BlockPropertiesClarifier.TablePropertiesClarifier tablePropertiesClarifier = new BlockPropertiesClarifier.TablePropertiesClarifier(this.cparams, creationalParameters, clarificationParameters);
            BlockPropertiesClarifier.ParagraphPropertiesClarifier paragraphPropertiesClarifier = new BlockPropertiesClarifier.ParagraphPropertiesClarifier(this.cparams, creationalParameters, clarificationParameters);
            RunPropertiesClarifier runPropertiesClarifier = new RunPropertiesClarifier(creationalParameters, clarificationParameters);
            MarkupClarifier markupClarifier = new MarkupClarifier(new MarkupComponentClarifier.SheetViewClarifier(this.cparams, creationalParameters, clarificationParameters), new MarkupComponentClarifier.AlignmentClarifier(this.cparams, creationalParameters, clarificationParameters), new MarkupComponentClarifier.PresentationClarifier(this.cparams, creationalParameters, clarificationParameters), tablePropertiesClarifier, new BlockPropertiesClarifier.TextBodyPropertiesClarifier(this.cparams, creationalParameters, clarificationParameters), paragraphPropertiesClarifier, new StylesClarifier.Word(tablePropertiesClarifier, paragraphPropertiesClarifier, runPropertiesClarifier));
            markupClarifier.clarify((Markup)((Object)chunks.get(0)));
            xmlWriter.add(chunks.get(0));
            new BlockTextUnitWriter(this.cparams, this.eventFactory, skel, xmlWriter, runPropertiesClarifier).write(target);
            xmlWriter.add(chunks.get(chunks.size() - 1));
            serialized = xmlWriter.toString();
        } else {
            serialized = xmlWriter.getAttributeEncoder().encode(target.toString(), EncoderContext.INLINE);
        }
        return this.processReferences(tu, serialized);
    }

    private String processReferences(ITextUnit tu, String serialized) {
        String output;
        if (tu.isReferent()) {
            if (TextUnitProperties.integer(tu, "references") != 0) {
                this.referrings.push(new Referring(serialized, TextUnitProperties.integer(tu, "references")));
                output = EMPTY_STRING;
            } else {
                this.processedReferents.put(this.nestedBlockIds.createId(), serialized);
                this.referrings.peek().foundReferents++;
                if (this.referrings.peek().isLastFoundReferent()) {
                    String resolved = this.resolveReferences(this.referrings.pop().serialized);
                    output = !this.referrings.isEmpty() ? this.processReferences(tu, resolved) : resolved;
                } else {
                    output = EMPTY_STRING;
                }
            }
        } else if (TextUnitProperties.integer(tu, "references") == 0) {
            output = serialized;
        } else {
            this.referrings.push(new Referring(serialized, TextUnitProperties.integer(tu, "references")));
            output = EMPTY_STRING;
        }
        return output;
    }

    private String resolveReferences(String original) {
        StringBuilder sb = new StringBuilder(original);
        Object[] markerInfo = TextFragment.getRefMarker(sb);
        while (markerInfo != null) {
            String processedReferent = this.processedReferents.get(markerInfo[0]);
            sb.replace((Integer)markerInfo[1], (Integer)markerInfo[2], processedReferent);
            markerInfo = TextFragment.getRefMarker(sb);
        }
        return sb.toString();
    }

    private TextContainer getTargetForOutput(ITextUnit tu) {
        if (this.targetLocale == null) {
            return tu.getSource();
        }
        TextContainer trgCont = tu.getTarget(this.targetLocale);
        if (trgCont == null || trgCont.isEmpty()) {
            return tu.getSource();
        }
        return trgCont;
    }

    @Override
    public String processDocumentPart(DocumentPart documentPart) {
        if (documentPart.getSkeleton() instanceof GenericSkeleton) {
            return this.genericSkeletonWriter.processDocumentPart(documentPart);
        }
        MarkupSkeleton markupSkeleton = (MarkupSkeleton)documentPart.getSkeleton();
        Markup markup = markupSkeleton.getMarkup();
        markup.apply(this.applicableFontMappings);
        Nameable nameableMarkupComponent = markup.nameableComponent();
        if (null != nameableMarkupComponent) {
            CreationalParameters creationalParameters = new CreationalParameters(this.eventFactory, nameableMarkupComponent.getName().getPrefix(), nameableMarkupComponent.getName().getNamespaceURI());
            ClarificationParameters clarificationParameters = new ClarificationParameters(LocaleId.isBidirectional(this.targetLocale), LocaleId.hasCharactersAsNumeralSeparators(this.targetLocale), this.targetLocale.toString());
            BlockPropertiesClarifier.TablePropertiesClarifier tablePropertiesClarifier = new BlockPropertiesClarifier.TablePropertiesClarifier(this.cparams, creationalParameters, clarificationParameters);
            BlockPropertiesClarifier.ParagraphPropertiesClarifier paragraphPropertiesClarifier = new BlockPropertiesClarifier.ParagraphPropertiesClarifier(this.cparams, creationalParameters, clarificationParameters);
            MarkupClarifier markupClarifier = new MarkupClarifier(new MarkupComponentClarifier.SheetViewClarifier(this.cparams, creationalParameters, clarificationParameters), new MarkupComponentClarifier.AlignmentClarifier(this.cparams, creationalParameters, clarificationParameters), new MarkupComponentClarifier.PresentationClarifier(this.cparams, creationalParameters, clarificationParameters), tablePropertiesClarifier, new BlockPropertiesClarifier.TextBodyPropertiesClarifier(this.cparams, creationalParameters, clarificationParameters), paragraphPropertiesClarifier, new StylesClarifier.Word(tablePropertiesClarifier, paragraphPropertiesClarifier, new RunPropertiesClarifier(creationalParameters, clarificationParameters)));
            markupClarifier.clarify(markup);
        }
        return XMLEventSerializer.serialize(markup);
    }

    @Override
    public String processStartSubfilter(StartSubfilter resource) {
        return this.genericSkeletonWriter.processStartSubfilter(resource);
    }

    @Override
    public String processEndSubfilter(EndSubfilter resource) {
        return this.genericSkeletonWriter.processEndSubfilter(resource);
    }

    private static final class Referring {
        private final String serialized;
        private final int references;
        private int foundReferents;

        Referring(String serialized, int references) {
            this.serialized = serialized;
            this.references = references;
        }

        boolean isLastFoundReferent() {
            return this.references == this.foundReferents;
        }
    }
}

