/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.GraphicFrameFragments;
import net.sf.okapi.filters.openxml.Placeholder;
import net.sf.okapi.filters.openxml.ShapeFragments;
import net.sf.okapi.filters.openxml.StyleDefinitions;

interface ShapeTreeFragments {
    public static final String SP_TREE = "spTree";

    public StyleDefinitions listStyleFor(String var1);

    public StyleDefinitions listStyleFor(Placeholder var1);

    public StyleDefinitions listStyleFor(String var1, int var2);

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public static final class Default
    implements ShapeTreeFragments {
        private final StartElement startElement;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final Map<String, ShapeFragments> shapeFragmentsById;
        private final Map<Placeholder, ShapeFragments> shapeFragmentsByPlaceholder;
        private final Map<String, GraphicFrameFragments> graphicFrameFragmentsById;

        Default(StartElement startElement, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory) {
            this(startElement, conditionalParameters, eventFactory, new HashMap<String, ShapeFragments>(), new HashMap<Placeholder, ShapeFragments>(), new HashMap<String, GraphicFrameFragments>());
        }

        Default(StartElement startElement, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, Map<String, ShapeFragments> shapeFragmentsById, Map<Placeholder, ShapeFragments> shapeFragmentsByPlaceholder, Map<String, GraphicFrameFragments> graphicFrameFragmentsById) {
            this.startElement = startElement;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.shapeFragmentsById = shapeFragmentsById;
            this.shapeFragmentsByPlaceholder = shapeFragmentsByPlaceholder;
            this.graphicFrameFragmentsById = graphicFrameFragmentsById;
        }

        @Override
        public StyleDefinitions listStyleFor(String shapeId) {
            if (!this.shapeFragmentsById.containsKey(shapeId)) {
                throw new IllegalArgumentException("The provided ID is not available");
            }
            return this.shapeFragmentsById.get(shapeId).listStyle();
        }

        @Override
        public StyleDefinitions listStyleFor(Placeholder placeholder) {
            return this.shapeFragmentsByPlaceholder.containsKey(placeholder) ? this.shapeFragmentsByPlaceholder.get(placeholder).listStyle() : new StyleDefinitions.Empty();
        }

        @Override
        public StyleDefinitions listStyleFor(String graphicFrameId, int tableCellNumber) {
            return this.graphicFrameFragmentsById.containsKey(graphicFrameId) ? this.graphicFrameFragmentsById.get(graphicFrameId).listStyleFor(tableCellNumber) : new StyleDefinitions.Empty();
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            XMLEvent e;
            while (!(!eventReader.hasNext() || (e = eventReader.nextEvent()).isEndElement() && e.asEndElement().getName().equals(this.startElement.getName()))) {
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if ("sp".equals(se.getName().getLocalPart())) {
                    ShapeFragments.Default shapeFragments = new ShapeFragments.Default(se, this.conditionalParameters, this.eventFactory);
                    shapeFragments.readWith(eventReader);
                    this.shapeFragmentsById.put(shapeFragments.id(), shapeFragments);
                    if ("".equals(shapeFragments.placeholder().type()) || "".equals(shapeFragments.placeholder().index())) continue;
                    this.shapeFragmentsByPlaceholder.put(shapeFragments.placeholder(), shapeFragments);
                    continue;
                }
                if (!"graphicFrame".equals(se.getName().getLocalPart())) continue;
                GraphicFrameFragments.Default graphicFrameFragments = new GraphicFrameFragments.Default(se, this.conditionalParameters, this.eventFactory);
                graphicFrameFragments.readWith(eventReader);
                this.graphicFrameFragmentsById.put(graphicFrameFragments.id(), graphicFrameFragments);
            }
        }
    }

    public static final class Empty
    implements ShapeTreeFragments {
        @Override
        public StyleDefinitions listStyleFor(String shapeId) {
            return new StyleDefinitions.Empty();
        }

        @Override
        public StyleDefinitions listStyleFor(Placeholder placeholder) {
            return new StyleDefinitions.Empty();
        }

        @Override
        public StyleDefinitions listStyleFor(String graphicFrameId, int tableCellNumber) {
            return new StyleDefinitions.Empty();
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
        }
    }
}

