/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockPropertiesFactory;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class MarkupComponentParser {
    MarkupComponentParser() {
    }

    MarkupComponent parseEmptyElementMarkupComponent(XMLEventReader eventReader, XMLEventFactory eventFactory, StartElement startElement) throws XMLStreamException {
        if (!eventReader.hasNext()) {
            throw new IllegalStateException("Unexpected structure");
        }
        XMLEvent nextEvent = eventReader.nextEvent();
        if (!XMLEventHelpers.isEndElement(nextEvent, startElement)) {
            throw new IllegalStateException("Unexpected structure");
        }
        return MarkupComponentFactory.createEmptyElementMarkupComponent(eventFactory, startElement, nextEvent.asEndElement());
    }

    BlockProperties parseBlockProperties(StartElementContext startElementContext, StrippableAttributes strippableAttributes, SkippableElements skippableElements) throws XMLStreamException {
        ArrayList<BlockProperty> properties = new ArrayList<BlockProperty>();
        while (startElementContext.getEventReader().hasNext()) {
            XMLEvent event = startElementContext.getEventReader().nextEvent();
            if (XMLEventHelpers.isEndElement(event, startElementContext.getStartElement())) {
                return BlockPropertiesFactory.createBlockProperties(startElementContext.getConditionalParameters(), startElementContext.getEventFactory(), startElementContext.getStartElement(), event.asEndElement(), properties);
            }
            if (!event.isStartElement()) continue;
            if (skippableElements.canBeSkipped(event.asStartElement(), startElementContext.getStartElement())) {
                skippableElements.skip(StartElementContextFactory.createStartElementContext(event.asStartElement(), startElementContext));
                continue;
            }
            BlockProperty property = new BlockProperty(MarkupComponentParser.eventsWithSkippedRevisionProperties(StartElementContextFactory.createStartElementContext(event.asStartElement(), startElementContext), skippableElements), startElementContext.getConditionalParameters(), startElementContext.getEventFactory(), strippableAttributes);
            if (MarkupComponentParser.isEmptyBlockRunPropertiesElement(property)) continue;
            properties.add(property);
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private static boolean isEmptyBlockRunPropertiesElement(BlockProperty blockProperty) {
        if (!"rPr".equals(blockProperty.getName().getLocalPart()) && !"defRPr".equals(blockProperty.getName().getLocalPart())) {
            return false;
        }
        if (blockProperty.getEvents().get(0).asStartElement().getAttributes().hasNext()) {
            return false;
        }
        if (2 == blockProperty.getEvents().size()) {
            return true;
        }
        return blockProperty.getEvents().subList(1, blockProperty.getEvents().size() - 1).stream().allMatch(e -> XMLEventHelpers.isWhitespace(e));
    }

    private static List<XMLEvent> eventsWithSkippedRevisionProperties(StartElementContext startElementContext, SkippableElements skippableElements) throws XMLStreamException {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(startElementContext.getStartElement());
        while (startElementContext.getEventReader().hasNext()) {
            XMLEvent event = startElementContext.getEventReader().nextEvent();
            if (event.isStartElement() && skippableElements.canBeSkipped(event.asStartElement(), startElementContext.getStartElement())) {
                skippableElements.skip(StartElementContextFactory.createStartElementContext(event.asStartElement(), startElementContext));
                continue;
            }
            events.add(event);
            if (!XMLEventHelpers.isEndElement(event, startElementContext.getStartElement())) continue;
            return events;
        }
        throw new IllegalStateException("Unexpected structure");
    }

    ParagraphBlockProperties parseParagraphBlockProperties(StartElementContext startElementContext, StrippableAttributes strippableAttributes, SkippableElements skippableElements) throws XMLStreamException {
        return (ParagraphBlockProperties)this.parseBlockProperties(startElementContext, strippableAttributes, skippableElements);
    }
}

