/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

class ContentTypes {
    static final String PART_NAME = "[Content_Types].xml";
    private static final String TYPES = "Types";
    private static final QName PARTNAME_ATTR = new QName("PartName");
    private static final QName CONTENTTYPE_ATTR = new QName("ContentType");
    private static final QName EXTENSION_ATTR = new QName("Extension");
    private final XMLInputFactory factory;
    private QName defaultName;
    private QName overrideName;
    private Map<String, String> defaults = new HashMap<String, String>();
    private Map<String, String> overrides = new HashMap<String, String>();

    ContentTypes(XMLInputFactory factory) {
        this.factory = factory;
    }

    String getContentType(String partName) {
        if (this.overrides.containsKey(partName = this.ensureWellformedPath(partName))) {
            return this.overrides.get(partName);
        }
        String suffix = this.getSuffix(partName);
        if (this.defaults.containsKey(suffix)) {
            return this.defaults.get(suffix);
        }
        return "application/octet-stream";
    }

    void parseFromXML(Reader reader) throws XMLStreamException {
        XMLEventReader eventReader = this.factory.createXMLEventReader(reader);
        while (eventReader.hasNext()) {
            Attribute type;
            XMLEvent e = eventReader.nextEvent();
            if (!e.isStartElement()) continue;
            StartElement el = e.asStartElement();
            if (el.getName().getLocalPart().equals(TYPES)) {
                this.qualifyNames(el);
                continue;
            }
            if (el.getName().equals(this.defaultName)) {
                Attribute ext = el.getAttributeByName(EXTENSION_ATTR);
                type = el.getAttributeByName(CONTENTTYPE_ATTR);
                if (ext == null || type == null) continue;
                this.defaults.put(ext.getValue(), type.getValue());
                continue;
            }
            if (!el.getName().equals(this.overrideName)) continue;
            Attribute part = el.getAttributeByName(PARTNAME_ATTR);
            type = el.getAttributeByName(CONTENTTYPE_ATTR);
            if (part == null || type == null) continue;
            this.overrides.put(this.ensureWellformedPath(part.getValue()), type.getValue());
        }
    }

    private void qualifyNames(StartElement startElement) {
        this.defaultName = new QName(startElement.getName().getNamespaceURI(), "Default", startElement.getName().getPrefix());
        this.overrideName = new QName(startElement.getName().getNamespaceURI(), "Override", startElement.getName().getPrefix());
    }

    private String getSuffix(String partName) {
        String suffix = partName;
        int i = suffix.lastIndexOf(46);
        if (i != -1) {
            suffix = suffix.substring(i + 1);
        }
        return suffix;
    }

    private String ensureWellformedPath(String p) {
        return p.startsWith("/") ? p : "/" + p;
    }

    static class Types {
        private static final String APPLICATION_PREFIX = "application/vnd.";
        private static final String DOCUMENT_PREFIX = "application/vnd.openxmlformats-officedocument.";

        Types() {
        }

        static class Visio {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.ms-visio.drawing.main+xml";
            static final String MACRO_ENABLED_MAIN_DOCUMENT_TYPE = "application/vnd.ms-visio.drawing.macroEnabled.main+xml";
            static final String MASTER_TYPE = "application/vnd.ms-visio.master+xml";
            static final String PAGE_TYPE = "application/vnd.ms-visio.page+xml";

            Visio() {
            }
        }

        static class Excel {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
            static final String MACRO_ENABLED_MAIN_DOCUMENT_TYPE = "application/vnd.ms-excel.sheet.macroEnabled.main+xml";
            static final String TEMPLATE_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml";
            static final String MACRO_ENABLED_TEMPLATE_DOCUMENT_TYPE = "application/vnd.ms-excel.template.macroEnabled.main+xml";
            static final String SHARED_STRINGS_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
            static final String WORKSHEET_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml";
            static final String COMMENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml";
            static final String TABLE_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml";
            static final String STYLES_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml";
            static final String DRAWINGS_TYPE = "application/vnd.openxmlformats-officedocument.drawing+xml";

            Excel() {
            }
        }

        static class Powerpoint {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml";
            static final String MACRO_ENABLED_MAIN_DOCUMENT_TYPE = "application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml";
            static final String SLIDE_SHOW_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml";
            static final String MACRO_ENABLED_SLIDE_SHOW_DOCUMENT_TYPE = "application/vnd.ms-powerpoint.slideshow.macroEnabled.main+xml";
            static final String TEMPLATE_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml";
            static final String MACRO_ENABLED_TEMPLATE_DOCUMENT_TYPE = "application/vnd.ms-powerpoint.template.macroEnabled.main+xml";
            static final String SLIDE_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slide+xml";
            static final String SLIDE_LAYOUT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml";
            static final String SLIDE_MASTER_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml";
            static final String COMMENTS_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.comments+xml";
            static final String NOTES_SLIDE_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml";
            static final String NOTES_MASTER_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml";
            static final String THEME_TYPE = "application/vnd.openxmlformats-officedocument.theme+xml";

            Powerpoint() {
            }
        }

        static class Drawing {
            static final String CHART_TYPE = "application/vnd.openxmlformats-officedocument.drawingml.chart+xml";
            static final String DIAGRAM_TYPE = "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml";

            Drawing() {
            }
        }

        static class Word {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml";
            static final String MACRO_ENABLED_MAIN_DOCUMENT_TYPE = "application/vnd.ms-word.document.macroEnabled.main+xml";
            static final String TEMPLATE_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml";
            static final String MACRO_ENABLED_TEMPLATE_DOCUMENT_TYPE = "application/vnd.ms-word.template.macroEnabledTemplate.main+xml";
            static final String SETTINGS_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml";
            static final String STYLES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml";
            static final String FOOTER_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml";
            static final String ENDNOTES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml";
            static final String HEADER_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml";
            static final String FOOTNOTES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml";
            static final String COMMENTS_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml";
            static final String GLOSSARY_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml";

            Word() {
            }
        }

        static class Common {
            static final String CORE_PROPERTIES_TYPE = "application/vnd.openxmlformats-package.core-properties+xml";
            static final String PACKAGE_RELATIONSHIPS = "application/vnd.openxmlformats-package.relationships+xml";

            Common() {
            }
        }
    }
}

