/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesClarifier;
import net.sf.okapi.filters.openxml.TextUnitWriter;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockTextUnitWriter
implements TextUnitWriter {
    private final Logger LOGGER = LoggerFactory.getLogger(BlockTextUnitWriter.class);
    private final XMLEventFactory eventFactory;
    private final QName runName;
    private final QName textName;
    private final RunProperties baseRunProperties;
    private final List<XMLEvents> hiddenCodes;
    private final Map<Integer, XMLEvents> visibleCodes;
    private final XMLEventSerializer xmlWriter;
    private final RunPropertiesClarifier runPropertiesClarifier;
    private final ConditionalParameters cparams;
    private Deque<RunProperties> currentRunProperties = new ArrayDeque<RunProperties>();
    private StringBuilder textContent = new StringBuilder();
    private boolean runIsOpen = false;

    BlockTextUnitWriter(ConditionalParameters cparams, XMLEventFactory eventFactory, BlockSkeleton blockSkeleton, XMLEventSerializer xmlWriter, RunPropertiesClarifier runPropertiesClarifier) {
        this.cparams = cparams;
        this.eventFactory = eventFactory;
        this.runName = blockSkeleton.block().getRunName();
        this.textName = blockSkeleton.block().getTextName();
        this.baseRunProperties = blockSkeleton.baseRunProperties();
        this.hiddenCodes = blockSkeleton.hiddenCodes();
        this.visibleCodes = blockSkeleton.visibleCodes();
        this.xmlWriter = xmlWriter;
        this.runPropertiesClarifier = runPropertiesClarifier;
    }

    @Override
    public void write(TextContainer tc) {
        boolean firstSegmentWritten = false;
        for (Segment segment : tc.getSegments()) {
            if (!firstSegmentWritten) {
                this.writeFirstSegment(tc.getFirstSegment());
                firstSegmentWritten = true;
                continue;
            }
            this.writeSegment(segment);
        }
        this.flushText(true);
    }

    private void writeFirstSegment(Segment segment) {
        for (XMLEvents events : this.hiddenCodes) {
            this.xmlWriter.add(events);
        }
        this.writeSegment(segment);
    }

    private void writeSegment(Segment segment) {
        try {
            TextFragment content = segment.getContent();
            String codedText = content.getCodedText();
            List<Code> codes = content.getCodes();
            for (int i = 0; i < codedText.length(); ++i) {
                char c = codedText.charAt(i);
                if (TextFragment.isMarker(c)) {
                    int codeIndex = TextFragment.toIndex(codedText.charAt(++i));
                    this.writeCode(codes.get(codeIndex));
                    continue;
                }
                this.writeChar(c);
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Threw {} writing segment id {} '{}'", new Object[]{e.getClass().getSimpleName(), segment.getId(), segment.toString()});
            throw e;
        }
    }

    private void writeChar(char c) {
        if (!this.runIsOpen && this.currentRunProperties.isEmpty()) {
            this.writeRunStart(this.baseRunProperties);
            this.runIsOpen = true;
        }
        this.textContent.append(c);
    }

    private void writeCode(Code code) {
        int id = code.getId();
        XMLEvents codeEvents = this.visibleCodes.get(id);
        switch (code.getTagType()) {
            case OPENING: {
                this.flushText(true);
                if (codeEvents instanceof RunProperties) {
                    this.currentRunProperties.push((RunProperties)codeEvents);
                    break;
                }
                if (codeEvents instanceof RunContainer) {
                    RunContainer rc = (RunContainer)codeEvents;
                    this.xmlWriter.addAll(rc.startMarkupEvents());
                    this.currentRunProperties.push(rc.getDefaultRunProperties());
                    break;
                }
                throw new IllegalStateException("Unexpected code contents for opening code '" + code.toString() + "':" + codeEvents);
            }
            case PLACEHOLDER: {
                boolean isRunMarkup = codeEvents instanceof Run.Markup;
                if (isRunMarkup) {
                    this.flushRunStart();
                }
                this.flushText(!isRunMarkup);
                this.xmlWriter.add(codeEvents);
                break;
            }
            case CLOSING: {
                this.flushText(true);
                if (codeEvents instanceof RunProperties) {
                    this.currentRunProperties.pop();
                    break;
                }
                if (codeEvents instanceof RunContainer) {
                    RunContainer rc = (RunContainer)codeEvents;
                    this.xmlWriter.addAll(rc.endMarkupEvents());
                    this.currentRunProperties.pop();
                    break;
                }
                throw new IllegalStateException("Unexpected code contents for closing code '" + code.toString() + "':" + codeEvents);
            }
        }
    }

    private void flushRunStart() {
        if (!this.runIsOpen) {
            this.writeRunStart(this.currentRunProperties.isEmpty() ? this.baseRunProperties : this.currentRunProperties.peek());
            this.runIsOpen = true;
        }
    }

    private void flushText(boolean terminateRun) {
        if (this.textContent.length() > 0) {
            this.flushRunStart();
            String text = this.textContent.toString();
            this.writeRunText(text);
            this.textContent = new StringBuilder();
        }
        if (terminateRun && this.runIsOpen) {
            this.writeRunEnd();
            this.runIsOpen = false;
        }
    }

    private void writeRunStart(RunProperties properties) {
        if (this.runName == null) {
            throw new IllegalStateException("no run name set");
        }
        this.xmlWriter.add(this.eventFactory.createStartElement(this.runName, null, null));
        this.xmlWriter.add(this.runPropertiesClarifier.clarify(properties));
    }

    private void writeRunText(String text) {
        if (this.textName == null) {
            throw new IllegalStateException("no text name set");
        }
        if (this.textName.getPrefix().isEmpty()) {
            this.writeText(text);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == this.cparams.getLineSeparatorReplacement() && this.cparams.getAddLineSeparatorCharacter()) {
                this.writeTextIfNeeded(sb);
                sb.setLength(0);
                this.writeLineBreak();
                continue;
            }
            if (c == '\t' && this.cparams.getAddTabAsCharacter() && Namespaces.WordProcessingML.containsName(this.textName)) {
                this.writeTextIfNeeded(sb);
                sb.setLength(0);
                this.writeTab();
                continue;
            }
            sb.append(c);
        }
        this.writeTextIfNeeded(sb);
    }

    private void writeTextIfNeeded(StringBuilder buffer) {
        if (buffer.length() > 0) {
            this.writeText(buffer.toString());
        }
    }

    private void writeTab() {
        QName br = XMLEventHelpers.createQName("tab", this.textName);
        this.xmlWriter.add(this.eventFactory.createStartElement(br, null, null));
        this.xmlWriter.add(this.eventFactory.createEndElement(br, null));
    }

    private void writeLineBreak() {
        this.writeRunEnd();
        this.writeRunStart(this.currentRunProperties.isEmpty() ? this.baseRunProperties : this.currentRunProperties.peek());
        QName br = XMLEventHelpers.createQName("br", this.textName);
        this.xmlWriter.add(this.eventFactory.createStartElement(br, null, null));
        this.xmlWriter.add(this.eventFactory.createEndElement(br, null));
    }

    private void writeText(String text) {
        boolean needsPreserveSpace = BlockTextUnitWriter.needsXmlSpacePreserve(text);
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (needsPreserveSpace && !Namespaces.DrawingML.containsName(this.textName)) {
            attrs.add(this.eventFactory.createAttribute("xml", Namespaces.XML.getURI(), "space", "preserve"));
        }
        this.xmlWriter.add(this.eventFactory.createStartElement(this.textName, attrs.iterator(), null));
        this.xmlWriter.add(this.eventFactory.createCharacters(text));
        this.xmlWriter.add(this.eventFactory.createEndElement(this.textName, null));
    }

    private void writeRunEnd() {
        this.xmlWriter.add(this.eventFactory.createEndElement(this.runName, null));
    }

    static boolean needsXmlSpacePreserve(String text) {
        for (char c : text.toCharArray()) {
            if (!Character.isWhitespace(c) && c != '\u00a0') continue;
            return true;
        }
        return false;
    }
}

