/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinition;
import net.sf.okapi.filters.openxml.SchemaDefinitions;
import net.sf.okapi.filters.openxml.StrippableAttributes;

class BlockPropertiesFactory {
    BlockPropertiesFactory() {
    }

    static BlockProperties createParagraphProperties(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, List<BlockProperty> blockProperties) {
        return BlockPropertiesFactory.createBlockProperties(conditionalParameters, creationalParameters, "pPr", Collections.emptyList(), blockProperties);
    }

    static BlockProperties createTextBodyProperties(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, List<Attribute> startElementAttributes) {
        return BlockPropertiesFactory.createBlockProperties(conditionalParameters, creationalParameters, "bodyPr", startElementAttributes, Collections.emptyList());
    }

    static BlockProperties createTableProperties(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, List<Attribute> startElementAttributes, List<BlockProperty> blockProperties) {
        return BlockPropertiesFactory.createBlockProperties(conditionalParameters, creationalParameters, "tblPr", startElementAttributes, blockProperties);
    }

    private static BlockProperties createBlockProperties(ConditionalParameters conditionalParameters, CreationalParameters creationalParameters, String startElementLocalName, List<Attribute> startElementAttributes, List<BlockProperty> blockProperties) {
        StartElement startElement = creationalParameters.getEventFactory().createStartElement(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), startElementLocalName, startElementAttributes.iterator(), null);
        EndElement endElement = creationalParameters.getEventFactory().createEndElement(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), startElementLocalName);
        return BlockPropertiesFactory.createBlockProperties(conditionalParameters, creationalParameters.getEventFactory(), startElement, endElement, blockProperties);
    }

    static BlockProperties createBlockProperties(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement, EndElement endElement, List<BlockProperty> properties) {
        if ("pPr".equals(startElement.getName().getLocalPart()) || "defPPr".equals(startElement.getName().getLocalPart()) || PowerpointStyleDefinition.PARAGRAPH_LEVELS.contains(startElement.getName().getLocalPart())) {
            if ("a".equals(startElement.getName().getPrefix())) {
                return new ParagraphBlockProperties.Drawing(new BlockProperties.Default(eventFactory, startElement, endElement, properties), conditionalParameters, eventFactory, new StrippableAttributes.General(conditionalParameters, eventFactory), SchemaDefinitions.of(startElement));
            }
            return new ParagraphBlockProperties.Word(new BlockProperties.Default(eventFactory, startElement, endElement, properties), conditionalParameters, eventFactory, new StrippableAttributes.General(conditionalParameters, eventFactory));
        }
        return new BlockProperties.Default(eventFactory, startElement, endElement, properties);
    }
}

