/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.multiparsers;

import net.sf.okapi.common.encoder.DefaultEncoder;
import net.sf.okapi.common.encoder.EncoderContext;

public class CsvEncoder
extends DefaultEncoder {
    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        if (text.indexOf(34) > -1) {
            return text.replace("\"", "\"\"");
        }
        return text;
    }

    @Override
    public String encode(char value, EncoderContext context) {
        if (value == '\"') {
            return "\"\"";
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (Character.isSupplementaryCodePoint(value)) {
            return new String(Character.toChars(value));
        }
        return this.encode((char)value, context);
    }
}

