/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Objects;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.Property;
import net.sf.okapi.filters.idml.StyleRange;

class StyleRanges {
    private final StyleRange paragraphStyleRange;
    private final StyleRange characterStyleRange;

    StyleRanges(StyleRange paragraphStyleRange, StyleRange characterStyleRange) {
        this.paragraphStyleRange = paragraphStyleRange;
        this.characterStyleRange = characterStyleRange;
    }

    static StyleRanges defaultStyleRanges(XMLEventFactory eventFactory) {
        return new StyleRanges(StyleRange.getDefaultParagraphStyleRange(eventFactory), StyleRange.getDefaultCharacterStyleRange(eventFactory));
    }

    StyleRange getParagraphStyleRange() {
        return this.paragraphStyleRange;
    }

    StyleRange getCharacterStyleRange() {
        return this.characterStyleRange;
    }

    StyleRange getCombinedStyleRange() {
        StyleRange.StyleRangeBuilder styleRangeBuilder = new StyleRange.StyleRangeBuilder();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Attribute attribute : this.paragraphStyleRange.getAttributes()) {
            if ("AppliedParagraphStyle".equals(attribute.getName().getLocalPart())) continue;
            attributes.add(attribute);
        }
        for (Attribute attribute : this.characterStyleRange.getAttributes()) {
            if ("AppliedCharacterStyle".equals(attribute.getName().getLocalPart())) continue;
            attributes.add(attribute);
        }
        styleRangeBuilder.setAttributes(attributes);
        ArrayList<Property> properties = new ArrayList<Property>(this.paragraphStyleRange.getProperties().properties());
        properties.addAll(this.characterStyleRange.getProperties().properties());
        Properties.Builder propertiesBuilder = new Properties.Builder();
        propertiesBuilder.setStartElement(this.paragraphStyleRange.getProperties().startElement()).setEndElement(this.paragraphStyleRange.getProperties().endElement()).addProperties(properties);
        return styleRangeBuilder.setProperties(propertiesBuilder.build()).build();
    }

    boolean isSubsetOf(StyleRanges other) {
        return this.getParagraphStyleRange().isSubsetOf(other.getParagraphStyleRange()) && this.getCharacterStyleRange().isSubsetOf(other.getCharacterStyleRange());
    }

    int amount() {
        return this.paragraphStyleRange.getAttributes().size() + this.paragraphStyleRange.getProperties().properties().size() + this.characterStyleRange.getAttributes().size() + this.characterStyleRange.getProperties().properties().size();
    }

    void apply(FontMappings fontMappings) {
        this.paragraphStyleRange.apply(fontMappings);
        this.characterStyleRange.apply(fontMappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        StyleRanges that = (StyleRanges)o;
        return Objects.equals(this.getParagraphStyleRange(), that.getParagraphStyleRange()) && Objects.equals(this.getCharacterStyleRange(), that.getCharacterStyleRange());
    }

    public int hashCode() {
        return Objects.hash(this.getParagraphStyleRange(), this.getCharacterStyleRange());
    }
}

