/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.GeometryPath;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.PathPoint;

class GeometryPathParser {
    private static final QName PATH_POINT_ARRAY = Namespaces.getDefaultNamespace().getQName("PathPointArray");
    private final StartElement startElement;
    private final XMLEventReader eventReader;
    private final XMLEventFactory eventFactory;

    GeometryPathParser(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory) {
        this.startElement = startElement;
        this.eventReader = eventReader;
        this.eventFactory = eventFactory;
    }

    GeometryPath parse() throws XMLStreamException {
        GeometryPath.Builder geometryPathBuilder = new GeometryPath.Builder();
        geometryPathBuilder.setStartElement(this.startElement);
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                geometryPathBuilder.setEndElement(event.asEndElement());
                return geometryPathBuilder.build();
            }
            if (!event.isStartElement() || !PATH_POINT_ARRAY.equals(event.asStartElement().getName())) continue;
            this.parsePathPointArray(event.asStartElement(), geometryPathBuilder);
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private void parsePathPointArray(StartElement startElement, GeometryPath.Builder geometryPathBuilder) throws XMLStreamException {
        geometryPathBuilder.setPathPointArrayStartElement(startElement);
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                geometryPathBuilder.setPathPointArrayEndElement(event.asEndElement());
                return;
            }
            if (!event.isStartElement() || !PathPoint.NAME.equals(event.asStartElement().getName())) continue;
            geometryPathBuilder.addPathPoint(this.parsePathPoint(event.asStartElement()));
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private PathPoint parsePathPoint(StartElement startElement) throws XMLStreamException {
        XMLEvent event = this.eventReader.nextTag();
        if (!event.isEndElement() || !PathPoint.NAME.equals(event.asEndElement().getName())) {
            throw new IllegalStateException("Unexpected structure");
        }
        return new PathPoint.Default(startElement, this.eventFactory);
    }
}

