/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.icml;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeSimplifier;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.icml.ICMLContext;
import net.sf.okapi.filters.icml.ICMLFilterWriter;
import net.sf.okapi.filters.icml.ICMLSkeleton;
import net.sf.okapi.filters.icml.NodeReference;
import net.sf.okapi.filters.icml.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@UsingParameters(value=Parameters.class)
public class ICMLFilter
implements IFilter {
    private static String ATTRIBUTENAME_MARKUPTAG = "MarkupTag";
    private static String ELEMENTNAME_XMLELEMENT = "XMLElement";
    private static String ATTRIBUTEVALUE_XMLTAG = "XMLTag";
    private static String ATTRIBUTEVALUE_KEYFIGURE_PREFIX = "kf";
    private static String ELEMENTNAME_STORY = "Story";
    private static String PREFIX_CTYPE_TAG = "x-tag_";
    private static String PREFIX_CTYPE_PI = "x-pi_";
    private static String INDESIGN_PI_SPECIALCHAR = "ACE";
    private static String SPECHIALCHAR_INDENT_HERE = "7";
    private static String SPECHIALCHAR_RIGHT_INDENT_TAB = "8";
    private static String SPECHIALCHAR_END_NESTED_STYLE = "3";
    private static String SPECHIALCHAR_SECTION_MARKER = "19";
    private static String SPECHIALCHAR_AUTO_PAGENUMBER = "18";
    private static final String DOCID = "sd";
    private static final String ENDID = "end";
    private static final String SPREADTYPE = "spread";
    private static final String STORYTYPE = "story";
    private static final String EMBEDDEDSTORIES = "embedded-stories";
    private final DocumentBuilder docBuilder;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private URI docURI;
    private LinkedList<Event> queue;
    private LocaleId srcLoc;
    private Parameters params;
    private EncoderManager encoderManager;
    private HashMap<String, Document> stories;
    private LinkedHashMap<String, ArrayList<String>> spreads;
    private ArrayList<String> storiesDone;
    private Iterator<String> storyIter;
    private Iterator<String> spreadIter;
    private IdGenerator spreadIdGen;
    private IdGenerator storyIdGen;
    private int spreadStack;
    private String tuIdPrefix;
    private Stack<ICMLContext> ctx;
    private HashMap<String, Boolean> embeddedElements;
    private HashMap<String, Integer> embeddedElementsPos;
    private IdGenerator refGen;
    private IdGenerator tuIdGen;
    private int deconstructing;
    private RawDocument input;
    private Document doc;
    private File tempFile;
    private CodeSimplifier simplifier = new CodeSimplifier();

    public ICMLFilter() {
        try {
            this.params = new Parameters();
            DocumentBuilderFactory docFact = DocumentBuilderFactory.newInstance();
            docFact.setValidating(false);
            try {
                docFact.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docFact.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException e) {
                this.logger.warn("Unsupported DocumentBuilderFactory feature. Possible security vulnerabilities.", (Throwable)e);
            }
            this.docBuilder = docFact.newDocumentBuilder();
            this.embeddedElements = new HashMap();
            this.embeddedElementsPos = new HashMap();
            for (String name : this.embeddedElements.keySet()) {
                this.embeddedElementsPos.put(name, -1);
            }
            this.simplifier.setPostSegmentation(false);
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error initializing.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new ICMLFilterWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-icml+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getName() {
        return "okf_icml";
    }

    @Override
    public String getDisplayName() {
        return "ICML Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-icml+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-icml+xml", this.getClass().getName(), "ICML", "Adobe InDesign ICML documents", null, ".wcml;.icml"));
        return list;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null;
    }

    @Override
    public Event next() {
        if (this.queue == null) {
            return null;
        }
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        this.read();
        if (this.queue.size() == 0) {
            this.queue = null;
            Ending ending = new Ending("ed");
            return new Event(EventType.END_DOCUMENT, ending);
        }
        return this.queue.poll();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.queue = null;
        this.close();
        this.input = input;
        this.docURI = input.getInputURI();
        if (this.docURI == null) {
            if (input.getStream() != null) {
                this.tempFile = FileUtil.createTempFile("~okapi-ICMLFilter_");
                StreamUtil.copy(input.getStream(), this.tempFile);
                this.docURI = Util.toURI(this.tempFile.getAbsolutePath());
            } else {
                throw new OkapiBadFilterInputException("Input stream is null.");
            }
        }
        this.srcLoc = input.getSourceLocale();
        this.spreadIdGen = new IdGenerator(null, "spr");
        this.storyIdGen = new IdGenerator(null, "sto");
        this.gatherStories();
        StartDocument sd = new StartDocument(DOCID);
        sd.setEncoding("UTF-8", false);
        sd.setName(this.docURI.getPath());
        sd.setLocale(this.srcLoc);
        sd.setMimeType("application/x-icml+xml");
        sd.setLineBreak("\n");
        sd.setFilterId(this.getName());
        sd.setFilterParameters(this.params);
        sd.setFilterWriter(this.createFilterWriter());
        sd.setSkeleton(new ICMLSkeleton(this.doc));
        this.queue = new LinkedList();
        this.queue.add(new Event(EventType.START_DOCUMENT, sd));
        if (!Util.isEmpty(this.getParameters().getSimplifierRules())) {
            Event cs = FilterUtil.createCodeSimplifierEvent(this.getParameters().getSimplifierRules());
            this.simplifier.setRules(this.getParameters().getSimplifierRules());
            this.queue.add(cs);
        }
        if (this.spreads.size() > 0) {
            this.spreadIter = this.spreads.keySet().iterator();
            if (this.spreadIter.hasNext()) {
                String spreadName = this.spreadIter.next();
                this.storyIter = this.spreads.get(spreadName).iterator();
                StartGroup sg = new StartGroup(DOCID, this.spreadIdGen.createId());
                this.queue.add(new Event(EventType.START_GROUP, sg));
                sg.setName(spreadName);
                if (spreadName.equals(EMBEDDEDSTORIES)) {
                    sg.setId(EMBEDDEDSTORIES);
                } else {
                    sg.setType(SPREADTYPE);
                }
                ++this.spreadStack;
            }
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private void read() {
        if (this.spreadIter == null) {
            return;
        }
        while (true) {
            if (this.storyIter.hasNext()) {
                this.processStory(this.storyIter.next());
                return;
            }
            if (this.spreadStack > 0) {
                Ending ending = new Ending(this.spreadIdGen.getLastId() + ENDID);
                this.queue.add(new Event(EventType.END_GROUP, ending));
                --this.spreadStack;
            }
            if (!this.spreadIter.hasNext()) break;
            String spreadName = this.spreadIter.next();
            this.storyIter = this.spreads.get(spreadName).iterator();
            StartGroup sg = new StartGroup(DOCID, this.spreadIdGen.createId());
            sg.setName(spreadName);
            if (spreadName.equals(EMBEDDEDSTORIES)) {
                sg.setId(EMBEDDEDSTORIES);
            } else {
                sg.setType(SPREADTYPE);
            }
            this.queue.add(new Event(EventType.START_GROUP, sg));
            ++this.spreadStack;
        }
    }

    private void gatherStories() {
        this.spreadIter = null;
        this.storyIter = null;
        this.spreads = new LinkedHashMap();
        this.storiesDone = new ArrayList();
        this.stories = new HashMap();
        try {
            InputSource is = new InputSource(this.input.getStream());
            this.doc = this.docBuilder.parse(is);
            this.gatherStoriesInSpread();
            this.gatherStoriesInStory();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error while gathering stories.\n" + e.getMessage(), e);
        }
    }

    private int gatherStoriesInSpread() throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> storyList = new ArrayList<String>();
        NodeList list = this.doc.getElementsByTagName("Story");
        for (int i = 0; i < list.getLength(); ++i) {
            Element tf = (Element)list.item(i);
            String selfId = tf.getAttribute("Self");
            if (Util.isEmpty(selfId)) {
                throw new IOException("Missing value for Self.");
            }
            if (!this.IsEmbeddedStory(selfId) && !this.storiesDone.contains(selfId)) {
                storyList.add(selfId);
                this.storiesDone.add(selfId);
            }
            this.stories.put(selfId, this.doc);
        }
        this.spreads.put("Stories", storyList);
        return storyList.size();
    }

    private boolean IsEmbeddedStory(String storyId) throws IOException {
        boolean isEmbedded = false;
        NodeList references = this.doc.getElementsByTagName("TextFrame");
        for (int i = 0; i < references.getLength(); ++i) {
            Element tf = (Element)references.item(i);
            String parentStory = tf.getAttribute("ParentStory");
            if (Util.isEmpty(parentStory)) {
                throw new IOException("Missing value for parentStory.");
            }
            if (!storyId.equals(parentStory)) continue;
            isEmbedded = true;
            break;
        }
        return isEmbedded;
    }

    private void gatherStoriesInStory() throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> storyList = new ArrayList<String>();
        NodeList list = this.doc.getElementsByTagName("TextFrame");
        for (int i = 0; i < list.getLength(); ++i) {
            Element tf = (Element)list.item(i);
            String tmp = tf.getAttribute("ParentStory");
            if (Util.isEmpty(tmp)) {
                throw new IOException("Missing value for parentStory.");
            }
            if (this.storiesDone.contains(tmp)) continue;
            storyList.add(tmp);
            this.storiesDone.add(tmp);
        }
        if (!storyList.isEmpty()) {
            ArrayList<String> existingList = this.spreads.get(EMBEDDEDSTORIES);
            if (existingList == null) {
                this.spreads.put(EMBEDDEDSTORIES, storyList);
            } else {
                existingList.addAll(storyList);
                this.spreads.put(EMBEDDEDSTORIES, existingList);
            }
        }
    }

    private void processStory(String storyId) {
        Document entry = this.stories.get(storyId);
        if (entry == null) {
            throw new OkapiIOException("No story entry found for " + storyId);
        }
        try {
            Document doc = entry;
            StartGroup sg = new StartGroup(this.spreadIdGen.getLastId(), this.storyIdGen.createId());
            sg.setName(storyId);
            sg.setType(STORYTYPE);
            sg.setSkeleton(new ICMLSkeleton(entry, doc));
            this.queue.add(new Event(EventType.START_GROUP, sg));
            this.tuIdPrefix = storyId + "-";
            this.ctx = new Stack();
            this.refGen = new IdGenerator(null);
            this.tuIdGen = new IdGenerator(null);
            Node topNode = this.getStory(storyId);
            this.ctx.push(new ICMLContext(false, topNode));
            this.deconstructing = 0;
            for (String name : this.embeddedElementsPos.keySet()) {
                this.embeddedElementsPos.put(name, -1);
            }
            this.processNodes(topNode);
            Ending ending = new Ending(this.storyIdGen.getLastId() + ENDID);
            this.queue.add(new Event(EventType.END_GROUP, ending));
        }
        catch (Throwable e) {
            throw new OkapiIOException(String.format("Error processing story file '%s'.\n" + e.getMessage(), storyId), e);
        }
    }

    private Node getStory(String storyId) {
        Node topNode = null;
        NodeList stories = this.doc.getElementsByTagName("Story");
        for (int i = 0; i < stories.getLength(); ++i) {
            Element tf = (Element)stories.item(i);
            String tmp = tf.getAttribute("Self");
            if (Util.isEmpty(tmp)) {
                try {
                    throw new IOException("Missing value for Story.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!tmp.equals(storyId)) continue;
            topNode = stories.item(i);
            break;
        }
        return topNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processNodes(Node node) {
        while (true) {
            Element elem;
            block38: {
                Code c;
                String attribute;
                String name;
                block37: {
                    block35: {
                        Node tmpNode;
                        block36: {
                            if (node == null) {
                                return;
                            }
                            if (node.getNodeType() != 1) {
                                if (this.ctx.peek().inScope()) {
                                    switch (node.getNodeType()) {
                                        case 3: 
                                        case 4: {
                                            this.ctx.peek().addCode(node);
                                            break;
                                        }
                                        default: {
                                            throw new OkapiIOException("Unexpected node type: " + node.getNodeType());
                                        }
                                    }
                                }
                                node = this.GetNextSiblingToProcessNodes(node);
                                continue;
                            }
                            elem = (Element)node;
                            name = elem.getNodeName();
                            if (name.equals("Content")) {
                                this.ctx.peek().addContent(elem);
                                node = this.GetNextSiblingToProcessNodes(elem);
                                continue;
                            }
                            if (!name.equals("ParagraphStyleRange")) break block36;
                            if (!this.HasParentPSR(elem)) {
                                if (this.doStartPSR(elem)) {
                                    node = this.GetNextSiblingToProcessNodes(elem);
                                    continue;
                                }
                                break block35;
                            } else if (this.ctx.peek().inScope()) {
                                if (this.deconstructing == 0) {
                                    ++this.deconstructing;
                                }
                                this.ctx.peek().addStartTag(elem);
                                tmpNode = this.ctx.peek().getScopeNode();
                                this.triggerTextUnit(elem, false);
                                this.ctx.peek().enterScope(tmpNode, this.makeTuId());
                            }
                            break block35;
                        }
                        if (this.embeddedElements.containsKey(name)) {
                            this.embeddedElementsPos.put(name, this.embeddedElementsPos.get(name) + 1);
                            if (this.ctx.peek().inScope()) {
                                String key;
                                if (this.embeddedElements.get(name).booleanValue()) {
                                    key = this.refGen.createId();
                                    this.ctx.peek().addCode(new Code(TextFragment.TagType.PLACEHOLDER, name, String.format("<%s id=\"%s\"/>", "SKLREF", key)));
                                    this.ctx.peek().addReference(key, this.makeNodeReference(node));
                                    this.ctx.push(new ICMLContext(true, node));
                                    break block35;
                                } else {
                                    key = this.refGen.createId();
                                    this.ctx.peek().addCode(new Code(TextFragment.TagType.PLACEHOLDER, name, String.format("<%s id=\"%s\"/>", "SKLREF", key)));
                                    this.ctx.peek().addReference(key, this.makeNodeReference(node));
                                    node = this.GetNextSiblingToProcessNodes(elem);
                                    continue;
                                }
                            }
                            node = this.GetNextSiblingToProcessNodes(elem);
                            continue;
                        }
                        if (name.equalsIgnoreCase("Br") && this.params.getNewTuOnBr()) {
                            if (this.ctx.peek().inScope()) {
                                if (this.deconstructing == 0) {
                                    ++this.deconstructing;
                                }
                                this.ctx.peek().addStartTag(elem);
                                tmpNode = this.ctx.peek().getScopeNode();
                                this.triggerTextUnit(elem, false);
                                this.ctx.peek().enterScope(tmpNode, this.makeTuId());
                                node = this.GetNextSiblingToProcessNodes(elem);
                                continue;
                            }
                        } else if (this.ctx.peek().inScope()) {
                            if (this.isKeyFigure(elem).booleanValue()) {
                                attribute = elem.getAttribute(ATTRIBUTENAME_MARKUPTAG);
                                attribute = attribute.substring(attribute.indexOf("/") + 1).toUpperCase();
                                c = new Code(TextFragment.TagType.OPENING, PREFIX_CTYPE_TAG + attribute, this.buildStartTag(elem));
                                c.setAnnotation("protected", null);
                                this.ctx.peek().addCode(c);
                            } else {
                                this.ctx.peek().addStartTag(elem);
                            }
                        }
                    }
                    if (elem.hasChildNodes()) {
                        this.processNodes(elem.getFirstChild());
                    }
                    if (!name.equals("ParagraphStyleRange")) break block37;
                    if (!this.HasParentPSR(elem)) {
                        this.triggerTextUnit(elem, true);
                        if (this.deconstructing > 0) {
                            --this.deconstructing;
                        }
                        break block38;
                    } else if (this.ctx.peek().inScope()) {
                        this.ctx.peek().addEndTag(elem);
                    }
                    break block38;
                }
                if (this.embeddedElements.containsKey(name)) {
                    if (this.ctx.peek().inScope()) {
                        // empty if block
                    }
                    this.ctx.pop();
                } else if (this.ctx.peek().inScope()) {
                    if (this.isKeyFigure(elem).booleanValue()) {
                        attribute = elem.getAttribute(ATTRIBUTENAME_MARKUPTAG);
                        attribute = attribute.substring(attribute.indexOf("/") + 1).toUpperCase();
                        c = new Code(TextFragment.TagType.CLOSING, PREFIX_CTYPE_TAG + attribute, this.buildEndTag(elem));
                        c.setAnnotation("protected", null);
                        this.ctx.peek().addCode(c);
                    } else {
                        this.ctx.peek().addEndTag(elem);
                    }
                }
            }
            node = this.GetNextSiblingToProcessNodes(elem);
        }
    }

    public String buildStartTag(Element elem) {
        StringBuilder sb = new StringBuilder("<" + elem.getNodeName());
        NamedNodeMap attrNames = elem.getAttributes();
        for (int i = 0; i < attrNames.getLength(); ++i) {
            Attr attr = (Attr)attrNames.item(i);
            sb.append(" " + attr.getName() + "=\"");
            sb.append(Util.escapeToXML(attr.getValue(), 3, false, null));
            sb.append("\"");
        }
        if (elem.hasChildNodes()) {
            sb.append(">");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    public String buildEndTag(Element elem) {
        if (elem.hasChildNodes()) {
            return "</" + elem.getNodeName() + ">";
        }
        return "";
    }

    private Boolean isKeyFigure(Element elem) {
        Node parent = elem.getParentNode();
        String name = elem.getNodeName();
        String attribute = elem.getAttribute(ATTRIBUTENAME_MARKUPTAG);
        return ELEMENTNAME_XMLELEMENT.equals(name) && attribute != null && attribute.startsWith(ATTRIBUTEVALUE_XMLTAG + "/" + ATTRIBUTEVALUE_KEYFIGURE_PREFIX + "_") && parent != null && !ELEMENTNAME_STORY.equals(parent.getNodeName());
    }

    private void triggerTextUnit(Node node, boolean isEndTag) {
        if (this.ctx.peek().addToQueue(this.queue, this.deconstructing > 0) && this.params.getSimplifyCodes()) {
            boolean hasParent;
            ITextUnit tu = this.queue.getLast().getTextUnit();
            TextFragment tf = tu.getSource().getFirstContent();
            TextFragment[] res = this.simplifier.simplifyAll(tf, true);
            ICMLSkeleton skel = (ICMLSkeleton)tu.getSkeleton();
            if (res != null) {
                if (tu.getSource().isEmpty() && this.deconstructing == 0) {
                    this.queue.removeLast();
                } else {
                    skel.addMovedParts(res);
                }
            }
            hasParent = (hasParent = this.HasParentPSR(node)) || !isEndTag;
            skel.setForced(hasParent);
        }
        this.ctx.peek().leaveScope();
    }

    private NodeReference makeNodeReference(Node targetNode) {
        String name = targetNode.getNodeName();
        return new NodeReference(name, this.embeddedElementsPos.get(name));
    }

    private String makeTuId() {
        return this.tuIdPrefix + this.tuIdGen.createId();
    }

    private boolean doStartPSR(Node node) {
        NodeList list = ((Element)node).getElementsByTagName("Content");
        NodeList ranges = ((Element)node).getElementsByTagName("ParagraphStyleRange");
        if (ranges.getLength() > 0) {
            this.ctx.peek().enterScope(node, this.makeTuId());
            if (this.deconstructing > 0) {
                ++this.deconstructing;
            }
            return false;
        }
        if (ranges.getLength() == 0) {
            if (list.getLength() > 1) {
                this.ctx.peek().enterScope(node, this.makeTuId());
                if (this.deconstructing > 0) {
                    ++this.deconstructing;
                }
                return false;
            }
            if (list.getLength() == 1) {
                Element cnt = (Element)list.item(0);
                TextUnit tu = new TextUnit(this.makeTuId());
                tu.setSourceContent(ICMLFilter.processContent(cnt, null));
                tu.setPreserveWhitespaces(true);
                if (this.deconstructing > 0) {
                    ++this.deconstructing;
                }
                ICMLSkeleton skl = new ICMLSkeleton(this.ctx.peek().getTopNode(), cnt);
                boolean forced = this.HasParentPSR(node);
                skl.setForced(forced);
                tu.setSkeleton(skl);
                this.queue.add(new Event(EventType.TEXT_UNIT, tu));
            }
        }
        return true;
    }

    private boolean HasParentPSR(Node node) {
        boolean result = false;
        Node parent = node.getParentNode();
        do {
            if (parent == null) continue;
            if (parent.getNodeName().equals("ParagraphStyleRange")) {
                result = true;
            }
            parent = parent.getParentNode();
        } while (parent != null);
        return result;
    }

    private Node GetNextSiblingToProcessNodes(Node node) {
        Node nextSibling = node.getNextSibling();
        if (nextSibling != null && nextSibling.getNodeName().equals("Story")) {
            nextSibling = null;
        }
        return nextSibling;
    }

    static TextFragment processContent(Element content, TextFragment tf) {
        if (tf == null) {
            tf = new TextFragment();
        }
        block4: for (Node node = content.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: {
                    ICMLFilter.processText(tf, node.getNodeValue());
                    continue block4;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    tf.append(TextFragment.TagType.PLACEHOLDER, ICMLFilter.GetProcessingInstructionType(pi), String.format("<?%s %s?>", pi.getTarget(), pi.getTextContent()));
                    continue block4;
                }
                default: {
                    throw new OkapiIOException("Unexpected content in <Content>: " + node.getNodeType());
                }
            }
        }
        return tf;
    }

    static String GetProcessingInstructionType(ProcessingInstruction pi) {
        String target = pi.getTarget();
        String textContent = pi.getTextContent();
        if (target.equals(INDESIGN_PI_SPECIALCHAR)) {
            if (textContent.equals(SPECHIALCHAR_INDENT_HERE)) {
                return PREFIX_CTYPE_PI + "INDENTHERETAB";
            }
            if (textContent.equals(SPECHIALCHAR_RIGHT_INDENT_TAB)) {
                return PREFIX_CTYPE_PI + "RIGHTINDENTTAB";
            }
            if (textContent.equals(SPECHIALCHAR_END_NESTED_STYLE)) {
                return PREFIX_CTYPE_PI + "ENDNESTEDSTYLE";
            }
            if (textContent.equals(SPECHIALCHAR_SECTION_MARKER)) {
                return PREFIX_CTYPE_PI + "SECTIONMARKER";
            }
            if (textContent.equals(SPECHIALCHAR_AUTO_PAGENUMBER)) {
                return PREFIX_CTYPE_PI + "AUTOPAGENUMBER";
            }
        }
        return "pi";
    }

    static void processText(TextFragment dest, String text) {
        block15: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\u2028': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-break_FORCEDLINEBREAK", String.valueOf(ch));
                    continue block15;
                }
                case '\u200b': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-break_DISCRETIONARYLINEBREAK", String.valueOf(ch));
                    continue block15;
                }
                case '\u2012': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-dash_FIGUREDASH", String.valueOf(ch));
                    continue block15;
                }
                case '\u200a': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-space_HAIRSPACE", String.valueOf(ch));
                    continue block15;
                }
                case '\u2015': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-dash_HORIZONTALBAR", String.valueOf(ch));
                    continue block15;
                }
                case '\u2006': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-space_SIXTHSPACE", String.valueOf(ch));
                    continue block15;
                }
                case '\u2005': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-space_QUARTERSPACE", String.valueOf(ch));
                    continue block15;
                }
                case '\u2004': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-space_THIRDSPACE", String.valueOf(ch));
                    continue block15;
                }
                case '\u2008': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-space_PUNCTUATIONSPACE", String.valueOf(ch));
                    continue block15;
                }
                case '\u2009': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-space_THINSPACE", String.valueOf(ch));
                    continue block15;
                }
                case '\u2007': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-space_FIGURESPACE", String.valueOf(ch));
                    continue block15;
                }
                case '\u2001': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-space_FLUSHSPACE", String.valueOf(ch));
                    continue block15;
                }
                case '\ufeff': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "x-anchor_TEXTANCHOR", String.valueOf(ch));
                    continue block15;
                }
                default: {
                    dest.append(ch);
                }
            }
        }
    }
}

