/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.googleautoml;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

public class GoogleOAuth2Service {
    private static final String AUTH_URL = "https://www.googleapis.com/auth/cloud-platform";
    private GoogleCredential credential;

    public boolean hasCredential() {
        return this.credential != null;
    }

    public void setCredential(InputStream inputStream) {
        try {
            this.credential = GoogleCredential.fromStream((InputStream)inputStream).createScoped(Collections.singletonList(AUTH_URL));
        }
        catch (IOException e) {
            this.credential = null;
            throw new RuntimeException(e);
        }
    }

    public void setCredentialFilePath(String credentialFilePath) {
        try (FileInputStream is = new FileInputStream(new File(credentialFilePath));){
            this.setCredential(is);
        }
        catch (IOException e) {
            this.credential = null;
            throw new RuntimeException(e);
        }
    }

    public void setCredentialString(String credentialString) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(credentialString.getBytes(StandardCharsets.UTF_8));){
            this.setCredential(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAccessToken() throws IOException {
        boolean successfulRefresh;
        if (this.credential == null) {
            throw new IllegalStateException("Credential has not been initialized");
        }
        Long expirationTime = this.credential.getExpirationTimeMilliseconds();
        if (!(expirationTime != null && expirationTime >= 0L || (successfulRefresh = this.credential.refreshToken()))) {
            throw new RuntimeException("Unable to refresh token");
        }
        return this.credential.getAccessToken();
    }
}

