/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.connectors.google.GoogleMTErrorException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GoogleResponseParser {
    private JSONParser parser = new JSONParser();

    public List<String> parseResponse(Reader r) throws IOException, ParseException {
        return this.parseArrayResponse(r, "translations", "translatedText");
    }

    public List<String> parseLanguagesResponse(Reader r) throws IOException, ParseException {
        return this.parseArrayResponse(r, "languages", "language");
    }

    protected List<String> parseArrayResponse(Reader r, String arrayName, String arrayKey) throws IOException, ParseException {
        JSONObject json = (JSONObject)this.parser.parse(r);
        JSONArray array = this.requireArray(this.require(json, "data"), arrayName);
        ArrayList<String> values = new ArrayList<String>();
        for (Object o : array) {
            if (!(o instanceof JSONObject)) continue;
            values.add(this.unescapeTranslation(this.requireString((JSONObject)o, arrayKey)));
        }
        return values;
    }

    public GoogleMTErrorException parseError(int code, String s, String query) throws IOException, ParseException {
        try {
            JSONObject json = (JSONObject)this.parser.parse(s);
            json = this.require(json, "error");
            JSONObject inner = (JSONObject)this.requireArray(json, "errors").get(0);
            return new GoogleMTErrorException((int)this.requireLong(json, "code"), this.requireString(inner, "message"), this.requireString(inner, "domain"), this.requireString(inner, "reason"), query);
        }
        catch (Exception e) {
            return new GoogleMTErrorException(code, "Google returned non-JSON error: " + s, "", "", query);
        }
    }

    private String unescapeTranslation(String text) {
        text = text.replace("&#39;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        return text.replace("&amp;", "&");
    }

    private JSONObject require(JSONObject json, String key) {
        Object o = json.get((Object)key);
        if (o == null || !(o instanceof JSONObject)) {
            throw new IllegalArgumentException("JSON didn't contain expected object " + key);
        }
        return (JSONObject)o;
    }

    private String requireString(JSONObject json, String key) {
        Object o = json.get((Object)key);
        if (o == null || !(o instanceof String)) {
            throw new IllegalArgumentException("JSON didn't contain expected object " + key);
        }
        return (String)o;
    }

    private long requireLong(JSONObject json, String key) {
        Object o = json.get((Object)key);
        if (o == null || !(o instanceof Long)) {
            throw new IllegalArgumentException("JSON didn't contain expected object " + key);
        }
        return (Long)o;
    }

    private JSONArray requireArray(JSONObject json, String key) {
        Object o = json.get((Object)key);
        if (o == null || !(o instanceof JSONArray)) {
            throw new IllegalArgumentException("JSON didn't contain expected array " + key);
        }
        return (JSONArray)o;
    }
}

