/*===========================================================================
  Copyright (C) 2016-2017 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
===========================================================================*/

package net.sf.okapi.filters.openxml;

import net.sf.okapi.filters.openxml.BlockPropertiesClarifierStrategy.PropertiesClarifierStrategy.ParagraphPropertiesClarifierStrategy;

import static net.sf.okapi.filters.openxml.Namespaces.DrawingML;
import static net.sf.okapi.filters.openxml.Namespaces.fromNamespaceURI;
import static net.sf.okapi.filters.openxml.XMLEventHelpers.LOCAL_RTL;
import static net.sf.okapi.filters.openxml.XMLEventHelpers.LOCAL_RTL_COL;

/**
 * Provides a block properties clarifier strategy factory.
 */
class BlockPropertiesClarifierStrategyFactory {

    /**
     * Creates a paragraph properties clarifier strategy.
     *
     * @param conditionalParameters   Conditional parameters
     * @param creationalParameters    Creational parameters
     * @param clarificationParameters Clarification parameters
     *
     * @return A paragraph properties clarifier strategy
     */
    static BlockPropertiesClarifierStrategy createParagraphPropertiesClarifierStrategy(
        ConditionalParameters conditionalParameters,
        CreationalParameters creationalParameters,
        ClarificationParameters clarificationParameters
    ) {
        return new ParagraphPropertiesClarifierStrategy(conditionalParameters, creationalParameters, clarificationParameters);
    }

    /**
     * Creates a text body properties clarifier strategy.
     *
     * @param conditionalParameters   Conditional parameters
     * @param creationalParameters    Creational parameters
     * @param clarificationParameters Clarification parameters
     *
     * @return A text body properties clarifier strategy
     */
    static BlockPropertiesClarifierStrategy createTextBodyPropertiesClarifierStrategy(
        ConditionalParameters conditionalParameters,
        CreationalParameters creationalParameters,
        ClarificationParameters clarificationParameters
    ) {
        CreationalParameters newCreationalParameters = (DrawingML != fromNamespaceURI(creationalParameters.getNamespaceUri()))
                ? new CreationalParameters(
                    creationalParameters.getEventFactory(),
                    Namespace.PREFIX_A,
                    DrawingML.getURI())
                : creationalParameters;

        return new BlockPropertiesClarifierStrategy.AttributesClarifierStrategy.TextBodyPropertiesClarifierStrategy(
            conditionalParameters,
            newCreationalParameters,
            clarificationParameters,
            new ClarifiableAttribute(Namespace.PREFIX_EMPTY, LOCAL_RTL_COL, XMLEventHelpers.booleanAttributeTrueValues())
        );
    }

    /**
     * Creates a table properties clarifier strategy.
     *
     * @param conditionalParameters   Conditional parameters
     * @param creationalParameters    Creational parameters
     * @param clarificationParameters Clarification parameters
     *
     * @return A table properties clarifier strategy
     */
    static BlockPropertiesClarifierStrategy createTablePropertiesClarifierStrategy(
        ConditionalParameters conditionalParameters,
        CreationalParameters creationalParameters,
        ClarificationParameters clarificationParameters
    ) {
        if (DrawingML == fromNamespaceURI(creationalParameters.getNamespaceUri())) {
            return new BlockPropertiesClarifierStrategy.AttributesClarifierStrategy.TablePropertiesClarifierStrategy(
                conditionalParameters,
                creationalParameters,
                clarificationParameters,
                new ClarifiableAttribute(Namespace.PREFIX_EMPTY, LOCAL_RTL, XMLEventHelpers.booleanAttributeTrueValues())
            );
        }

        return new BlockPropertiesClarifierStrategy.PropertiesClarifierStrategy.TablePropertiesClarifierStrategy(
            conditionalParameters,
            creationalParameters,
            clarificationParameters
        );
    }
}
