/*===========================================================================
  Copyright (C) 2009 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
===========================================================================*/

package net.sf.okapi.common.filters;

/**
 * Storage for filter information.
 */
public class FilterInfo implements Comparable<FilterInfo> {

	/**
	 * Name of the filter.
	 */
	public String name;
	
	/**
	 * display name of the filter.
	 */
	public String displayName;
	
	/**
	 * Name of the class of the filter.
	 */
	public String className;
	
	/**
	 * Returns the display name of this filter.
	 */
	@Override
	public String toString () {
		return displayName;
	}

	/**
	 * Compares the display names of the two filters.
	 * @param obj the other filter info object to compare.
	 * @return the comparison result between the two filters display name, 0 if they are the same.
	 */
	@Override
	public int compareTo(FilterInfo obj) {
		return displayName.compareTo(obj.displayName);
	}

}
