/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xliffsplitter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xliffsplitter.XliffJoinerParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=XliffJoinerParameters.class)
public class XliffJoinerStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private HashMap<String, BaseXliffFile> baseXliffFiles = new HashMap();
    private XliffJoinerParameters params;
    private URI outputURI;
    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    XMLEventFactory eventFactory = XMLEventFactory.newInstance();

    public XliffJoinerStep() {
        this.params = new XliffJoinerParameters();
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    @Override
    public String getDescription() {
        return "Join multiple XLIFF documents into one. Expects: raw document. Sends back: raw document.";
    }

    @Override
    public String getName() {
        return "XLIFF Joiner";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (XliffJoinerParameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        if (this.params.getInputFileMarker().trim().length() == 0) {
            throw new OkapiBadFilterParametersException("The input file marker cannot be empty");
        }
        if (this.params.getOutputFileMarker().trim().length() == 0) {
            this.logger.warn("Leaving output file marker empty your original file(s) could be overwritten");
        }
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        for (Map.Entry<String, BaseXliffFile> entry : this.baseXliffFiles.entrySet()) {
            BaseXliffFile baseFile = entry.getValue();
            try {
                baseFile.writeAndClose();
            }
            catch (XMLStreamException e) {
                throw new OkapiBadStepInputException(e);
            }
        }
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        BaseXliffFile baseFile;
        int fileElemNo = 0;
        ArrayList<XMLEvent> elemsBetweenOrAfterLastFileElem = new ArrayList<XMLEvent>();
        RawDocument rawDoc = event.getRawDocument();
        String outputDir = Util.getDirectoryName(this.outputURI.getPath());
        String inputFileName = Util.getFilename(rawDoc.getInputURI().getPath(), false);
        String inputFileExtension = Util.getExtension(rawDoc.getInputURI().getPath());
        String baseFilename = this.getBaseFilename(inputFileName, this.params.getInputFileMarker());
        if (baseFilename == null) {
            this.logger.warn("This file is skipped: Input marker not found in its name.");
            return event;
        }
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(rawDoc.getStream(), "utf-8");
        detector.detectBom();
        String encoding = detector.getEncoding();
        boolean hasUTF8BOM = detector.hasUtf8Bom();
        String lineBreak = detector.getNewlineType().toString();
        if (this.baseXliffFiles.containsKey(baseFilename)) {
            baseFile = this.baseXliffFiles.get(baseFilename);
            baseFile.fileCount++;
            baseFile.filesUsed.add(Util.getFilename(rawDoc.getInputURI().getPath(), true));
        } else {
            String outputFileUri = outputDir + File.separator + baseFilename + this.params.getOutputFileMarker() + inputFileExtension;
            baseFile = new BaseXliffFile();
            baseFile.initiateWriter(outputFileUri, encoding, hasUTF8BOM);
            this.baseXliffFiles.put(baseFilename, baseFile);
            baseFile.fileCount = 1;
            baseFile.filesUsed.add(Util.getFilename(rawDoc.getInputURI().getPath(), true));
        }
        XMLEventReader eventReader = this.initiateReader(detector, encoding, rawDoc.getStream());
        while (eventReader.hasNext()) {
            try {
                XMLEvent xmlEvent = eventReader.nextEvent();
                if (baseFile.fileCount == 1) {
                    if (xmlEvent.getEventType() == 7) {
                        baseFile.write(xmlEvent);
                        baseFile.write(this.eventFactory.createSpace(lineBreak));
                        continue;
                    }
                    if (XliffJoinerStep.isFileStart(xmlEvent)) {
                        this.writeFilePart(baseFile, xmlEvent.asStartElement(), eventReader, ++fileElemNo, baseFile.firstFileTempElems);
                        continue;
                    }
                    if (fileElemNo == 0) {
                        baseFile.write(xmlEvent);
                        continue;
                    }
                    baseFile.firstFileTempElems.add(xmlEvent);
                    continue;
                }
                if (XliffJoinerStep.isFileStart(xmlEvent)) {
                    baseFile.write(this.eventFactory.createSpace(lineBreak));
                    this.writeFilePart(baseFile, xmlEvent.asStartElement(), eventReader, ++fileElemNo, elemsBetweenOrAfterLastFileElem);
                    continue;
                }
                if (fileElemNo <= 0) continue;
                elemsBetweenOrAfterLastFileElem.add(xmlEvent);
            }
            catch (XMLStreamException e) {
                throw new OkapiBadStepInputException(e);
            }
        }
        return event;
    }

    private static boolean isFileStart(XMLEvent xmlEvent) {
        return xmlEvent.getEventType() == 1 && xmlEvent.asStartElement().getName().getLocalPart().equals("file");
    }

    private static boolean isBodyStart(XMLEvent xmlEvent) {
        return xmlEvent.getEventType() == 1 && xmlEvent.asStartElement().getName().getLocalPart().equals("body");
    }

    private static boolean isFileEnd(XMLEvent xmlEvent) {
        return xmlEvent.getEventType() == 2 && xmlEvent.asEndElement().getName().getLocalPart().equals("file");
    }

    private static boolean isBodyEnd(XMLEvent xmlEvent) {
        return xmlEvent.getEventType() == 2 && xmlEvent.asEndElement().getName().getLocalPart().equals("body");
    }

    private XMLEventReader initiateReader(BOMNewlineEncodingDetector detector, String encoding, InputStream inputStream) {
        XMLEventReader eventReader;
        try {
            if (detector.isAutodetected()) {
                eventReader = this.inputFactory.createXMLEventReader(inputStream, encoding);
            } else {
                this.logger.info("Encoding could not be auto-detected. Using default encoding: {}", (Object)encoding);
                eventReader = this.inputFactory.createXMLEventReader(inputStream);
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiBadStepInputException(e);
        }
        return eventReader;
    }

    private String getBaseFilename(String fileName, String fileMarker) {
        int index = fileName.lastIndexOf(fileMarker);
        if (index == -1) {
            return null;
        }
        return fileName.substring(0, index);
    }

    private void writeFilePart(BaseXliffFile xliffFile, StartElement startFileEvent, XMLEventReader eventReader, int pFileElemIndex, List<XMLEvent> pTempElems) throws XMLStreamException {
        Attribute a = startFileEvent.getAttributeByName(new QName("original"));
        boolean isContinuation = false;
        String originalFileName = "";
        if (a != null) {
            originalFileName = a.getValue();
        } else {
            this.logger.warn("Missing 'original' attribute on <file>");
        }
        if (originalFileName.trim().isEmpty() || !originalFileName.equals(xliffFile.currentFileName)) {
            xliffFile.writeFileEnd();
            xliffFile.currentFileName = originalFileName;
            this.writeFileStart(xliffFile, startFileEvent, pFileElemIndex, pTempElems);
        } else {
            isContinuation = true;
            XMLEvent p = eventReader.nextEvent();
            while (p != null && !XliffJoinerStep.isBodyStart(p)) {
                p = eventReader.nextEvent();
            }
        }
        while (eventReader.hasNext()) {
            XMLEvent xmlEvent = eventReader.nextEvent();
            if (XliffJoinerStep.isBodyEnd(xmlEvent)) {
                if (isContinuation) continue;
                xliffFile.fileEndEvents.add(xmlEvent);
                continue;
            }
            if (XliffJoinerStep.isFileEnd(xmlEvent)) {
                if (!isContinuation) {
                    xliffFile.fileEndEvents.add(xmlEvent);
                }
                return;
            }
            xliffFile.write(xmlEvent);
        }
    }

    private void writeFileStart(BaseXliffFile xliffFile, StartElement startFileEvent, int pFileElemIndex, List<XMLEvent> pTempElems) throws XMLStreamException {
        if (pFileElemIndex > 1) {
            for (XMLEvent tempElem : pTempElems) {
                xliffFile.write(tempElem);
            }
            pTempElems.clear();
        }
        xliffFile.write(startFileEvent);
    }

    private class BaseXliffFile {
        private List<XMLEvent> firstFileTempElems = new ArrayList<XMLEvent>();
        private List<String> filesUsed = new ArrayList<String>();
        private int fileCount;
        private XMLEventWriter eventWriter = null;
        private String currentFileName = "";
        private List<XMLEvent> fileEndEvents = new ArrayList<XMLEvent>();

        private BaseXliffFile() {
        }

        void write(XMLEvent event) throws XMLStreamException {
            this.eventWriter.add(event);
        }

        void initiateWriter(String pOutputFileUri, String pEncoding, boolean pHasUTF8BOM) {
            try {
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pOutputFileUri), pEncoding));
                Util.writeBOMIfNeeded(bw, pHasUTF8BOM, pEncoding);
                this.eventWriter = XliffJoinerStep.this.outputFactory.createXMLEventWriter(bw);
            }
            catch (UnsupportedEncodingException e) {
                throw new OkapiUnsupportedEncodingException(e);
            }
            catch (FileNotFoundException e) {
                throw new OkapiFileNotFoundException(e);
            }
            catch (XMLStreamException e) {
                throw new OkapiBadStepInputException(e);
            }
        }

        void writeAndClose() throws XMLStreamException {
            this.writeFileEnd();
            if (this.eventWriter != null) {
                for (XMLEvent ev : this.firstFileTempElems) {
                    this.write(ev);
                }
                this.eventWriter.flush();
                this.eventWriter.close();
            }
        }

        void writeFileEnd() throws XMLStreamException {
            if (this.currentFileName.isEmpty() || this.fileEndEvents.isEmpty()) {
                return;
            }
            for (XMLEvent e : this.fileEndEvents) {
                this.write(e);
            }
            this.fileEndEvents.clear();
        }
    }
}

