/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xliff2.XLIFF2OkpToX2Converter;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFF2FilterWriter
implements IFilterWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Output outputChoice;
    private File outputFile = null;
    private OutputStreamWriter writer;
    private Charset encoding;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private XLIFFWriter xliffToolkitWriter = null;
    private XLIFF2OkpToX2Converter converter = new XLIFF2OkpToX2Converter();

    public XLIFF2FilterWriter() {
        this.outputChoice = Output.NONE;
        this.encoding = StandardCharsets.UTF_8;
    }

    @Override
    public String getName() {
        return "XLIFF2FilterWriter";
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.targetLocale = locale;
        this.encoding = Charset.forName(defaultEncoding);
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.xliffToolkitWriter = new XLIFFWriter();
        this.outputFile = new File(path);
        this.outputChoice = Output.PATH;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.xliffToolkitWriter = new XLIFFWriter();
        this.writer = new OutputStreamWriter(output, this.encoding);
        this.outputChoice = Output.STREAM;
    }

    @Override
    public net.sf.okapi.common.Event handleEvent(net.sf.okapi.common.Event event) {
        Event event1;
        if (this.outputChoice == Output.NONE) {
            throw new RuntimeException("Output has not been set. Use setOutput().");
        }
        List<Event> xliff2Events = this.converter.handleEvent(event, this);
        for (Event xliff2Event : xliff2Events) {
            this.xliffToolkitWriter.writeEvent(xliff2Event);
        }
        if (!xliff2Events.isEmpty() && (event1 = xliff2Events.get(xliff2Events.size() - 1)).getType() == EventType.END_DOCUMENT) {
            this.close();
        }
        return event;
    }

    @Override
    public void close() {
        if (this.xliffToolkitWriter != null) {
            this.xliffToolkitWriter.close();
            this.xliffToolkitWriter = null;
        }
        this.outputFile = null;
        this.outputChoice = Output.NONE;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void cancel() {
        if (this.xliffToolkitWriter != null) {
            this.xliffToolkitWriter.close();
            this.xliffToolkitWriter = null;
        }
        this.outputChoice = Output.NONE;
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    void initializeWriter(LocaleId sourceLang) {
        this.sourceLocale = sourceLang;
        String target = this.targetLocale != null ? this.targetLocale.toString() : null;
        switch (this.outputChoice) {
            case PATH: {
                this.xliffToolkitWriter.create(this.outputFile, this.sourceLocale.toString(), target);
                break;
            }
            case STREAM: {
                this.xliffToolkitWriter.create(this.writer, this.sourceLocale.toString(), target);
                break;
            }
            case NONE: {
                this.logger.error("No output set for XLIFF 2 to be written to");
                throw new RuntimeException("No output set for XLIFF 2 to be written to");
            }
        }
    }

    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    static enum Output {
        NONE,
        PATH,
        STREAM;

    }
}

