/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.xini.GroupType;
import net.sf.okapi.filters.xini.InlineCodeTransformer;
import net.sf.okapi.filters.xini.Parameters;
import net.sf.okapi.filters.xini.XINIProperties;
import net.sf.okapi.filters.xini.XINIWriter;
import net.sf.okapi.filters.xini.jaxb.Element;
import net.sf.okapi.filters.xini.jaxb.Field;
import net.sf.okapi.filters.xini.jaxb.INITD;
import net.sf.okapi.filters.xini.jaxb.INITR;
import net.sf.okapi.filters.xini.jaxb.INITable;
import net.sf.okapi.filters.xini.jaxb.Page;
import net.sf.okapi.filters.xini.jaxb.Seg;
import net.sf.okapi.filters.xini.jaxb.TD;
import net.sf.okapi.filters.xini.jaxb.TR;
import net.sf.okapi.filters.xini.jaxb.Table;
import net.sf.okapi.filters.xini.jaxb.TextContent;
import net.sf.okapi.filters.xini.jaxb.Xini;

public class XINIReader {
    private Xini xini;
    private InputStream xiniStream;
    private URI xiniFilename;
    private IdGenerator idGen = new IdGenerator(null);
    private Parameters params;
    private InlineCodeTransformer transformer = new InlineCodeTransformer();

    public XINIReader() {
    }

    public XINIReader(Parameters params) {
        this();
        this.params = params;
    }

    public void open(RawDocument input) {
        this.xiniStream = input.getStream();
        this.xiniFilename = input.getInputURI();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)Xini.class.getPackage().getName());
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement jaxbXini = (JAXBElement)u.unmarshal(this.xiniStream);
            this.xini = (Xini)jaxbXini.getValue();
        }
        catch (JAXBException e) {
            throw new OkapiException(e);
        }
    }

    public void close() {
        try {
            if (this.xiniStream != null) {
                this.xiniStream.close();
                this.xiniStream = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public LinkedList<Event> getFilterEvents() {
        LinkedList<Event> events = new LinkedList<Event>();
        String xiniName = null;
        if (this.xiniFilename != null) {
            xiniName = this.xiniFilename.getPath();
        }
        StartDocument startDoc = new StartDocument(xiniName);
        startDoc.setFilterWriter(new XINIWriter(this.params));
        startDoc.setType("text/x-xini");
        startDoc.setMimeType("text/x-xini");
        startDoc.setMultilingual(false);
        startDoc.setName(xiniName);
        startDoc = this.processXini(startDoc);
        events.add(new Event(EventType.START_DOCUMENT, startDoc));
        if (!Util.isEmpty(this.params.getSimplifierRules())) {
            Event cs = FilterUtil.createCodeSimplifierEvent(this.params.getSimplifierRules());
            events.add(cs);
        }
        for (Page page : this.xini.getMain().getPage()) {
            events.addAll(this.processPage(page));
        }
        Ending ending = new Ending(this.idGen.createId());
        events.add(new Event(EventType.END_DOCUMENT, ending));
        return events;
    }

    private StartDocument processXini(StartDocument startDoc) {
        if (this.xini.getSourceLanguage() != null) {
            startDoc.setProperty(new Property(XINIProperties.SOURCE_LANGUAGE.value(), this.xini.getSourceLanguage()));
        }
        if (this.xini.getTargetLanguages() != null) {
            String languagesString = "";
            for (String targetLanguage : this.xini.getTargetLanguages().getLanguage()) {
                languagesString = languagesString + targetLanguage + ",";
            }
            startDoc.setProperty(new Property(XINIProperties.TARGET_LANGUAGES.value(), languagesString));
        }
        return startDoc;
    }

    private LinkedList<Event> processPage(Page page) {
        LinkedList<Event> events = new LinkedList<Event>();
        StartGroup startGroup = new StartGroup(null, this.idGen.createId());
        startGroup.setType(GroupType.PAGE.value());
        int pageId = page.getPageID();
        startGroup.setName(page.getPageName());
        startGroup.setProperty(new Property(XINIProperties.PAGE_ID.value(), pageId + ""));
        startGroup.setProperty(new Property(XINIProperties.CONTEXT_INFORMATION_URL.value(), page.getContextInformationURL()));
        events.add(new Event(EventType.START_GROUP, startGroup));
        if (page.getElements() != null) {
            for (Element element : page.getElements().getElement()) {
                events.addAll(this.processElement(element));
            }
        }
        Ending ending = new Ending(this.idGen.createId());
        events.add(new Event(EventType.END_GROUP, ending));
        return events;
    }

    private LinkedList<Event> processElement(Element element) {
        LinkedList<Event> events = new LinkedList<Event>();
        int elementId = element.getElementID();
        StartGroup startGroup = new StartGroup(null, this.idGen.createId());
        startGroup.setType(GroupType.ELEMENT.value());
        startGroup.setProperty(new Property(XINIProperties.ELEMENT_ID.value(), elementId + ""));
        if (element.getCustomerTextID() != null) {
            startGroup.setProperty(new Property(XINIProperties.ELEMENT_CUSTOMER_TEXT_ID.value(), element.getCustomerTextID()));
        }
        if (element.getSize() != null) {
            startGroup.setProperty(new Property(XINIProperties.ELEMENT_SIZE.value(), element.getSize() + ""));
        }
        if (element.isAlphaList() != null) {
            startGroup.setProperty(new Property(XINIProperties.ELEMENT_ALPHA_LIST.value(), element.isAlphaList().toString()));
        }
        if (element.getElementType() != null) {
            startGroup.setProperty(new Property(XINIProperties.ELEMENT_ELEMENT_TYPE.value(), element.getElementType().value()));
        }
        if (element.getRawSourceBeforeElement() != null) {
            startGroup.setProperty(new Property(XINIProperties.ELEMENT_RAW_SOURCE_BEFORE_ELEMENT.value(), element.getRawSourceBeforeElement()));
        }
        if (element.getRawSourceAfterElement() != null) {
            startGroup.setProperty(new Property(XINIProperties.ELEMENT_RAW_SOURCE_AFTER_ELEMENT.value(), element.getRawSourceAfterElement()));
        }
        if (element.getLabel() != null) {
            startGroup.setProperty(new Property(XINIProperties.ELEMENT_LABEL.value(), element.getLabel()));
        }
        if (element.getStyle() != null) {
            startGroup.setProperty(new Property(XINIProperties.ELEMENT_STYLE.value(), element.getStyle()));
        }
        events.add(new Event(EventType.START_GROUP, startGroup));
        Element.ElementContent elContent = element.getElementContent();
        events.addAll(this.processElementContent(elContent));
        Ending ending = new Ending(this.idGen.createId());
        events.add(new Event(EventType.END_GROUP, ending));
        return events;
    }

    private LinkedList<Event> processElementContent(Element.ElementContent elContent) {
        LinkedList<Event> events = new LinkedList<Event>();
        if (elContent.getFields() != null) {
            StartGroup startFieldGroup = new StartGroup(null, this.idGen.createId());
            startFieldGroup.setType(GroupType.FIELDS.value());
            events.add(new Event(EventType.START_GROUP, startFieldGroup));
            for (Field field : elContent.getFields().getField()) {
                events.addAll(this.processField(field));
            }
            Ending ending = new Ending(this.idGen.createId());
            events.add(new Event(EventType.END_GROUP, ending));
        } else if (elContent.getTable() != null) {
            events.addAll(this.processTable(elContent.getTable()));
        } else if (elContent.getINITable() != null) {
            events.addAll(this.processINITable(elContent.getINITable()));
        }
        return events;
    }

    private LinkedList<Event> processTable(Table table) {
        LinkedList<Event> events = new LinkedList<Event>();
        StartGroup startTableGroup = new StartGroup(null, this.idGen.createId());
        startTableGroup.setType(GroupType.TABLE.value());
        events.add(new Event(EventType.START_GROUP, startTableGroup));
        for (TR tr : table.getTR()) {
            StartGroup startTrGroup = new StartGroup(null, this.idGen.createId());
            startTrGroup.setType(GroupType.TR.value());
            events.add(new Event(EventType.START_GROUP, startTrGroup));
            for (TD td : tr.getTD()) {
                StartGroup startTdGroup = new StartGroup(null, this.idGen.createId());
                startTdGroup.setType(GroupType.TD.value());
                if (td.getCustomerTextID() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.TABLE_CUSTOMER_TEXT_ID.value(), td.getCustomerTextID()));
                }
                if (td.getEmptySegmentsFlags() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.TABLE_EMPTY_SEGMENTS_FLAGS.value(), td.getEmptySegmentsFlags()));
                }
                if (td.getExternalID() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.TABLE_EXTERNAL_ID.value(), td.getExternalID()));
                }
                if (td.getLabel() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.TABLE_LABEL.value(), td.getLabel()));
                }
                if (td.isNoContent() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.TABLE_NO_CONTENT.value(), td.isNoContent().toString()));
                }
                events.add(new Event(EventType.START_GROUP, startTdGroup));
                events.addAll(this.processSegments(td.getSeg()));
                Ending ending = new Ending(this.idGen.createId());
                events.add(new Event(EventType.END_GROUP, ending));
            }
            Ending ending = new Ending(this.idGen.createId());
            events.add(new Event(EventType.END_GROUP, ending));
        }
        Ending ending = new Ending(this.idGen.createId());
        events.add(new Event(EventType.END_GROUP, ending));
        return events;
    }

    private LinkedList<Event> processINITable(INITable table) {
        LinkedList<Event> events = new LinkedList<Event>();
        StartGroup startTableGroup = new StartGroup(null, this.idGen.createId());
        startTableGroup.setType(GroupType.INITABLE.value());
        events.add(new Event(EventType.START_GROUP, startTableGroup));
        for (INITR tr : table.getTR()) {
            StartGroup startTrGroup = new StartGroup(null, this.idGen.createId());
            startTrGroup.setType(GroupType.INITR.value());
            events.add(new Event(EventType.START_GROUP, startTrGroup));
            for (INITD td : tr.getTD()) {
                StartGroup startTdGroup = new StartGroup(null, this.idGen.createId());
                startTdGroup.setType(GroupType.INITD.value());
                if (td.getCustomerTextID() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.INITABLE_CUSTOMER_TEXT_ID.value(), td.getCustomerTextID()));
                }
                if (td.getEmptySegmentsFlags() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.INITABLE_EMPTY_SEGMENTS_FLAGS.value(), td.getEmptySegmentsFlags()));
                }
                if (td.getExternalID() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.INITABLE_EXTERNAL_ID.value(), td.getExternalID()));
                }
                if (td.getLabel() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.INITABLE_LABEL.value(), td.getLabel()));
                }
                if (td.isNoContent() != null) {
                    startTdGroup.setProperty(new Property(XINIProperties.INITABLE_NO_CONTENT.value(), td.isNoContent().toString()));
                }
                events.add(new Event(EventType.START_GROUP, startTdGroup));
                events.addAll(this.processSegments(td.getSeg()));
                Ending ending = new Ending(this.idGen.createId());
                events.add(new Event(EventType.END_GROUP, ending));
            }
            Ending ending = new Ending(this.idGen.createId());
            events.add(new Event(EventType.END_GROUP, ending));
        }
        Ending ending = new Ending(this.idGen.createId());
        events.add(new Event(EventType.END_GROUP, ending));
        return events;
    }

    private LinkedList<Event> processField(Field field) {
        LinkedList<Event> events = new LinkedList<Event>();
        int fieldId = field.getFieldID();
        StartGroup startGroup = new StartGroup(null, this.idGen.createId());
        startGroup.setType(GroupType.FIELD.value());
        startGroup.setProperty(new Property(XINIProperties.FIELD_ID.value(), fieldId + ""));
        if (field.getCustomerTextID() != null) {
            startGroup.setProperty(new Property(XINIProperties.FIELD_CUSTOMER_TEXT_ID.value(), field.getCustomerTextID()));
        }
        if (field.getEmptySegmentsFlags() != null) {
            startGroup.setProperty(new Property(XINIProperties.FIELD_EMPTY_SEGMENTS_FLAGS.value(), field.getEmptySegmentsFlags()));
        }
        if (field.getExternalID() != null) {
            startGroup.setProperty(new Property(XINIProperties.FIELD_EXTERNAL_ID.value(), field.getExternalID()));
        }
        if (field.getLabel() != null) {
            startGroup.setProperty(new Property(XINIProperties.FIELD_LABEL.value(), field.getLabel()));
        }
        if (field.getRawSourceAfterField() != null) {
            startGroup.setProperty(new Property(XINIProperties.FIELD_RAW_SOURCE_AFTER_FIELD.value(), field.getRawSourceAfterField()));
        }
        if (field.getRawSourceBeforeField() != null) {
            startGroup.setProperty(new Property(XINIProperties.FIELD_RAW_SOURCE_BEFORE_FIELD.value(), field.getRawSourceBeforeField()));
        }
        if (field.isNoContent() != null) {
            startGroup.setProperty(new Property(XINIProperties.FIELD_NO_CONTENT.value(), field.isNoContent().toString()));
        }
        events.add(new Event(EventType.START_GROUP, startGroup));
        events.addAll(this.processSegments(field.getSeg()));
        Ending ending = new Ending(this.idGen.createId());
        events.add(new Event(EventType.END_GROUP, ending));
        return events;
    }

    private LinkedList<Event> processSegments(List<Seg> segments) {
        LinkedList<Event> events = new LinkedList<Event>();
        ITextUnit tu = null;
        TextContainer tc = null;
        Integer previousOriginalSegmentId = null;
        Boolean emptyTranslation = null;
        for (TextContent textContent : segments) {
            boolean hasSameOrigSegIdAsPreviousSegId;
            if (!(textContent instanceof Seg)) continue;
            Seg seg = (Seg)textContent;
            TextFragment tf = this.processSegment(seg);
            Integer origSegId = seg.getSegmentIDBeforeSegmentation();
            boolean isUnsegmentedXini = origSegId == null;
            boolean bl = hasSameOrigSegIdAsPreviousSegId = origSegId != null && origSegId.equals(previousOriginalSegmentId);
            if (isUnsegmentedXini || !hasSameOrigSegIdAsPreviousSegId) {
                if (seg.isEmptyTranslation() != null && seg.isEmptyTranslation().booleanValue()) {
                    emptyTranslation = seg.isEmptyTranslation();
                }
                if (tu != null) {
                    events.add(new Event(EventType.TEXT_UNIT, tu));
                }
                tu = this.createNewTextUnit(seg);
                tc = new TextContainer(tf);
                tu.setSource(tc);
            } else {
                tc.getSegments().append(tf);
                if (emptyTranslation != null && emptyTranslation.booleanValue()) {
                    emptyTranslation = seg.isEmptyTranslation() != null && seg.isEmptyTranslation() != false;
                }
            }
            if (emptyTranslation != null) {
                tu.setProperty(new Property(XINIProperties.EMPTY_TRANSLATION.value(), emptyTranslation.toString()));
            }
            previousOriginalSegmentId = origSegId;
        }
        if (tu != null) {
            events.add(new Event(EventType.TEXT_UNIT, tu));
        }
        return events;
    }

    private ITextUnit createNewTextUnit(Seg seg) {
        TextUnit tu = new TextUnit(this.idGen.createId());
        int segId = seg.getSegmentIDBeforeSegmentation() != null ? seg.getSegmentIDBeforeSegmentation().intValue() : seg.getSegID();
        tu.setProperty(new Property(XINIProperties.SEGMENT_ID.value(), segId + ""));
        return tu;
    }

    private TextFragment processSegment(Seg xiniSeg) {
        TextFragment fragment = new TextFragment();
        String leadingSpacer = xiniSeg.getLeadingSpacer();
        if (leadingSpacer != null) {
            fragment.append(leadingSpacer);
        }
        fragment.insert(-1, this.transformer.serializeTextPartsForFilter(xiniSeg.getContent()), true);
        if (xiniSeg.getTrailingSpacer() != null) {
            fragment.append(xiniSeg.getTrailingSpacer());
        }
        return fragment;
    }
}

