/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.php;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.CodeFinderPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider,
ISimplifierRulesParameters {
    static final String USECODEFINDER = "useCodeFinder";
    static final String CODEFINDERRULES = "codeFinderRules";
    static final String USEDIRECTIVES = "useDirectives";
    static final String EXTRACTOUTSIDEDIRECTIVES = "extractOutsideDirectives";
    private InlineCodeFinder codeFinder;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderRules() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderRules(String codeFinderRules) {
        this.codeFinder.fromString(codeFinderRules);
    }

    public boolean getUseDirectives() {
        return this.getBoolean(USEDIRECTIVES);
    }

    public void setUseDirectives(boolean useDirectives) {
        this.setBoolean(USEDIRECTIVES, useDirectives);
    }

    public boolean getExtractOutsideDirectives() {
        return this.getBoolean(EXTRACTOUTSIDEDIRECTIVES);
    }

    public void setExtractOutsideDirectives(boolean extractOutsideDirectives) {
        this.setBoolean(EXTRACTOUTSIDEDIRECTIVES, extractOutsideDirectives);
    }

    @Override
    public void reset() {
        super.reset();
        this.setUseDirectives(true);
        this.setExtractOutsideDirectives(true);
        this.setUseCodeFinder(true);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("text <br/> text \\n text <a att='val'> text [VAR1] text\n{VAR2} text");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("<[\\w!?/].*?>");
        this.codeFinder.addRule("\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinder.addRule("(\\w[-._\\w]*\\w@\\w[-._\\w]*\\w\\.\\w{2,3})");
        this.codeFinder.addRule("[\\[{][\\w_$]+?[}\\]]");
        this.setSimplifierRules(null);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USEDIRECTIVES, "Use localization directives", null);
        desc.add(EXTRACTOUTSIDEDIRECTIVES, "Extract outside the scope of the directives", null);
        desc.add(USECODEFINDER, "Has inline codes as defined below:", null);
        desc.add(CODEFINDERRULES, null, "Rules for inline codes");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("PHP Filter Parameters", true, false);
        CheckboxPart cbp1 = desc.addCheckboxPart(paramDesc.get(USEDIRECTIVES));
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(EXTRACTOUTSIDEDIRECTIVES));
        cbp2.setMasterPart(cbp1, true);
        cbp1 = desc.addCheckboxPart(paramDesc.get(USECODEFINDER));
        CodeFinderPart cfp = desc.addCodeFinderPart(paramDesc.get(CODEFINDERRULES));
        cfp.setMasterPart(cbp1, true);
        return desc;
    }
}

