/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Relationships;

class Presentation {
    private XMLInputFactory factory;
    private Relationships rels;
    private static final String PRESENTATION = "presentation";
    private static final String SLIDE_ID = "sldId";
    private static final String ID = "id";
    private QName slideId;
    private QName id;
    private List<String> slidePartNames = new ArrayList<String>();

    Presentation(XMLInputFactory factory, Relationships rels) {
        this.factory = factory;
        this.rels = rels;
    }

    List<String> getSlidePartNames() {
        return this.slidePartNames;
    }

    void parseFromXML(Reader reader) throws XMLStreamException {
        XMLEventReader eventReader = this.factory.createXMLEventReader(reader);
        while (eventReader.hasNext()) {
            Attribute id;
            XMLEvent e = eventReader.nextEvent();
            if (!e.isStartElement()) continue;
            StartElement el = e.asStartElement();
            if (el.getName().getLocalPart().equals(PRESENTATION)) {
                this.qualifyNames(el);
                continue;
            }
            if (!el.getName().equals(this.slideId) || (id = el.getAttributeByName(this.id)) == null) continue;
            Relationships.Rel rel = this.rels.getRelById(id.getValue());
            if (rel == null) {
                throw new IllegalStateException("Presentation refers to non-existent slide ID " + id.getValue());
            }
            this.slidePartNames.add(rel.target);
        }
    }

    private void qualifyNames(StartElement startElement) {
        this.slideId = new QName(startElement.getNamespaceURI("p"), SLIDE_ID, "p");
        this.id = new QName(startElement.getNamespaceURI("r"), ID, "r");
    }
}

