/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.Namespaces;

public class ExcelStyles {
    private List<Fill> fills = new ArrayList<Fill>();
    private List<CellStyle> cellStyles = new ArrayList<CellStyle>();
    static final QName FILL = Namespaces.SpreadsheetML.getQName("fill");
    static final QName FGCOLOR = Namespaces.SpreadsheetML.getQName("fgColor");
    static final QName RGB_ATTR = new QName("rgb");
    static final QName CELLXFS = Namespaces.SpreadsheetML.getQName("cellXfs");
    static final QName XF = Namespaces.SpreadsheetML.getQName("xf");
    static final QName FILLID_ATTR = new QName("fillId");

    public List<Fill> getFills() {
        return this.fills;
    }

    public List<CellStyle> getCellStyles() {
        return this.cellStyles;
    }

    public CellStyle getCellStyle(int styleIndex) {
        if (styleIndex < 0 || styleIndex >= this.cellStyles.size()) {
            throw new IllegalArgumentException("Invalid style index: " + styleIndex);
        }
        return this.cellStyles.get(styleIndex);
    }

    void parse(XMLEventReader reader) throws IOException, XMLStreamException {
        boolean inFill = false;
        boolean inCellXfs = false;
        Fill currentFill = null;
        while (reader.hasNext()) {
            XMLEvent el;
            XMLEvent e = reader.nextEvent();
            if (e.isStartElement()) {
                int fillId;
                el = e.asStartElement();
                if (el.getName().equals(FILL)) {
                    inFill = true;
                    currentFill = new EmptyFill();
                    continue;
                }
                if (el.getName().equals(FGCOLOR) && inFill) {
                    Attribute rgbAttr = el.getAttributeByName(RGB_ATTR);
                    if (rgbAttr == null) continue;
                    currentFill = new PatternFill(rgbAttr.getValue());
                    continue;
                }
                if (el.getName().equals(CELLXFS)) {
                    inCellXfs = true;
                    continue;
                }
                if (!el.getName().equals(XF) || !inCellXfs) continue;
                int n = fillId = el.getAttributeByName(FILLID_ATTR) != null ? Integer.parseInt(el.getAttributeByName(FILLID_ATTR).getValue()) : 0;
                if (fillId < 0 || fillId >= this.fills.size()) {
                    throw new OkapiBadFilterInputException("Invalid fillId reference in styles: " + fillId);
                }
                this.cellStyles.add(new CellStyle(this.fills.get(fillId)));
                continue;
            }
            if (!e.isEndElement()) continue;
            el = e.asEndElement();
            if (el.getName().equals(FILL)) {
                inFill = false;
                this.fills.add(currentFill);
                continue;
            }
            if (!el.getName().equals(CELLXFS)) continue;
            inCellXfs = false;
        }
        reader.close();
    }

    static class PatternFill
    implements Fill {
        private String fgColor;

        PatternFill(String fgColor) {
            this.fgColor = fgColor;
        }

        @Override
        public boolean matchesColor(String argbColor) {
            return this.fgColor.equals(argbColor);
        }

        public String toString() {
            return "PatternFill(" + this.fgColor + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof PatternFill)) {
                return false;
            }
            return Objects.equals(this.fgColor, ((PatternFill)o).fgColor);
        }

        public int hashCode() {
            return Objects.hash(this.fgColor);
        }
    }

    static class EmptyFill
    implements Fill {
        EmptyFill() {
        }

        @Override
        public boolean matchesColor(String argbColor) {
            return false;
        }

        public String toString() {
            return "EmptyFill";
        }

        public boolean equals(Object o) {
            return o != null && o instanceof EmptyFill;
        }

        public int hashCode() {
            return Objects.hash(false);
        }
    }

    public static class CellStyle {
        Fill fill;

        CellStyle(Fill fill) {
            this.fill = fill;
        }

        public String toString() {
            return "CellStyle(" + this.fill + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof CellStyle)) {
                return false;
            }
            return Objects.equals(this.fill, ((CellStyle)o).fill);
        }

        public int hashCode() {
            return Objects.hash(this.fill);
        }
    }

    public static interface Fill {
        public boolean matchesColor(String var1);
    }
}

