/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.multiparsers;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.filters.multiparsers.CsvEncoder;
import net.sf.okapi.filters.multiparsers.IParser;
import net.sf.okapi.filters.multiparsers.Parameters;
import net.sf.okapi.filters.multiparsers.Token;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CsvParser
implements IParser {
    public static final String LB_MARK = "@#$";
    public static final String MIME_TYPE = "text/csv";
    private Parameters params;
    private IFilterConfigurationMapper fcMapper;
    private Map<Integer, String> formatCols;
    private Map<String, IFilter> subFilterCols;
    private int curEntry = -1;
    private CSVParser parser = null;
    private Iterator<CSVRecord> recIter = null;
    private List<Token> entries = null;
    private String noExtractCols;
    private CsvEncoder encoder = new CsvEncoder();
    private long firstRow = 1L;
    private long configRow = -1L;

    public CsvParser(String path, Parameters params, IFilterConfigurationMapper fcMapper) {
        try {
            this.params = params;
            this.fcMapper = fcMapper;
            this.parser = new CSVParser((Reader)Files.newBufferedReader(Paths.get(path, new String[0])), CSVFormat.DEFAULT);
            this.recIter = this.parser.iterator();
            this.entries = new ArrayList<Token>();
            this.noExtractCols = null;
            this.configRow = -1L;
            if (params != null) {
                if (params.getCsvAutoDetectColumnTypes()) {
                    this.configRow = params.getCsvAutoDetectColumnTypesRow();
                    this.formatCols = new HashMap<Integer, String>();
                } else {
                    String tmp = params.getCsvNoExtractCols();
                    if (!Util.isEmpty(tmp)) {
                        tmp = ListUtil.intListAsString(ListUtil.stringAsIntList(tmp));
                        this.noExtractCols = "," + tmp + ",";
                    }
                    this.firstRow = params.getCsvStartingRow();
                    this.initializeColumnTypes();
                }
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not open: " + path, e);
        }
    }

    @Override
    public void close() {
        if (this.parser != null) {
            try {
                this.parser.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.parser = null;
            this.recIter = null;
            this.curEntry = -1;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.recIter == null) {
            return false;
        }
        if (this.curEntry > -1) {
            ++this.curEntry;
            if (this.curEntry < this.entries.size()) {
                return true;
            }
        }
        return this.recIter.hasNext();
    }

    @Override
    public Token next() {
        try {
            if (this.curEntry == -1 || this.curEntry >= this.entries.size()) {
                CSVRecord rec = this.recIter.next();
                this.entries.clear();
                boolean inConfigRow = false;
                for (int i = 0; i < rec.size(); ++i) {
                    String linebreak;
                    boolean isText = true;
                    if (inConfigRow) {
                        isText = false;
                    } else if (this.noExtractCols != null) {
                        boolean bl = isText = !this.noExtractCols.contains("," + i + ",");
                    }
                    if (Util.isEmpty(rec.get(i))) {
                        isText = false;
                    }
                    if (this.configRow > -1L) {
                        if (rec.getRecordNumber() == this.configRow) {
                            this.autoDetectConfiguration(rec);
                            this.configRow = -1L;
                            inConfigRow = true;
                        }
                        isText = false;
                    } else if (rec.getRecordNumber() < this.firstRow) {
                        isText = false;
                    }
                    String comma = i > 0 ? "," : "";
                    String string = linebreak = i == rec.size() - 1 ? "\n" : "";
                    if (isText) {
                        this.entries.add(new Token(comma + "\"", false, null));
                        String format = this.formatCols.get(i);
                        this.entries.add(new Token(rec.get(i), true, format));
                        if (format != null && format.startsWith("okf_markdown")) {
                            this.entries.add(new Token("\"@#$" + linebreak, false, null));
                            continue;
                        }
                        this.entries.add(new Token("\"" + linebreak, false, null));
                        continue;
                    }
                    this.entries.add(new Token(comma + "\"" + this.encoder.encode(rec.get(i), EncoderContext.SKELETON) + "\"" + linebreak, false, null));
                }
                this.curEntry = 0;
            }
            return this.entries.get(this.curEntry);
        }
        catch (Throwable e) {
            throw new OkapiIOException("Reading error: " + e.getMessage(), e);
        }
    }

    private void autoDetectConfiguration(CSVRecord rec) {
        this.noExtractCols = ",";
        this.formatCols.clear();
        for (int col = 0; col < rec.size(); ++col) {
            String value = rec.get(col).toLowerCase();
            if (value.equals("notrans")) {
                this.noExtractCols = this.noExtractCols + col + ",";
                continue;
            }
            if (value.equals("text")) continue;
            if (value.startsWith("okf_html") || value.startsWith("okf_markdown")) {
                this.formatCols.put(col, rec.get(col));
                continue;
            }
            throw new RuntimeException("Unexpected value in the auto-detection row: " + value);
        }
        if (this.noExtractCols.length() == 1) {
            this.noExtractCols = null;
        }
        this.initializeSubFilters();
    }

    private void initializeColumnTypes() {
        String tmp;
        this.formatCols = new HashMap<Integer, String>();
        if (this.params != null && !Util.isEmpty(tmp = this.params.getString("csvFormatCols"))) {
            List<String> cols = ListUtil.stringAsList(tmp);
            for (String col : cols) {
                int index;
                int p = col.indexOf(58);
                if (p == -1) {
                    throw new RuntimeException("Invalid syntax: " + col);
                }
                try {
                    index = Integer.parseInt(col.substring(0, p));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid index: " + col);
                }
                String format = col.substring(p + 1);
                this.formatCols.put(index, format);
            }
        }
        this.initializeSubFilters();
    }

    @Override
    public IFilter getSubFilter(String configId) {
        return this.subFilterCols.get(configId);
    }

    public void initializeSubFilters() {
        this.subFilterCols = new HashMap<String, IFilter>();
        if (this.formatCols == null) {
            return;
        }
        for (String configId : this.formatCols.values()) {
            if (this.fcMapper == null) {
                throw new RuntimeException("You must specify a filter configuration mapper for this filter.");
            }
            if (this.subFilterCols.containsKey(configId)) continue;
            IFilter sf = this.fcMapper.createFilter(configId);
            this.subFilterCols.put(configId, sf);
        }
    }
}

