/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.okapi.filters.mif.Statement;
import net.sf.okapi.filters.mif.Token;

final class FontTags {
    private static final String FONT = "Font";
    private static final String F_TAG = "FTag";
    private final Set<String> tags;

    FontTags() {
        this(new LinkedHashSet<String>());
    }

    FontTags(Set<String> tags) {
        this.tags = tags;
    }

    void fromCatalog(Statement statement) {
        this.tags.clear();
        this.tags.addAll(statement.statementsWith(FONT).stream().map(s -> s.statementsWith(F_TAG)).flatMap(Collection::stream).map(s -> s.firstTokenOf(Token.Type.LITERAL).toString()).collect(Collectors.toSet()));
    }

    Set<String> toInlineCodeFinderRules() {
        return this.tags.stream().map(t -> "<".concat((String)t).concat("\\>")).collect(Collectors.toSet());
    }
}

