/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;
import net.sf.okapi.filters.idml.StyleRanges;

class StoryChildElementsWriter {
    private final StyleRangeEventsGenerator styleRangeEventsGenerator;
    private StyleRanges currentStyleRanges;

    StoryChildElementsWriter(StyleRangeEventsGenerator styleRangeEventsGenerator) {
        this.styleRangeEventsGenerator = styleRangeEventsGenerator;
    }

    List<XMLEvent> write(List<StoryChildElement> storyChildElements) {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        for (StoryChildElement storyChildElement : storyChildElements) {
            if (!(storyChildElement instanceof StoryChildElement.StyledTextElement)) {
                if (null != this.currentStyleRanges) {
                    events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
                    events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeEnd());
                }
                events.addAll(storyChildElement.getEvents());
                if (null == this.currentStyleRanges) continue;
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeStart(this.currentStyleRanges));
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleRanges));
                continue;
            }
            if (null == this.currentStyleRanges) {
                this.currentStyleRanges = ((StoryChildElement.StyledTextElement)storyChildElement).getStyleRanges();
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeStart(this.currentStyleRanges));
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleRanges));
            }
            StyleRanges styleRanges = ((StoryChildElement.StyledTextElement)storyChildElement).getStyleRanges();
            if (!this.currentStyleRanges.getParagraphStyleRange().equals(styleRanges.getParagraphStyleRange())) {
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeEnd());
                this.currentStyleRanges = styleRanges;
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeStart(this.currentStyleRanges));
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleRanges));
                events.addAll(storyChildElement.getEvents());
                continue;
            }
            if (!this.currentStyleRanges.getCharacterStyleRange().equals(styleRanges.getCharacterStyleRange())) {
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
                this.currentStyleRanges = styleRanges;
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleRanges));
                events.addAll(storyChildElement.getEvents());
                continue;
            }
            events.addAll(storyChildElement.getEvents());
        }
        return events;
    }
}

