/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.GeometryPath;
import net.sf.okapi.filters.idml.Layer;
import net.sf.okapi.filters.idml.OrderingIdioms;
import net.sf.okapi.filters.idml.PathPoint;
import net.sf.okapi.filters.idml.Point;
import net.sf.okapi.filters.idml.Property;
import net.sf.okapi.filters.idml.SpreadItem;

class PasteboardItem {
    private static final double DEFAULT_COORDINATE = 5.0;
    private final SpreadItem.TextualSpreadItem textualSpreadItem;
    private final List<Point> anchorPoints;

    PasteboardItem(SpreadItem.TextualSpreadItem textualSpreadItem, List<Point> anchorPoints) {
        this.textualSpreadItem = textualSpreadItem;
        this.anchorPoints = anchorPoints;
    }

    static PasteboardItem fromTextualSpreadItemAndParentTransformations(SpreadItem.TextualSpreadItem spreadItem, Deque<OrderingIdioms.TransformationMatrix> transformationMatrices, XMLEventFactory eventFactory) {
        PasteboardItemBuilder pasteboardItemBuilder = new PasteboardItemBuilder();
        pasteboardItemBuilder.setSpreadItem(spreadItem);
        Property.PathGeometryProperty property = (Property.PathGeometryProperty)spreadItem.getProperties().stream().filter(p -> p instanceof Property.PathGeometryProperty).findFirst().orElseGet(() -> new Property.PathGeometryProperty(null, Collections.singletonList(new GeometryPath(null, null, Arrays.asList(new PathPoint.Default(new Point.Default(-5.0, -5.0), new Point.Default(-5.0, -5.0), new Point.Default(-5.0, -5.0), eventFactory), new PathPoint.Default(new Point.Default(-5.0, 5.0), new Point.Default(-5.0, 5.0), new Point.Default(-5.0, 5.0), eventFactory), new PathPoint.Default(new Point.Default(5.0, 5.0), new Point.Default(5.0, 5.0), new Point.Default(5.0, 5.0), eventFactory), new PathPoint.Default(new Point.Default(5.0, -5.0), new Point.Default(5.0, -5.0), new Point.Default(5.0, -5.0), eventFactory)), null, null)), null, null));
        property.getGeometryPaths().stream().map(gp -> gp.pathPoints()).flatMap(Collection::stream).forEach(pp -> pasteboardItemBuilder.addAnchorPoint(pp.anchor().transformedWith(transformationMatrices)));
        return pasteboardItemBuilder.build();
    }

    SpreadItem.TextualSpreadItem getTextualSpreadItem() {
        return this.textualSpreadItem;
    }

    List<Point> getAnchorPoints() {
        return this.anchorPoints;
    }

    Point getMinAnchorPointByDirection(OrderingIdioms.Direction direction) {
        Point.Comparator anchorPointComparator = new Point.Comparator(direction);
        return Collections.min(this.anchorPoints, anchorPointComparator);
    }

    static class VisibilityFilter {
        private static final String LAYER_DOES_NOT_EXIST = "Layer does not exist";
        private final List<Layer> layers;
        private final boolean extractHiddenLayers;

        VisibilityFilter(List<Layer> layers, boolean extractHiddenLayers) {
            this.layers = layers;
            this.extractHiddenLayers = extractHiddenLayers;
        }

        List<PasteboardItem> filterVisible(List<PasteboardItem> pasteboardItems) {
            ArrayList<PasteboardItem> visiblePasteboardItems = new ArrayList<PasteboardItem>(pasteboardItems.size());
            for (PasteboardItem pasteboardItem : pasteboardItems) {
                Layer layer = this.getLayerById(pasteboardItem.getTextualSpreadItem().getLayerId(), this.layers);
                if (!this.extractHiddenLayers && !layer.isVisible() || !pasteboardItem.getTextualSpreadItem().isVisible()) continue;
                visiblePasteboardItems.add(pasteboardItem);
            }
            return visiblePasteboardItems;
        }

        private Layer getLayerById(String layerId, List<Layer> layers) {
            for (Layer layer : layers) {
                if (!layerId.equals(layer.getId())) continue;
                return layer;
            }
            throw new IllegalStateException(LAYER_DOES_NOT_EXIST);
        }
    }

    static class PasteboardItemComparator
    implements Comparator<PasteboardItem> {
        private final OrderingIdioms.Direction direction;

        PasteboardItemComparator(OrderingIdioms.Direction direction) {
            this.direction = direction;
        }

        @Override
        public int compare(PasteboardItem pasteboardItem, PasteboardItem anotherPasteboardItem) {
            if (pasteboardItem.getAnchorPoints().isEmpty() && anotherPasteboardItem.getAnchorPoints().isEmpty()) {
                return 0;
            }
            if (pasteboardItem.getAnchorPoints().isEmpty()) {
                return -1;
            }
            if (anotherPasteboardItem.getAnchorPoints().isEmpty()) {
                return 1;
            }
            int result = Double.compare(pasteboardItem.getMinAnchorPointByDirection(this.direction).y(), anotherPasteboardItem.getMinAnchorPointByDirection(this.direction).y());
            if (0 != result) {
                return result;
            }
            if (OrderingIdioms.Direction.RIGHT_TO_LEFT == this.direction) {
                return Double.compare(anotherPasteboardItem.getMinAnchorPointByDirection(this.direction).x(), pasteboardItem.getMinAnchorPointByDirection(this.direction).x());
            }
            return Double.compare(pasteboardItem.getMinAnchorPointByDirection(this.direction).x(), anotherPasteboardItem.getMinAnchorPointByDirection(this.direction).x());
        }
    }

    static class PasteboardItemBuilder
    implements Builder<PasteboardItem> {
        private SpreadItem.TextualSpreadItem spreadItem;
        private List<Point> anchorPoints = new ArrayList<Point>();

        PasteboardItemBuilder() {
        }

        PasteboardItemBuilder setSpreadItem(SpreadItem.TextualSpreadItem spreadItem) {
            this.spreadItem = spreadItem;
            return this;
        }

        PasteboardItemBuilder addAnchorPoint(Point anchorPoint) {
            this.anchorPoints.add(anchorPoint);
            return this;
        }

        @Override
        public PasteboardItem build() {
            return new PasteboardItem(this.spreadItem, this.anchorPoints);
        }
    }
}

