/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.filters.idml.PasteboardItem;
import net.sf.okapi.filters.idml.Spread;
import net.sf.okapi.filters.idml.SpreadItem;
import net.sf.okapi.filters.idml.State;
import net.sf.okapi.filters.idml.TextPath;

class OrderingIdioms {
    private static final String UNEXPECTED_STORY_PART_NAME = "Unexpected story part name";
    private static final String STORY_PART_NAME_DOES_NOT_EXIST = "Story part name does not exist";
    private static String storyPartNameStart = "Stories/Story_";
    private static String storyPartNameEnd = ".xml";
    private static final String NO_VALUE = "n";

    OrderingIdioms() {
    }

    static List<PasteboardItem> getOrderedPasteboardItems(List<Spread> spreads, String direction, XMLEventFactory eventFactory) {
        ArrayList<PasteboardItem> pasteboardItems = new ArrayList<PasteboardItem>();
        LinkedList<TransformationMatrix> transformationMatrices = new LinkedList<TransformationMatrix>();
        List<Spread> sortedSpreads = OrderingIdioms.getSortedSpreads(spreads);
        for (Spread spread : sortedSpreads) {
            transformationMatrices.add(TransformationMatrix.fromString(spread.getTransformation()));
            List<PasteboardItem> pasteboardItemsPerSpread = OrderingIdioms.getOrderedPasteboardItems(spread.getSpreadItems(), transformationMatrices, eventFactory);
            OrderingIdioms.sortPasteboardItems(pasteboardItemsPerSpread, Direction.fromString(direction));
            pasteboardItems.addAll(pasteboardItemsPerSpread);
            transformationMatrices.removeLast();
        }
        return pasteboardItems;
    }

    private static List<Spread> getSortedSpreads(List<Spread> spreads) {
        ArrayList<Spread> sortedSpreads = new ArrayList<Spread>(spreads);
        sortedSpreads.sort(new Spread.SpreadComparator());
        return sortedSpreads;
    }

    private static List<PasteboardItem> getOrderedPasteboardItems(List<SpreadItem> spreadItems, Deque<TransformationMatrix> transformationMatrices, XMLEventFactory eventFactory) {
        ArrayList<PasteboardItem> pasteboardItems = new ArrayList<PasteboardItem>();
        for (SpreadItem spreadItem : spreadItems) {
            transformationMatrices.add(TransformationMatrix.fromString(spreadItem.getTransformation()));
            if (spreadItem instanceof SpreadItem.TextualSpreadItem) {
                pasteboardItems.add(PasteboardItem.fromTextualSpreadItemAndParentTransformations((SpreadItem.TextualSpreadItem)spreadItem, transformationMatrices, eventFactory));
                transformationMatrices.removeLast();
                continue;
            }
            if (spreadItem instanceof SpreadItem.MultiStateObject) {
                for (State state : ((SpreadItem.MultiStateObject)spreadItem).getStates()) {
                    if (!state.isActive()) continue;
                    pasteboardItems.addAll(OrderingIdioms.getOrderedPasteboardItems(state.getSpreadItems(), transformationMatrices, eventFactory));
                }
                transformationMatrices.removeLast();
                continue;
            }
            if (spreadItem instanceof SpreadItem.Group) {
                pasteboardItems.addAll(OrderingIdioms.getOrderedPasteboardItems(((SpreadItem.Group)spreadItem).getSpreadItems(), transformationMatrices, eventFactory));
                transformationMatrices.removeLast();
                continue;
            }
            if (!(spreadItem instanceof SpreadItem.TextBox)) continue;
            pasteboardItems.addAll(OrderingIdioms.getOrderedPasteboardItems(((SpreadItem.TextBox)spreadItem).getSpreadItems(), transformationMatrices, eventFactory));
            transformationMatrices.removeLast();
        }
        return pasteboardItems;
    }

    private static void sortPasteboardItems(List<PasteboardItem> pasteboardItems, Direction direction) {
        PasteboardItem.PasteboardItemComparator pasteboardItemComparator = new PasteboardItem.PasteboardItemComparator(direction);
        pasteboardItems.sort(pasteboardItemComparator);
    }

    static List<String> getOrderedStoryIds(List<PasteboardItem> pasteboardItems) {
        ArrayList<String> storyIds = new ArrayList<String>(pasteboardItems.size());
        for (PasteboardItem pasteboardItem : pasteboardItems) {
            if (pasteboardItem.getTextualSpreadItem() instanceof SpreadItem.TextFrame && NO_VALUE.equals(((SpreadItem.TextFrame)pasteboardItem.getTextualSpreadItem()).getPreviousTextFrameId())) {
                storyIds.add(((SpreadItem.TextFrame)pasteboardItem.getTextualSpreadItem()).getStoryId());
            }
            if (pasteboardItem.getTextualSpreadItem().getTextPaths().isEmpty()) continue;
            storyIds.addAll(OrderingIdioms.getTextPathsStoryIds(pasteboardItem.getTextualSpreadItem().getTextPaths()));
        }
        return storyIds;
    }

    private static List<String> getTextPathsStoryIds(List<TextPath> textPaths) {
        ArrayList<String> storyIds = new ArrayList<String>(textPaths.size());
        for (TextPath textPath : textPaths) {
            if (!NO_VALUE.equals(textPath.getPreviousTextFrameId())) continue;
            storyIds.add(textPath.getStoryId());
        }
        return storyIds;
    }

    static List<String> getOrderedStoryPartNames(List<String> storyPartNames, List<String> storyIds) {
        ArrayList<String> orderedStoryPartNames = new ArrayList<String>(storyIds.size());
        for (String storyId : storyIds) {
            orderedStoryPartNames.add(OrderingIdioms.getStoryPartNameByStoryId(storyPartNames, storyId));
        }
        return orderedStoryPartNames;
    }

    private static String getStoryPartNameByStoryId(List<String> storyPartNames, String storyId) {
        for (String storyPartName : storyPartNames) {
            int storyIdEndIndex = storyPartName.indexOf(storyPartNameEnd, storyPartNameStart.length());
            if (-1 == storyIdEndIndex) {
                throw new IllegalStateException(UNEXPECTED_STORY_PART_NAME);
            }
            if (!storyId.equals(storyPartName.substring(storyPartNameStart.length(), storyIdEndIndex))) continue;
            return storyPartName;
        }
        throw new IllegalStateException(STORY_PART_NAME_DOES_NOT_EXIST);
    }

    static enum Direction {
        LEFT_TO_RIGHT("LeftToRightDirection"),
        RIGHT_TO_LEFT("RightToLeftDirection");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        static Direction fromString(String string) {
            for (Direction direction : Direction.values()) {
                if (!direction.getValue().equals(string)) continue;
                return direction;
            }
            return LEFT_TO_RIGHT;
        }

        String getValue() {
            return this.value;
        }
    }

    static class TransformationMatrix {
        private static final String UNEXPECTED_NUMBER_OF_TRANSFORMATION_ATTRIBUTES = "Unexpected number of transformation attributes";
        private static final int NUMBER_OF_TRANSFORMATION_ATTRIBUTES = 6;
        private final double a;
        private final double b;
        private final double c;
        private final double d;
        private final double tx;
        private final double ty;

        TransformationMatrix(double a, double b, double c, double d, double tx, double ty) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.tx = tx;
            this.ty = ty;
        }

        static TransformationMatrix fromString(String string) {
            String[] attributes = string.split(" ");
            if (6 != attributes.length) {
                throw new IllegalStateException(UNEXPECTED_NUMBER_OF_TRANSFORMATION_ATTRIBUTES);
            }
            return new TransformationMatrix(Double.valueOf(attributes[0]), Double.valueOf(attributes[1]), Double.valueOf(attributes[2]), Double.valueOf(attributes[3]), Double.valueOf(attributes[4]), Double.valueOf(attributes[5]));
        }

        double getA() {
            return this.a;
        }

        double getB() {
            return this.b;
        }

        double getC() {
            return this.c;
        }

        double getD() {
            return this.d;
        }

        double getTx() {
            return this.tx;
        }

        double getTy() {
            return this.ty;
        }
    }
}

