/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters.fontmappings;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.filters.fontmappings.FontMapping;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.filters.fontmappings.ParametersStringFontMapping;

public final class ParametersStringFontMappingsInput
implements FontMappings.Input {
    static final String NAME = "fontMappings";
    static final String NUMBER = "number";
    private static final int DEFAULT_NUMBER_VALUE = 0;
    private static final String DEFAULT_STRING_VALUE = "";
    private final ParametersString parametersString;
    private List<FontMapping> fontMappings;

    public ParametersStringFontMappingsInput(ParametersString parametersString) {
        this.parametersString = parametersString;
    }

    @Override
    public Iterator<FontMapping> read() {
        if (null != this.fontMappings) {
            return Collections.emptyIterator();
        }
        this.fontMappings = new LinkedList<FontMapping>();
        ParametersString ps = new ParametersString(this.parametersString.getGroup(NAME, DEFAULT_STRING_VALUE));
        int numberOfMappings = ps.getInteger(NUMBER, 0);
        for (int i = 0; i < numberOfMappings; ++i) {
            String mappingString = ps.getGroup(String.valueOf(i), DEFAULT_STRING_VALUE);
            if (DEFAULT_STRING_VALUE.equals(mappingString)) continue;
            this.fontMappings.add(new ParametersStringFontMapping(new ParametersString(mappingString)));
        }
        return this.fontMappings.iterator();
    }
}

