/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.io.File;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.its.html5.HTML5Filter;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.its.ITSEngine;
import org.w3c.its.ITraversal;

public class Main {
    public static final String DC_TRANSLATE = "translate";
    public static final String DC_LOCALIZATIONNOTE = "locnote";
    public static final String DC_TERMINOLOGY = "terminology";
    public static final String DC_DIRECTIONALITY = "dir";
    public static final String DC_LANGUAGEINFORMATION = "lang";
    public static final String DC_WITHINTEXT = "withintext";
    public static final String DC_DOMAIN = "domain";
    public static final String DC_TEXTANALYSIS = "textanalysis";
    public static final String DC_LOCALEFILTER = "localefilter";
    public static final String DC_PROVENANCE = "provenance";
    public static final String DC_EXTERNALRESOURCE = "externalresource";
    public static final String DC_TARGETPOINTER = "targetpointer";
    public static final String DC_IDVALUE = "idvalue";
    public static final String DC_PRESERVESPACE = "preservespace";
    public static final String DC_LOCQUALITYISSUE = "locqualityissue";
    public static final String DC_LOCQUALITYRATING = "locqualityrating";
    public static final String DC_MTCONFIDENCE = "mtconfidence";
    public static final String DC_STORAGESIZE = "storagesize";
    public static final String DC_ALLOWEDCHARACTERS = "allowedcharacters";
    private static final String LINEBREAK = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintWriter writer = null;
        try {
            Node node;
            Document doc;
            System.out.println("-------------------------------------------------------");
            System.out.println("ITSTest - Test File Generator for XML+ITS and HTML5+ITS");
            System.out.println("-------------------------------------------------------");
            File inputFile = null;
            File outputFile = null;
            File rulesFile = null;
            String dc = DC_TRANSLATE;
            boolean isHTML5 = false;
            block24: for (int i = 0; i < args.length; ++i) {
                String arg;
                switch (arg = args[i]) {
                    case "-r": {
                        rulesFile = new File(args[++i]);
                        continue block24;
                    }
                    case "-dc": {
                        dc = args[++i].toLowerCase();
                        continue block24;
                    }
                    case "-?": {
                        Main.showUsage();
                        return;
                    }
                    case "-l": {
                        System.out.println("translate\nlocnote\nterminology\ndir\nlang\nwithintext\ndomain\ntextanalysis\nlocalefilter\nprovenance\nexternalresource\ntargetpointer\nidvalue\npreservespace\nlocqualityissue\nlocqualityrating\nmtconfidence\nstoragesize\nallowedcharacters");
                        return;
                    }
                    default: {
                        if (args[i].charAt(0) == '-') {
                            System.out.println("Invalid option. Use -? to see the valid options.");
                            return;
                        }
                        if (inputFile == null) {
                            inputFile = new File(args[i]);
                            isHTML5 = Util.getExtension(args[i]).toLowerCase().startsWith(".htm");
                            continue block24;
                        }
                        outputFile = new File(args[i]);
                    }
                }
            }
            if (inputFile == null) {
                Main.showUsage();
                return;
            }
            if (outputFile == null) {
                String name = inputFile.getAbsolutePath();
                int n = name.lastIndexOf(46);
                if (n > -1) {
                    name = name.substring(0, n);
                }
                name = name + "output";
                name = name + ".txt";
                outputFile = new File(name);
            }
            System.out.println("data category: " + dc);
            System.out.println(" input: " + inputFile.getAbsolutePath());
            System.out.println("output: " + outputFile.getAbsolutePath());
            if (rulesFile != null) {
                System.out.println(" rules: " + rulesFile.getAbsolutePath());
            }
            Util.createDirectories(outputFile.getAbsolutePath());
            writer = new PrintWriter(outputFile.getAbsolutePath(), "UTF-8");
            if (isHTML5) {
                HtmlDocumentBuilder docBuilder = new HtmlDocumentBuilder();
                doc = docBuilder.parse(inputFile);
            } else {
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                fact.setNamespaceAware(true);
                fact.setValidating(false);
                doc = fact.newDocumentBuilder().parse(inputFile);
            }
            ITraversal trav = Main.applyITSRules(doc, inputFile, rulesFile, isHTML5);
            String path = null;
            Stack<Integer> stack = new Stack<Integer>();
            stack.push(1);
            int prevCount = 0;
            trav.startTraversal();
            while ((node = trav.nextNode()) != null) {
                switch (node.getNodeType()) {
                    case 1: {
                        if (trav.backTracking()) {
                            int n = path.lastIndexOf(47);
                            if (n > -1) {
                                path = path.substring(0, n);
                            }
                            prevCount = (Integer)stack.pop();
                            break;
                        }
                        Element element = (Element)node;
                        Node prev = element;
                        while ((prev = prev.getPreviousSibling()) != null && (prev.getNodeType() != 1 || prev.getNodeType() == 1 && !prev.getNodeName().equals(element.getNodeName()))) {
                        }
                        if (prev != null && prev.getNodeName().equals(element.getNodeName())) {
                            stack.push(prevCount + 1);
                        } else {
                            stack.push(1);
                        }
                        path = element == doc.getDocumentElement() ? "/" + element.getNodeName() : path + String.format("/%s[%d]", element.getNodeName(), stack.peek());
                        Main.output(writer, dc, path, trav, null);
                        if (element.hasAttributes()) {
                            NamedNodeMap map = element.getAttributes();
                            ArrayList<String> list = new ArrayList<String>();
                            for (int i = 0; i < map.getLength(); ++i) {
                                list.add(map.item(i).getNodeName());
                            }
                            Collections.sort(list);
                            for (String attrName : list) {
                                Attr attr = (Attr)map.getNamedItem(attrName);
                                if (attr.getNodeName().startsWith("xmlns")) continue;
                                Main.output(writer, dc, path + "/@" + attr.getNodeName(), trav, attr);
                            }
                        }
                        if (element.hasChildNodes()) break;
                        int n = path.lastIndexOf(47);
                        if (n > -1) {
                            path = path.substring(0, n);
                        }
                        prevCount = (Integer)stack.pop();
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    private static void showUsage() {
        System.out.println("Usage: <inputFile>[ <outputFile>][ <options>]");
        System.out.println("Where the options are:");
        System.out.println(" -? shows this help");
        System.out.println(" -r <ruleFile> : associates the input with an ITS rule file");
        System.out.println(" -l : lists all the available data categories to use with -dc");
        System.out.println(" -dc <data-category> : sets the data category to process (default=translate)");
    }

    private static void output(PrintWriter writer, String dc, String path, ITraversal trav, Attr attr) {
        writer.print(path);
        String out1 = null;
        switch (dc) {
            case "translate": {
                out1 = trav.getTranslate(attr) ? "yes" : "no";
                writer.print(String.format("\ttranslate=\"%s\"", Main.escape(out1)));
                break;
            }
            case "locnote": {
                out1 = trav.getLocNote(attr);
                if (out1 == null) break;
                if ((out1 = Main.unwrap(out1)).startsWith("REF:")) {
                    writer.print(String.format("\tlocNoteRef=\"%s\"", Main.escape(out1.substring("REF:".length())).replace("&quot;", "\"")));
                } else {
                    writer.print(String.format("\tlocNote=\"%s\"", Main.escape(out1).replace("&quot;", "\"")));
                }
                out1 = trav.getLocNoteType(attr);
                writer.print(String.format("\tlocNoteType=\"%s\"", Main.escape(out1)));
                break;
            }
            case "terminology": {
                out1 = trav.getAnnotatorsRef();
                if (out1 != null) {
                    writer.print(String.format("\tannotatorsRef=\"%s\"", Main.escape(out1)));
                }
                out1 = trav.getTerm(attr) ? "yes" : "no";
                writer.print(String.format("\tterm=\"%s\"", Main.escape(out1)));
                Double outF1 = trav.getTermConfidence(attr);
                if (outF1 != null) {
                    writer.print(String.format("\ttermConfidence=\"%s\"", Util.formatDouble(outF1)));
                }
                if ((out1 = trav.getTermInfo(attr)) == null) break;
                if (out1.startsWith("REF:")) {
                    writer.print(String.format("\ttermInfoRef=\"%s\"", Main.escape(out1.substring("REF:".length()))));
                    break;
                }
                if (Util.isEmpty(out1)) break;
                writer.print(String.format("\ttermInfo=\"%s\"", Main.escape(Main.unwrap(out1))));
                break;
            }
            case "dir": {
                int dir = trav.getDirectionality(attr);
                switch (dir) {
                    case 2: {
                        out1 = "lro";
                        break;
                    }
                    case 0: {
                        out1 = "ltr";
                        break;
                    }
                    case 3: {
                        out1 = "rlo";
                        break;
                    }
                    case 1: {
                        out1 = "rtl";
                    }
                }
                writer.print(String.format("\tdir=\"%s\"", out1));
                break;
            }
            case "lang": {
                out1 = trav.getLanguage();
                if (out1 == null) break;
                writer.print(String.format("\tlang=\"%s\"", out1));
                break;
            }
            case "withintext": {
                if (attr != null) {
                    writer.print(LINEBREAK);
                    return;
                }
                int wt = trav.getWithinText();
                switch (wt) {
                    case 2: {
                        out1 = "nested";
                        break;
                    }
                    case 0: {
                        out1 = "no";
                        break;
                    }
                    case 1: {
                        out1 = "yes";
                    }
                }
                writer.print(String.format("\twithinText=\"%s\"", Main.escape(out1)));
                break;
            }
            case "domain": {
                out1 = trav.getDomains(attr);
                if (out1 == null) break;
                writer.print(String.format("\tdomains=\"%s\"", Main.escape(out1)));
                break;
            }
            case "textanalysis": {
                Double outFloat;
                out1 = trav.getAnnotatorsRef();
                if (out1 != null) {
                    writer.print(String.format("\tannotatorsRef=\"%s\"", Main.escape(out1)));
                }
                if ((out1 = trav.getTextAnalysisClass(attr)) != null) {
                    if (out1.startsWith("REF:")) {
                        writer.print(String.format("\ttaClassRef=\"%s\"", Main.escape(out1.substring("REF:".length()))));
                    } else {
                        writer.print(String.format("\ttaClass=\"%s\"", Main.escape(out1)));
                    }
                }
                if ((outFloat = trav.getTextAnalysisConfidence(attr)) != null) {
                    writer.print(String.format("\ttaConfidence=\"%s\"", Util.formatDouble(outFloat)));
                }
                if ((out1 = trav.getTextAnalysisIdent(attr)) != null) {
                    if (out1.startsWith("REF:")) {
                        writer.print(String.format("\ttaIdentRef=\"%s\"", Main.escape(out1.substring("REF:".length()))));
                    } else {
                        writer.print(String.format("\ttaIdent=\"%s\"", Main.escape(out1)));
                    }
                }
                if ((out1 = trav.getTextAnalysisSource(attr)) == null) break;
                writer.print(String.format("\ttaSource=\"%s\"", Main.escape(out1)));
                break;
            }
            case "localefilter": {
                out1 = trav.getLocaleFilter();
                if (out1 == null) break;
                boolean incFlag = true;
                if (out1.startsWith("!")) {
                    out1 = out1.substring(1);
                    incFlag = false;
                }
                writer.print(String.format("\tlocaleFilterList=\"%s\"", out1));
                writer.print(String.format("\tlocaleFilterType=\"%s\"", incFlag ? "include" : "exclude"));
                break;
            }
            case "provenance": {
                int count = trav.getProvRecordCount(attr);
                if (count == 0) {
                    writer.print(LINEBREAK);
                    return;
                }
                boolean standoff = false;
                out1 = trav.getProvRecordsRef(attr);
                if (out1 != null) {
                    writer.print(String.format("\tprovenanceRecordsRef=\"%s\"", Main.escape(out1)));
                    standoff = true;
                }
                for (int i = 0; i < count; ++i) {
                    Main.printProvString(standoff, trav.getProvOrg(attr, i), "org", i, writer);
                    Main.printProvString(standoff, trav.getProvPerson(attr, i), "person", i, writer);
                    Main.printProvString(standoff, trav.getProvRef(attr, i), "provRef", i, writer);
                    Main.printProvString(standoff, trav.getProvRevOrg(attr, i), "revOrg", i, writer);
                    Main.printProvString(standoff, trav.getProvRevPerson(attr, i), "revPerson", i, writer);
                    Main.printProvString(standoff, trav.getProvRevTool(attr, i), "revTool", i, writer);
                    Main.printProvString(standoff, trav.getProvTool(attr, i), "tool", i, writer);
                }
                break;
            }
            case "externalresource": {
                out1 = trav.getExternalResourceRef(attr);
                if (out1 == null) break;
                writer.print(String.format("\texternalResourceRef=\"%s\"", Main.escape(out1)));
                break;
            }
            case "targetpointer": {
                out1 = trav.getTargetPointer(attr);
                if (out1 == null) break;
                writer.print(String.format("\ttargetPointer=\"%s\"", Main.escape(out1)));
                break;
            }
            case "idvalue": {
                out1 = trav.getIdValue(attr);
                if (out1 == null) break;
                writer.print(String.format("\tidValue=\"%s\"", Main.escape(out1)));
                break;
            }
            case "preservespace": {
                out1 = trav.preserveWS(attr) ? "preserve" : "default";
                writer.print(String.format("\tspace=\"%s\"", Main.escape(out1)));
                break;
            }
            case "locqualityissue": {
                int count = trav.getLocQualityIssueCount(attr);
                if (count == 0) {
                    writer.print(LINEBREAK);
                    return;
                }
                boolean standoff = false;
                out1 = trav.getLocQualityIssuesRef(attr);
                if (out1 != null) {
                    writer.print(String.format("\tlocQualityIssuesRef=\"%s\"", Main.escape(out1)));
                    standoff = true;
                }
                for (int i = 0; i < count; ++i) {
                    Double outFloat1;
                    Boolean outBool1;
                    out1 = trav.getLocQualityIssueComment(attr, i);
                    if (out1 != null) {
                        if (standoff) {
                            writer.print(String.format("\tlocQualityIssueComment[%d]=\"%s\"", i + 1, Main.escape(out1)));
                        } else {
                            writer.print(String.format("\tlocQualityIssueComment=\"%s\"", Main.escape(out1)));
                        }
                    }
                    if ((outBool1 = trav.getLocQualityIssueEnabled(attr, i)) == null) {
                        throw new NullPointerException("lQI-enabled is null.");
                    }
                    if (standoff) {
                        writer.print(String.format("\tlocQualityIssueEnabled[%d]=\"%s\"", i + 1, outBool1 != false ? "yes" : "no"));
                    } else {
                        writer.print(String.format("\tlocQualityIssueEnabled=\"%s\"", outBool1 != false ? "yes" : "no"));
                    }
                    out1 = trav.getLocQualityIssueProfileRef(attr, i);
                    if (out1 != null) {
                        if (standoff) {
                            writer.print(String.format("\tlocQualityIssueProfileRef[%d]=\"%s\"", i + 1, Main.escape(out1)));
                        } else {
                            writer.print(String.format("\tlocQualityIssueProfileRef=\"%s\"", Main.escape(out1)));
                        }
                    }
                    if ((outFloat1 = trav.getLocQualityIssueSeverity(attr, i)) != null) {
                        if (standoff) {
                            writer.print(String.format("\tlocQualityIssueSeverity[%d]=\"%s\"", i + 1, Util.formatDouble(outFloat1)));
                        } else {
                            writer.print(String.format("\tlocQualityIssueSeverity=\"%s\"", Util.formatDouble(outFloat1)));
                        }
                    }
                    if ((out1 = trav.getLocQualityIssueType(attr, i)) == null) continue;
                    if (standoff) {
                        writer.print(String.format("\tlocQualityIssueType[%d]=\"%s\"", i + 1, Main.escape(out1)));
                        continue;
                    }
                    writer.print(String.format("\tlocQualityIssueType=\"%s\"", Main.escape(out1)));
                }
                break;
            }
            case "locqualityrating": {
                Integer outInt;
                Double outF1;
                out1 = trav.getLocQualityRatingProfileRef(attr);
                if (out1 != null) {
                    writer.print(String.format("\tlocQualityRatingProfileRef=\"%s\"", Main.escape(out1)));
                }
                if ((outF1 = trav.getLocQualityRatingScore(attr)) != null) {
                    writer.print(String.format("\tlocQualityRatingScore=\"%s\"", Util.formatDouble(outF1)));
                }
                if ((outF1 = trav.getLocQualityRatingScoreThreshold(attr)) != null) {
                    writer.print(String.format("\tlocQualityRatingScoreThreshold=\"%s\"", Util.formatDouble(outF1)));
                }
                if ((outInt = trav.getLocQualityRatingVote(attr)) != null) {
                    writer.print(String.format("\tlocQualityRatingVote=\"%d\"", outInt));
                }
                if ((outInt = trav.getLocQualityRatingVoteThreshold(attr)) == null) break;
                writer.print(String.format("\tlocQualityRatingVoteThreshold=\"%d\"", outInt));
                break;
            }
            case "mtconfidence": {
                Double outFloat1;
                out1 = trav.getAnnotatorsRef();
                if (out1 != null) {
                    writer.print(String.format("\tannotatorsRef=\"%s\"", Main.escape(out1)));
                }
                if ((outFloat1 = trav.getMtConfidence(attr)) == null) break;
                writer.print(String.format("\tmtConfidence=\"%s\"", Util.formatDouble(outFloat1)));
                break;
            }
            case "storagesize": {
                Integer intVal = trav.getStorageSize(attr);
                if (intVal == null) break;
                out1 = trav.getLineBreakType(attr);
                if (out1 != null) {
                    writer.print(String.format("\tlineBreakType=\"%s\"", out1));
                }
                if ((out1 = trav.getStorageEncoding(attr)) != null) {
                    writer.print(String.format("\tstorageEncoding=\"%s\"", Main.escape(out1).replace("UTF-8", "utf-8")));
                }
                writer.print(String.format("\tstorageSize=\"%d\"", intVal));
                break;
            }
            case "allowedcharacters": {
                out1 = trav.getAllowedCharacters(attr);
                if (out1 == null) break;
                writer.print(String.format("\tallowedCharacters=\"%s\"", Main.escape(out1)));
            }
        }
        writer.print(LINEBREAK);
    }

    private static void printProvString(boolean standoff, String value, String name, int index, PrintWriter writer) {
        if (value != null) {
            String suffix = "";
            if (value.startsWith("REF:")) {
                value = value.substring("REF:".length());
                suffix = "Ref";
            }
            if (standoff) {
                writer.print(String.format("\t%s%s[%d]=\"%s\"", name, suffix, index + 1, Main.escape(value)));
            } else {
                writer.print(String.format("\t%s%s=\"%s\"", name, suffix, Main.escape(value)));
            }
        }
    }

    private static String unwrap(String text) {
        TextFragment tf = new TextFragment(text);
        TextFragment.unwrap(tf);
        return tf.toString();
    }

    private static String escape(String text) {
        text = text.replace("\n", "\\n");
        text = text.replace("\t", "\\t");
        return Util.escapeToXML(text, 3, false, null);
    }

    private static ITraversal applyITSRules(Document doc, File inputFile, File rulesFile, boolean isHTML5) {
        ITSEngine itsEng = new ITSEngine(doc, inputFile.toURI(), isHTML5, null);
        if (isHTML5) {
            URL url = HTML5Filter.class.getResource("strict.fprm");
            try {
                itsEng.addExternalRules(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new OkapiBadFilterParametersException("Cannot load strict default parameters.");
            }
        }
        if (rulesFile != null) {
            itsEng.addExternalRules(rulesFile.toURI());
        }
        if (isHTML5) {
            HTML5Filter.loadLinkedRules(doc, inputFile.toURI(), itsEng);
        }
        itsEng.applyRules(-1L);
        return itsEng;
    }
}

