/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.codesremoval;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final int REMOVECODE_KEEPCONTENT = 0;
    public static final int KEEPCODE_REMOVECONTENT = 1;
    public static final int REMOVECODE_REMOVECONTENT = 2;
    private static final String STRIPSOURCE = "stripSource";
    private static final String STRIPTARGET = "stripTarget";
    private static final String MODE = "mode";
    private static final String INCLUDENONTRANSLATABLE = "includeNonTranslatable";
    private static final String REPLACEWITHSPACE = "replaceWithSpace";

    public boolean getStripSource() {
        return this.getBoolean(STRIPSOURCE);
    }

    public void setStripSource(boolean stripSource) {
        this.setBoolean(STRIPSOURCE, stripSource);
    }

    public boolean getStripTarget() {
        return this.getBoolean(STRIPTARGET);
    }

    public void setStripTarget(boolean stripTarget) {
        this.setBoolean(STRIPTARGET, stripTarget);
    }

    public int getMode() {
        return this.getInteger(MODE);
    }

    public void setMode(int mode) {
        this.setInteger(MODE, mode);
    }

    public boolean getIncludeNonTranslatable() {
        return this.getBoolean(INCLUDENONTRANSLATABLE);
    }

    public void setIncludeNonTranslatable(boolean includeNonTranslatable) {
        this.setBoolean(INCLUDENONTRANSLATABLE, includeNonTranslatable);
    }

    public boolean getReplaceWithSpace() {
        return this.getBoolean(REPLACEWITHSPACE);
    }

    public void setReplaceWithSpace(boolean replaceWithSpace) {
        this.setBoolean(REPLACEWITHSPACE, replaceWithSpace);
    }

    @Override
    public void reset() {
        super.reset();
        this.setStripSource(true);
        this.setStripTarget(true);
        this.setMode(2);
        this.setIncludeNonTranslatable(true);
        this.setReplaceWithSpace(false);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(MODE, "What to remove", "Select what parts of the inline codes to remove");
        desc.add(STRIPSOURCE, "Strip codes in the source text", null);
        desc.add(STRIPTARGET, "Strip codes in the target text", null);
        desc.add(INCLUDENONTRANSLATABLE, "Apply to non-translatable text units", null);
        desc.add(REPLACEWITHSPACE, "Replace line break codes with spaces (When removing content AND marker)", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Codes Removal", true, false);
        String[] values = new String[]{"0", "1", "2"};
        String[] labels = new String[]{"Remove code marker, but keep code content  (\"<ph x='1'>[X]</ph>\" ==> \"[X]\")", "Remove code content, but keep code marker  (\"<ph x='1'>[X]</ph>\" ==> \"<ph x='1'/>\")", "Remove code marker and code content  (\"<ph x='1'>[X]</ph>\" ==> \"\")"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(MODE), values);
        lsp.setChoicesLabels(labels);
        desc.addCheckboxPart(paramDesc.get(REPLACEWITHSPACE));
        desc.addCheckboxPart(paramDesc.get(STRIPSOURCE));
        desc.addCheckboxPart(paramDesc.get(STRIPTARGET));
        desc.addCheckboxPart(paramDesc.get(INCLUDENONTRANSLATABLE));
        return desc;
    }
}

